/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block;

import com.atsuishio.superbwarfare.block.entity.ContainerBlockEntity;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ContainerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPENED = BooleanProperty.create((String)"opened");

    public ContainerBlock() {
        this(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(3.0f).noOcclusion().requiresCorrectToolForDrops());
    }

    public ContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPENED, (Comparable)Boolean.valueOf(false)));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (level.isClientSide || ((Boolean)state.getValue((Property)OPENED)).booleanValue() || !((blockEntity = level.getBlockEntity(pos)) instanceof ContainerBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        ContainerBlockEntity containerBlockEntity = (ContainerBlockEntity)blockEntity;
        if (!stack.is((Item)ModItems.CROWBAR.get())) {
            player.displayClientMessage((Component)Component.translatable((String)"des.superbwarfare.container.fail.crowbar"), true);
            return ItemInteractionResult.FAIL;
        }
        if (!this.hasEntity(level, pos)) {
            player.displayClientMessage((Component)Component.translatable((String)"des.superbwarfare.container.fail.empty"), true);
            return ItemInteractionResult.FAIL;
        }
        if (ContainerBlock.canOpen(level, pos, containerBlockEntity.entityType)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPENED, (Comparable)Boolean.valueOf(true)));
            level.playSound(null, BlockPos.containing((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), (SoundEvent)ModSounds.OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        player.displayClientMessage((Component)Component.translatable((String)"des.superbwarfare.container.fail.open"), true);
        return ItemInteractionResult.FAIL;
    }

    public boolean hasEntity(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ContainerBlockEntity)) {
            return false;
        }
        ContainerBlockEntity containerBlockEntity = (ContainerBlockEntity)blockEntity;
        return containerBlockEntity.entityTag != null || containerBlockEntity.entityType != null;
    }

    public static boolean canOpen(Level level, BlockPos pos, EntityType<?> entityType) {
        boolean flag = true;
        int w = 0;
        int h = 0;
        if (entityType != null) {
            w = (int)(entityType.getDimensions().width() / 2.0f + 1.0f);
            h = (int)(entityType.getDimensions().height() + 1.0f);
        }
        for (int i = -w; i < w + 1; ++i) {
            for (int j = 0; j < h; ++j) {
                for (int k = -w; k < w + 1; ++k) {
                    BlockState state;
                    if (i == 0 && j == 0 && k == 0 || !(state = level.getBlockState(pos.offset(i, j, k))).canOcclude() || state.is(Blocks.SNOW)) continue;
                    flag = false;
                }
            }
        }
        return flag;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> pBlockEntityType) {
        if (!level.isClientSide) {
            return ContainerBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.CONTAINER.get()), ContainerBlockEntity::serverTick);
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        CompoundTag tag;
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        CompoundTag compoundTag = tag = data != null ? data.copyTag() : new CompoundTag();
        if (tag.contains("EntityType")) {
            String s = ContainerBlock.getEntityTranslationKey(tag.getString("EntityType"));
            tooltipComponents.add((Component)Component.translatable((String)(s == null ? "des.superbwarfare.container.empty" : s)).withStyle(ChatFormatting.GRAY));
            EntityType entityType = EntityType.byString((String)tag.getString("EntityType")).orElse(null);
            if (entityType != null) {
                float w = 0.0f;
                int h = 0;
                Level level = null;
                try {
                    level = context.level();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (level instanceof Level && tag.contains("Entity")) {
                    Entity entity = entityType.create(level);
                    if (entity != null) {
                        entity.load(tag.getCompound("Entity"));
                        w = (float)Math.ceil(entity.getType().getDimensions().width() / 2.0f);
                        h = (int)(entity.getType().getDimensions().height() + 1.0f);
                    }
                } else {
                    w = (float)Math.ceil(entityType.getDimensions().width() / 2.0f);
                    h = (int)(entityType.getDimensions().height() + 1.0f);
                }
                if (w != 0.0f && h != 0) {
                    if ((int)(w *= 2.0f) % 2 == 0) {
                        w += 1.0f;
                    }
                    tooltipComponents.add((Component)Component.literal((String)((int)w + " x " + (int)w + " x " + h)).withStyle(ChatFormatting.YELLOW));
                }
            }
        }
    }

    @Nullable
    public static String getEntityTranslationKey(String path) {
        String[] parts = path.split(":");
        if (parts.length > 1) {
            return "entity." + parts[0] + "." + parts[1];
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)OPENED) != false ? ContainerBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0) : ContainerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return ContainerBlock.simpleCodec(ContainerBlock::new);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new ContainerBlockEntity(blockPos, blockState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{OPENED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)OPENED, (Comparable)Boolean.valueOf(false));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack itemStack = super.getCloneItemStack(state, target, level, pos, player);
        level.getBlockEntity(pos, (BlockEntityType)ModBlockEntities.CONTAINER.get()).ifPresent(blockEntity -> blockEntity.saveToItem(itemStack, (HolderLookup.Provider)level.registryAccess()));
        return itemStack;
    }
}

