/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.CannonEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModSounds;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class JumpPadBlock
extends Block {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public JumpPadBlock() {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.STONE).strength(3.0f, 8.0f).noCollission().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @ParametersAreNonnullByDefault
    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)JumpPadBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{JumpPadBlock.box((double)-0.25, (double)-0.1, (double)-0.25, (double)2.0, (double)3.25, (double)2.0), JumpPadBlock.box((double)14.0, (double)-0.1, (double)-0.25, (double)16.25, (double)3.25, (double)2.0), JumpPadBlock.box((double)14.0, (double)-0.1, (double)14.0, (double)16.25, (double)3.25, (double)16.25), JumpPadBlock.box((double)-0.25, (double)-0.1, (double)14.0, (double)2.0, (double)3.25, (double)16.25), JumpPadBlock.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)JumpPadBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{JumpPadBlock.box((double)14.0, (double)-0.1, (double)14.0, (double)16.25, (double)3.25, (double)16.25), JumpPadBlock.box((double)-0.25, (double)-0.1, (double)14.0, (double)2.0, (double)3.25, (double)16.25), JumpPadBlock.box((double)-0.25, (double)-0.1, (double)-0.25, (double)2.0, (double)3.25, (double)2.0), JumpPadBlock.box((double)14.0, (double)-0.1, (double)-0.25, (double)16.25, (double)3.25, (double)2.0), JumpPadBlock.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)JumpPadBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{JumpPadBlock.box((double)-0.25, (double)-0.1, (double)14.0, (double)2.0, (double)3.25, (double)16.25), JumpPadBlock.box((double)-0.25, (double)-0.1, (double)-0.25, (double)2.0, (double)3.25, (double)2.0), JumpPadBlock.box((double)14.0, (double)-0.1, (double)-0.25, (double)16.25, (double)3.25, (double)2.0), JumpPadBlock.box((double)14.0, (double)-0.1, (double)14.0, (double)16.25, (double)3.25, (double)16.25), JumpPadBlock.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)JumpPadBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{JumpPadBlock.box((double)14.0, (double)-0.1, (double)-0.25, (double)16.25, (double)3.25, (double)2.0), JumpPadBlock.box((double)14.0, (double)-0.1, (double)14.0, (double)16.25, (double)3.25, (double)16.25), JumpPadBlock.box((double)-0.25, (double)-0.1, (double)14.0, (double)2.0, (double)3.25, (double)16.25), JumpPadBlock.box((double)-0.25, (double)-0.1, (double)-0.25, (double)2.0, (double)3.25, (double)2.0), JumpPadBlock.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    @ParametersAreNonnullByDefault
    public void entityInside(BlockState blockstate, Level level, BlockPos pos, Entity entity) {
        super.entityInside(blockstate, level, pos, entity);
        if (entity instanceof TargetEntity || entity instanceof CannonEntity) {
            return;
        }
        if (entity.isShiftKeyDown()) {
            if (entity.onGround()) {
                entity.setDeltaMovement(new Vec3(5.0 * entity.getLookAngle().x, 1.5, 5.0 * entity.getLookAngle().z));
            } else {
                entity.setDeltaMovement(new Vec3(1.8 * entity.getLookAngle().x, 1.5, 1.8 * entity.getLookAngle().z));
            }
        } else {
            entity.setDeltaMovement(new Vec3(0.7 * entity.getDeltaMovement().x(), 1.7, 0.7 * entity.getDeltaMovement().z()));
        }
        if (!level.isClientSide()) {
            level.playSound(null, BlockPos.containing((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), (SoundEvent)ModSounds.JUMP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)ModSounds.JUMP.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        entity.passengers.stream().filter(e -> {
            if (!(e instanceof Player)) return false;
            Player player = (Player)e;
            if (!player.level().isClientSide) return false;
            return true;
        }).findFirst().ifPresent(player -> Mod.queueClientWork(2, () -> {
            ClientEventHandler.canDoubleJump = true;
        }));
        if (entity instanceof Player) {
            Player player2 = (Player)entity;
            if (player2.level().isClientSide) {
                Mod.queueClientWork(2, () -> {
                    ClientEventHandler.canDoubleJump = true;
                });
            }
        }
    }
}

