/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block;

import com.atsuishio.superbwarfare.block.entity.VehicleDeployerBlockEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.mojang.serialization.MapCodec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleDeployerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;

    public VehicleDeployerBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(3.0f).requiresCorrectToolForDrops());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    private VehicleDeployerBlock(BlockBehaviour.Properties properties) {
        this();
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING}).add(new Property[]{TRIGGERED});
    }

    @ParametersAreNonnullByDefault
    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (level.isClientSide || !((blockEntity = level.getBlockEntity(pos)) instanceof VehicleDeployerBlockEntity)) {
            return ItemInteractionResult.SUCCESS;
        }
        VehicleDeployerBlockEntity blockEntity2 = (VehicleDeployerBlockEntity)blockEntity;
        if (!player.isCreative()) {
            return ItemInteractionResult.FAIL;
        }
        if (stack.getItem() != ModItems.CONTAINER.get()) {
            player.displayClientMessage((Component)Component.translatable((String)"des.superbwarfare.vehicle_deployer.fail").withStyle(ChatFormatting.RED), true);
            return ItemInteractionResult.FAIL;
        }
        blockEntity2.writeEntityInfo(stack);
        player.displayClientMessage((Component)Component.translatable((String)"des.superbwarfare.vehicle_deployer.success").withStyle(ChatFormatting.GREEN), true);
        return ItemInteractionResult.SUCCESS;
    }

    @ParametersAreNonnullByDefault
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean pMovedByPiston) {
        boolean charged = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
        boolean triggered = (Boolean)state.getValue((Property)TRIGGERED);
        if (charged && !triggered) {
            level.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.TRUE), 4);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof VehicleDeployerBlockEntity) {
                VehicleDeployerBlockEntity blockEntity2 = (VehicleDeployerBlockEntity)blockEntity;
                blockEntity2.deploy(state);
            }
        } else if (!charged && triggered) {
            level.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.FALSE), 4);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new VehicleDeployerBlockEntity(pos, state);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return VehicleDeployerBlock.simpleCodec(VehicleDeployerBlock::new);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }
}

