/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block.entity;

import com.atsuishio.superbwarfare.block.CreativeChargingStationBlock;
import com.atsuishio.superbwarfare.capability.energy.InfinityEnergyStorage;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreativeChargingStationBlockEntity
extends BlockEntity {
    public static final int CHARGE_RADIUS = 8;
    public boolean showRange = false;
    private final IEnergyStorage energyStorage = new InfinityEnergyStorage();

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("ShowRange", this.showRange);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @ParametersAreNonnullByDefault
    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        super.onDataPacket(connection, packet, registries);
        this.showRange = packet.getTag().getBoolean("ShowRange");
    }

    public CreativeChargingStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CREATIVE_CHARGING_STATION.get(), pos, state);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, CreativeChargingStationBlockEntity blockEntity) {
        if (blockEntity.showRange != (Boolean)pState.getValue((Property)CreativeChargingStationBlock.SHOW_RANGE)) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)CreativeChargingStationBlock.SHOW_RANGE, (Comparable)Boolean.valueOf(blockEntity.showRange)));
            CreativeChargingStationBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
        blockEntity.chargeEntity();
        blockEntity.chargeBlock();
    }

    private void chargeEntity() {
        if (this.level == null) {
            return;
        }
        if (this.level.getGameTime() % 20L != 0L) {
            return;
        }
        List entities = this.level.getEntitiesOfClass(Entity.class, new AABB(this.getBlockPos()).inflate(8.0));
        entities.forEach(entity -> {
            IEnergyStorage cap = (IEnergyStorage)entity.getCapability(Capabilities.EnergyStorage.ENTITY, null);
            if (cap == null || !cap.canReceive()) {
                return;
            }
            cap.receiveEnergy(Integer.MAX_VALUE, false);
        });
    }

    private void chargeBlock() {
        if (this.level == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            IEnergyStorage energy;
            BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(direction));
            if (blockEntity == null || (energy = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, blockEntity.getBlockPos(), (Object)direction)) == null || blockEntity instanceof CreativeChargingStationBlockEntity || !energy.canReceive() || energy.getEnergyStored() >= energy.getMaxEnergyStored()) continue;
            energy.receiveEnergy(Integer.MAX_VALUE, false);
            blockEntity.setChanged();
        }
    }

    @Nullable
    public IEnergyStorage getEnergyStorage(@Nullable Direction side) {
        return this.energyStorage;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.showRange = tag.getBoolean("ShowRange");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("ShowRange", this.showRange);
    }
}

