/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block.entity;

import com.atsuishio.superbwarfare.block.FuMO25Block;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.menu.FuMO25Menu;
import com.atsuishio.superbwarfare.network.dataslot.ContainerEnergyData;
import com.atsuishio.superbwarfare.tools.SeekTool;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FuMO25BlockEntity
extends BlockEntity
implements MenuProvider,
GeoBlockEntity {
    public static SerializableDataTicket<Integer> FUMO25_TICK;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final int MAX_ENERGY = 1000000;
    public static final int DEFAULT_RANGE = 96;
    public static final int MAX_RANGE = 128;
    public static final int GLOW_RANGE = 64;
    public static final int DEFAULT_ENERGY_COST = 256;
    public static final int MAX_ENERGY_COST = 1024;
    public static final int DEFAULT_MIN_ENERGY = 64000;
    public static final int MAX_DATA_COUNT = 5;
    private final IEnergyStorage energyStorage;
    public FuncType type = FuncType.NORMAL;
    public int time = 0;
    public boolean powered = false;
    public int tick = 0;
    public float yRot0 = 0.0f;
    protected final ContainerEnergyData dataAccess = new ContainerEnergyData(){

        @Override
        public int get(int pIndex) {
            return switch (pIndex) {
                case 0 -> FuMO25BlockEntity.this.energyStorage.getEnergyStored();
                case 1 -> FuMO25BlockEntity.this.type.ordinal();
                case 2 -> FuMO25BlockEntity.this.time;
                case 3 -> {
                    if (FuMO25BlockEntity.this.powered) {
                        yield 1;
                    }
                    yield 0;
                }
                case 4 -> FuMO25BlockEntity.this.tick;
                default -> 0;
            };
        }

        @Override
        public void set(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    FuMO25BlockEntity.this.energyStorage.receiveEnergy(pValue, false);
                    break;
                }
                case 1: {
                    FuMO25BlockEntity.this.type = FuncType.values()[pValue];
                    break;
                }
                case 2: {
                    FuMO25BlockEntity.this.time = pValue;
                    break;
                }
                case 3: {
                    FuMO25BlockEntity.this.powered = pValue == 1;
                    break;
                }
                case 4: {
                    FuMO25BlockEntity.this.tick = pValue;
                }
            }
        }

        @Override
        public int getCount() {
            return 5;
        }
    };

    public FuMO25BlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FUMO_25.get(), pPos, pBlockState);
        this.energyStorage = new EnergyStorage(1000000);
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        return this.energyStorage;
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, FuMO25BlockEntity blockEntity) {
        if (((Boolean)pState.getValue((Property)FuMO25Block.POWERED)).booleanValue()) {
            ++blockEntity.tick;
            blockEntity.setAnimData(FUMO25_TICK, blockEntity.tick);
        }
        IEnergyStorage energyStorage = blockEntity.getEnergyStorage(null);
        int energy = energyStorage.getEnergyStored();
        ++blockEntity.tick;
        FuncType funcType = blockEntity.type;
        int energyCost = funcType == FuncType.WIDER ? 1024 : 256;
        if (energy < energyCost) {
            if (((Boolean)pState.getValue((Property)FuMO25Block.POWERED)).booleanValue()) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)FuMO25Block.POWERED, (Comparable)Boolean.valueOf(false)));
                pLevel.playSound(null, pPos, (SoundEvent)ModSounds.RADAR_SEARCH_END.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                blockEntity.powered = false;
                FuMO25BlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
            if (blockEntity.time > 0) {
                blockEntity.time = 0;
                blockEntity.setChanged();
            }
        } else if (!((Boolean)pState.getValue((Property)FuMO25Block.POWERED)).booleanValue()) {
            if (energy >= 64000) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)FuMO25Block.POWERED, (Comparable)Boolean.valueOf(true)));
                pLevel.playSound(null, pPos, (SoundEvent)ModSounds.RADAR_SEARCH_START.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                blockEntity.powered = true;
                FuMO25BlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
        } else {
            energyStorage.extractEnergy(energyCost, false);
            if (blockEntity.tick == 200) {
                pLevel.playSound(null, pPos, (SoundEvent)ModSounds.RADAR_SEARCH_IDLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (blockEntity.time > 0) {
                if (blockEntity.time % 100 == 0) {
                    blockEntity.setGlowEffect();
                }
                --blockEntity.time;
                blockEntity.setChanged();
            }
        }
        if (blockEntity.tick >= 200) {
            blockEntity.tick = 0;
        }
        if (blockEntity.time <= 0 && blockEntity.type != FuncType.NORMAL) {
            blockEntity.type = FuncType.NORMAL;
            blockEntity.setChanged();
        }
    }

    private void setGlowEffect() {
        if (this.type != FuncType.GLOW) {
            return;
        }
        Level level = this.level;
        if (level == null) {
            return;
        }
        BlockPos pos = this.getBlockPos();
        List<Entity> entities = SeekTool.getEntitiesWithinRange(pos, level, 64.0);
        entities.forEach(e -> {
            if (e instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)e;
                living.addEffect(new MobEffectInstance(MobEffects.GLOWING, 100, 0, true, false));
            }
        });
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        Tag energyTag = tag.get("Energy");
        if (energyTag != null) {
            ((EnergyStorage)this.energyStorage).deserializeNBT(registries, energyTag);
        }
        this.type = FuncType.values()[Mth.clamp((int)tag.getInt("Type"), (int)0, (int)3)];
        this.time = tag.getInt("Time");
        this.powered = tag.getBoolean("Powered");
    }

    @ParametersAreNonnullByDefault
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("Energy", ((EnergyStorage)this.energyStorage).serializeNBT(registries));
        tag.putInt("Type", this.type.ordinal());
        tag.putInt("Time", this.time);
        tag.putBoolean("Powered", this.powered);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        if (this.level == null) {
            return null;
        }
        return new FuMO25Menu(pContainerId, pPlayerInventory, ContainerLevelAccess.create((Level)this.level, (BlockPos)this.getBlockPos()), this.dataAccess);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum FuncType {
        NORMAL,
        WIDER,
        GLOW,
        GUIDE;

    }
}

