/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block.entity;

import com.atsuishio.superbwarfare.block.VehicleDeployerBlock;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Math;

public class VehicleDeployerBlockEntity
extends BlockEntity {
    public CompoundTag entityData = new CompoundTag();

    public VehicleDeployerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.VEHICLE_DEPLOYER.get(), pPos, pBlockState);
    }

    @ParametersAreNonnullByDefault
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.entityData.contains("EntityType")) {
            tag.putString("EntityType", this.entityData.getString("EntityType"));
        }
        if (this.entityData.contains("Entity")) {
            tag.put("Entity", (Tag)this.entityData.getCompound("Entity"));
        }
    }

    @ParametersAreNonnullByDefault
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.entityData = tag.copy();
    }

    public void deploy(BlockState state) {
        if (this.level == null) {
            return;
        }
        if (this.entityData.contains("EntityType")) {
            EntityType entityType = EntityType.byString((String)this.entityData.getString("EntityType")).orElse(null);
            if (entityType == null) {
                return;
            }
            Entity entity = entityType.create(this.level);
            if (entity == null) {
                return;
            }
            if (this.entityData.contains("Entity")) {
                CompoundTag entityTag = this.entityData.getCompound("Entity").copy();
                entityTag.remove("UUID");
                entity.load(entityTag);
            }
            Direction direction = (Direction)state.getValue((Property)VehicleDeployerBlock.FACING);
            entity.setUUID(UUID.randomUUID());
            entity.setPos((double)this.getBlockPos().getX() + 0.5 + (2.0 * Math.random() - 1.0) * (double)0.1f, (double)this.getBlockPos().getY() + 1.5 + (2.0 * Math.random() - 1.0) * (double)0.1f, (double)this.getBlockPos().getZ() + 0.5 + (2.0 * Math.random() - 1.0) * (double)0.1f);
            entity.setYRot(direction.toYRot());
            this.level.addFreshEntity(entity);
        }
    }

    public void writeEntityInfo(ItemStack stack) {
        CustomData tag = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (tag == null) {
            return;
        }
        this.entityData = tag.copyTag();
    }
}

