/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.subdata.Attachment;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.cache.object.GeoBone;

public class ItemModelHelper {
    public static void handleGunAttachments(GeoBone bone, ItemStack stack, String name) {
        Attachment attachments = GunData.from((ItemStack)stack).attachment;
        ItemModelHelper.splitBoneName(bone, name, attachments, AttachmentType.SCOPE);
        ItemModelHelper.splitBoneName(bone, name, attachments, AttachmentType.MAGAZINE);
        ItemModelHelper.splitBoneName(bone, name, attachments, AttachmentType.BARREL);
        ItemModelHelper.splitBoneName(bone, name, attachments, AttachmentType.STOCK);
        ItemModelHelper.splitBoneName(bone, name, attachments, AttachmentType.GRIP);
    }

    private static void splitBoneName(GeoBone bone, String boneName, Attachment attachment, AttachmentType type) {
        try {
            String[] parts;
            if (boneName.startsWith(type.getName()) && (parts = boneName.split("(?<=\\D)(?=\\d)")).length == 2) {
                int index = Integer.parseInt(parts[1]);
                bone.setHidden(attachment.get(type) != index);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static void hideAllAttachments(GeoBone bone, String name) {
        ItemModelHelper.splitAndHideBone(bone, name, "Scope");
        ItemModelHelper.splitAndHideBone(bone, name, "Magazine");
        ItemModelHelper.splitAndHideBone(bone, name, "Barrel");
        ItemModelHelper.splitAndHideBone(bone, name, "Stock");
        ItemModelHelper.splitAndHideBone(bone, name, "Grip");
    }

    private static void splitAndHideBone(GeoBone bone, String boneName, String tagName) {
        try {
            String[] parts;
            if (boneName.startsWith(tagName) && (parts = boneName.split("(?<=\\D)(?=\\d)")).length == 2) {
                int index = Integer.parseInt(parts[1]);
                bone.setHidden(index != 0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

