/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.ClickHandler;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.VehicleHudOverlay;
import com.atsuishio.superbwarfare.entity.vehicle.A10Entity;
import com.atsuishio.superbwarfare.entity.vehicle.base.AircraftEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

@OnlyIn(value=Dist.CLIENT)
public class AircraftOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("aircraft_hud");
    private static float lerpVy = 1.0f;
    private static float lerpLock = 1.0f;
    private static float lerpG = 1.0f;
    private static final ResourceLocation FRAME = Mod.loc("textures/screens/aircraft/frame.png");
    private static final ResourceLocation FRAME_TARGET = Mod.loc("textures/screens/aircraft/frame_target.png");
    private static final ResourceLocation FRAME_LOCK = Mod.loc("textures/screens/aircraft/frame_lock.png");
    private static final ResourceLocation IND_1 = Mod.loc("textures/screens/aircraft/locking_ind1.png");
    private static final ResourceLocation IND_2 = Mod.loc("textures/screens/aircraft/locking_ind2.png");
    private static final ResourceLocation IND_3 = Mod.loc("textures/screens/aircraft/locking_ind3.png");
    private static final ResourceLocation IND_4 = Mod.loc("textures/screens/aircraft/locking_ind4.png");

    public void render(GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        AircraftEntity aircraftEntity;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        PoseStack poseStack = guiGraphics.pose();
        Vec3 lookVec = new Vec3(camera.getLookVector());
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(true);
        if (player == null) {
            return;
        }
        if (ClickHandler.isEditing) {
            return;
        }
        Entity entity = player.getVehicle();
        if (entity instanceof AircraftEntity && (aircraftEntity = (AircraftEntity)entity) instanceof MobileVehicleEntity) {
            MobileVehicleEntity mobileVehicle = (MobileVehicleEntity)((Object)aircraftEntity);
            if (aircraftEntity.isDriver((Player)player) && (entity = player.getVehicle()) instanceof WeaponVehicleEntity) {
                A10Entity a10Entity;
                float y;
                float x;
                WeaponVehicleEntity weaponVehicle = (WeaponVehicleEntity)entity;
                poseStack.pushPose();
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                lerpVy = (float)Mth.lerp((double)(0.021f * partialTick), (double)lerpVy, (double)mobileVehicle.getDeltaMovement().y());
                float diffY = (float)ClientMouseHandler.lerpSpeedX;
                float diffX = (float)ClientMouseHandler.lerpSpeedY;
                float fovAdjust2 = (float)((Integer)Minecraft.getInstance().options.fov().get() / 30) - 1.0f;
                double zoom = 3.0 + 0.06 * (double)fovAdjust2;
                Vec3 pos = cameraPos.add(mobileVehicle.getViewVector(partialTick).scale(192.0));
                Vec3 lookAngle = lookVec.normalize().scale(pos.distanceTo(cameraPos) * (1.0 - 1.0 / zoom));
                Vec3 posCross = aircraftEntity.shootPos(partialTick).add(aircraftEntity.shootVec(partialTick).scale(192.0));
                Vec3 lookAngle2 = lookVec.normalize().scale(posCross.distanceTo(cameraPos) * (1.0 - 1.0 / zoom));
                Vec3 cPos = cameraPos.add(lookAngle);
                Vec3 cPos2 = cameraPos.add(lookAngle2);
                Vec3 p = RenderHelper.worldToScreen(pos, ClientEventHandler.zoomVehicle ? cPos : cameraPos);
                Vec3 pCross = RenderHelper.worldToScreen(posCross, ClientEventHandler.zoomVehicle ? cPos2 : cameraPos);
                if (p != null) {
                    poseStack.pushPose();
                    x = (float)p.x;
                    y = (float)p.y;
                    if (mc.options.getCameraType() == CameraType.FIRST_PERSON) {
                        RenderSystem.disableDepthTest();
                        RenderSystem.depthMask((boolean)false);
                        RenderSystem.enableBlend();
                        RenderSystem.setShader(GameRenderer::getPositionTexShader);
                        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        if (mobileVehicle instanceof A10Entity && weaponVehicle.getWeaponIndex(0) == 3) {
                            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/aircraft/hud_base_missile.png"), x - 160.0f, y - 160.0f, 0.0f, 0.0f, 320.0f, 320.0f, 320.0f, 320.0f);
                        } else {
                            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/aircraft/hud_base.png"), x - 160.0f, y - 160.0f, 0.0f, 0.0f, 320.0f, 320.0f, 320.0f, 320.0f);
                        }
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/compass.png"), x - 128.0f, y - 122.0f, 128.0f + 1.4222223f * mobileVehicle.getYRot(), 0.0f, 256.0f, 16.0f, 512.0f, 16.0f);
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/aircraft/compass_ind.png"), x - 4.0f, y - 130.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
                        poseStack.pushPose();
                        poseStack.rotateAround(Axis.ZP.rotationDegrees(aircraftEntity.getRotZ(partialTick)), x, y + 48.0f, 0.0f);
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/helicopter/roll_ind.png"), x - 4.0f, y + 144.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
                        poseStack.popPose();
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.format0D(mobileVehicle.getDeltaMovement().dot(mobileVehicle.getViewVector(1.0f)) * 72.0)), (int)x - 105, (int)y - 61, 0x66FF00, false);
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.format0D(mobileVehicle.getY())), (int)x + 111 - 36, (int)y - 61, 0x66FF00, false);
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/helicopter/speed_frame.png"), x - 108.0f, y - 64.0f, 0.0f, 0.0f, 36.0f, 12.0f, 36.0f, 12.0f);
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/helicopter/speed_frame.png"), x + 108.0f - 36.0f, y - 64.0f, 0.0f, 0.0f, 36.0f, 12.0f, 36.0f, 12.0f);
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.DECIMAL_FORMAT_1ZZ.format(lerpVy * 20.0f)), (int)x - 96, (int)y + 60, 0x66FF00, false);
                        lerpG = (float)Mth.lerp((double)(0.1f * partialTick), (double)lerpG, (double)(mobileVehicle.acceleration / 9.8));
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"M"), (int)x - 105, (int)y + 70, 0x66FF00, false);
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"0.2"), (int)x - 96, (int)y + 70, 0x66FF00, false);
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"G"), (int)x - 105, (int)y + 78, 0x66FF00, false);
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)FormatTool.DECIMAL_FORMAT_1ZZ.format(lerpG)), (int)x - 96, (int)y + 78, 0x66FF00, false);
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("IR FLARES " + aircraftEntity.getDecoy())), (int)x + 72, (int)y, 0x66FF00, false);
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"TGT"), (int)x + 76, (int)y + 78, 0x66FF00, false);
                        if (mobileVehicle instanceof A10Entity) {
                            A10Entity a10Entity2 = (A10Entity)mobileVehicle;
                            if (weaponVehicle.getWeaponIndex(0) == 0) {
                                double heat = 1.0f - (float)((Integer)a10Entity2.getEntityData().get(VehicleEntity.HEAT)).intValue() / 100.0f;
                                String name = "30MM CANNON";
                                int width = Minecraft.getInstance().font.width(name);
                                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)name), (int)x - width / 2, (int)y + 67, Mth.hsvToRgb((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
                                String count = InventoryTool.hasCreativeAmmoBox((Player)player) ? "\u221e" : String.valueOf(aircraftEntity.getAmmoCount((Player)player));
                                int width2 = Minecraft.getInstance().font.width(count);
                                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)count), (int)x - width2 / 2, (int)y + 76, Mth.hsvToRgb((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
                            } else if (weaponVehicle.getWeaponIndex(0) == 1) {
                                String name = "70MM ROCKET";
                                width = Minecraft.getInstance().font.width(name);
                                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)name), (int)x - width / 2, (int)y + 67, 0x66FF00, false);
                                count = String.valueOf(aircraftEntity.getAmmoCount((Player)player));
                                width2 = Minecraft.getInstance().font.width(count);
                                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)count), (int)x - width2 / 2, (int)y + 76, 0x66FF00, false);
                            } else if (weaponVehicle.getWeaponIndex(0) == 2) {
                                String name = "MK82 BOMB";
                                width = Minecraft.getInstance().font.width(name);
                                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)name), (int)x - width / 2, (int)y + 67, 0x66FF00, false);
                                count = String.valueOf(aircraftEntity.getAmmoCount((Player)player));
                                width2 = Minecraft.getInstance().font.width(count);
                                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)count), (int)x - width2 / 2, (int)y + 76, 0x66FF00, false);
                            } else if (weaponVehicle.getWeaponIndex(0) == 3) {
                                String name = "AGM-65";
                                width = Minecraft.getInstance().font.width(name);
                                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)name), (int)x - width / 2, (int)y + 67, 0x66FF00, false);
                                count = String.valueOf(aircraftEntity.getAmmoCount((Player)player));
                                width2 = Minecraft.getInstance().font.width(count);
                                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)count), (int)x - width2 / 2, (int)y + 76, 0x66FF00, false);
                            }
                        }
                        poseStack.pushPose();
                        RenderSystem.disableDepthTest();
                        RenderSystem.depthMask((boolean)false);
                        RenderSystem.enableBlend();
                        RenderSystem.setShader(GameRenderer::getPositionTexShader);
                        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        poseStack.rotateAround(Axis.ZP.rotationDegrees(-aircraftEntity.getRotZ(partialTick)), x, y, 0.0f);
                        float pitch = aircraftEntity.getRotX(partialTick);
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/aircraft/hud_line.png"), x - 96.0f + diffY, y - 128.0f, 0.0f, 448.0f + 4.10625f * pitch, 192.0f, 256.0f, 192.0f, 1152.0f);
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/aircraft/hud_ind.png"), x - 18.0f + diffY, y - 12.0f, 0.0f, 0.0f, 36.0f, 24.0f, 36.0f, 24.0f);
                        poseStack.popPose();
                        if ((double)mobileVehicle.getEnergy() < 0.02 * (double)mobileVehicle.getMaxEnergy()) {
                            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"NO POWER!"), (int)x - 144, (int)y + 14, -65536, false);
                        } else if ((double)mobileVehicle.getEnergy() < 0.2 * (double)mobileVehicle.getMaxEnergy()) {
                            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)"LOW POWER"), (int)x - 144, (int)y + 14, 16739072, false);
                        }
                    }
                }
                if (pCross != null) {
                    A10Entity a10Entity3;
                    poseStack.pushPose();
                    x = (float)pCross.x;
                    y = (float)pCross.y + (ClientEventHandler.zoomVehicle ? 15.0f * (float)((Integer)Minecraft.getInstance().options.fov().get() / 70) : 5.0f);
                    if (!(mc.options.getCameraType() != CameraType.FIRST_PERSON || mobileVehicle instanceof A10Entity && (a10Entity3 = (A10Entity)mobileVehicle).getWeaponIndex(0) == 3)) {
                        RenderSystem.disableDepthTest();
                        RenderSystem.depthMask((boolean)false);
                        RenderSystem.enableBlend();
                        RenderSystem.setShader(GameRenderer::getPositionTexShader);
                        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/aircraft/hud_base2.png"), x - 72.0f + diffY, y - 72.0f + diffX, 0.0f, 0.0f, 144.0f, 144.0f, 144.0f, 144.0f);
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/aircraft/crosshair_ind.png"), x - 16.0f, y - 16.0f, 0.0f, 0.0f, 32.0f, 32.0f, 32.0f, 32.0f);
                        AircraftOverlay.renderKillIndicator(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
                    } else if (mc.options.getCameraType() == CameraType.THIRD_PERSON_BACK) {
                        poseStack.pushPose();
                        poseStack.rotateAround(Axis.ZP.rotationDegrees(aircraftEntity.getRotZ(partialTick)), x, y, 0.0f);
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/drone.png"), x - 8.0f, y - 8.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
                        AircraftOverlay.renderKillIndicator(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
                        poseStack.pushPose();
                        poseStack.translate(x, y, 0.0f);
                        poseStack.scale(0.75f, 0.75f, 1.0f);
                        if (mobileVehicle instanceof A10Entity) {
                            A10Entity a10Entity4 = (A10Entity)mobileVehicle;
                            if (weaponVehicle.getWeaponIndex(0) == 0) {
                                double heat = (float)((Integer)a10Entity4.getEntityData().get(VehicleEntity.HEAT)).intValue() / 100.0f;
                                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("30MM CANNON " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Player)player) ? "\u221e" : Integer.valueOf(aircraftEntity.getAmmoCount((Player)player))))), 25, -9, Mth.hsvToRgb((float)0.0f, (float)((float)heat), (float)1.0f), false);
                            } else if (weaponVehicle.getWeaponIndex(0) == 1) {
                                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("70MM ROCKET " + aircraftEntity.getAmmoCount((Player)player))), 25, -9, -1, false);
                            } else if (weaponVehicle.getWeaponIndex(0) == 2) {
                                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("MK82 BOMB " + aircraftEntity.getAmmoCount((Player)player))), 25, -9, -1, false);
                            } else if (weaponVehicle.getWeaponIndex(0) == 3) {
                                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("AGM-65 " + aircraftEntity.getAmmoCount((Player)player))), 25, -9, -1, false);
                            }
                        }
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("IR FLARES " + aircraftEntity.getDecoy())), 25, 1, -1, false);
                        poseStack.popPose();
                        poseStack.popPose();
                    }
                    poseStack.popPose();
                }
                if (mobileVehicle instanceof A10Entity && (a10Entity = (A10Entity)mobileVehicle).getWeaponIndex(0) == 3) {
                    Entity targetEntity = EntityFindUtil.findEntity(player.level(), a10Entity.getTargetUuid());
                    List<Entity> entities = SeekTool.seekCustomSizeEntities(a10Entity, player.level(), 384.0, 20.0, 0.9, true);
                    for (Entity e : entities) {
                        Vec3 pos3 = new Vec3(Mth.lerp((double)partialTick, (double)e.xo, (double)e.getX()), Mth.lerp((double)partialTick, (double)(e.yo + (double)e.getEyeHeight()), (double)e.getEyeY()), Mth.lerp((double)partialTick, (double)e.zo, (double)e.getZ()));
                        Vec3 lookAngle3 = lookVec.normalize().scale(pos3.distanceTo(cameraPos) * (1.0 - 1.0 / zoom));
                        Vec3 cPos3 = cameraPos.add(lookAngle3);
                        Vec3 point = RenderHelper.worldToScreen(pos3, ClientEventHandler.zoomVehicle ? cPos3 : cameraPos);
                        if (point == null) continue;
                        boolean nearest = e == targetEntity;
                        boolean lockOn = a10Entity.locked && nearest;
                        poseStack.pushPose();
                        float x2 = (float)point.x;
                        float y2 = (float)point.y;
                        if (lockOn) {
                            RenderHelper.preciseBlit(guiGraphics, FRAME_LOCK, x2 - 12.0f, y2 - 12.0f, 24.0f, 24.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                        } else if (nearest) {
                            lerpLock = Mth.lerp((float)partialTick, (float)lerpLock, (float)(2 * a10Entity.lockTime));
                            float lockTime = Mth.clamp((float)(20.0f - lerpLock), (float)0.0f, (float)20.0f);
                            RenderHelper.preciseBlit(guiGraphics, IND_1, x2 - 12.0f, y2 - 12.0f - lockTime, 24.0f, 24.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                            RenderHelper.preciseBlit(guiGraphics, IND_2, x2 - 12.0f, y2 - 12.0f + lockTime, 24.0f, 24.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                            RenderHelper.preciseBlit(guiGraphics, IND_3, x2 - 12.0f - lockTime, y2 - 12.0f, 24.0f, 24.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                            RenderHelper.preciseBlit(guiGraphics, IND_4, x2 - 12.0f + lockTime, y2 - 12.0f, 24.0f, 24.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                            RenderHelper.preciseBlit(guiGraphics, FRAME_TARGET, x2 - 12.0f, y2 - 12.0f, 24.0f, 24.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                        } else {
                            RenderHelper.preciseBlit(guiGraphics, FRAME, x2 - 12.0f, y2 - 12.0f, 24.0f, 24.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                        }
                        poseStack.popPose();
                    }
                }
                poseStack.popPose();
            }
        }
    }

    private static void renderKillIndicator(GuiGraphics guiGraphics, float posX, float posY) {
        VehicleHudOverlay.renderKillIndicator3P(guiGraphics, posX, posY);
    }

    public static double length(double x, double y, double z) {
        return Math.sqrt((double)(x * x + y * y + z * z));
    }
}

