/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AmmoBarOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("ammo_bar");
    private static final ResourceLocation LINE = Mod.loc("textures/gun_icon/fire_mode/line.png");
    private static final ResourceLocation SEMI = Mod.loc("textures/gun_icon/fire_mode/semi.png");
    private static final ResourceLocation BURST = Mod.loc("textures/gun_icon/fire_mode/burst.png");
    private static final ResourceLocation AUTO = Mod.loc("textures/gun_icon/fire_mode/auto.png");
    private static final ResourceLocation TOP = Mod.loc("textures/gun_icon/fire_mode/top.png");
    private static final ResourceLocation DIR = Mod.loc("textures/gun_icon/fire_mode/dir.png");
    private static final ResourceLocation MOUSE = Mod.loc("textures/gun_icon/fire_mode/mouse.png");

    private static boolean hasCreativeAmmo() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        return player.isCreative() || InventoryTool.hasCreativeAmmoBox((Player)player);
    }

    private static String getGunAmmoString(GunData data, Player player) {
        if (data.useBackpackAmmo() && AmmoBarOverlay.hasCreativeAmmo()) {
            return "\u221e";
        }
        return data.useBackpackAmmo() ? "" + data.countBackupAmmo(player) : "" + data.ammo.get();
    }

    private static String getBackupAmmoString(GunData data, Player player) {
        if (data.useBackpackAmmo()) {
            return "";
        }
        return AmmoBarOverlay.hasCreativeAmmo() ? "\u221e" : "" + data.countBackupAmmo(player);
    }

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!((Boolean)DisplayConfig.AMMO_HUD.get()).booleanValue()) {
            return;
        }
        int w = guiGraphics.guiWidth();
        int h = guiGraphics.guiHeight();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof GunItem) {
            ArmedVehicleEntity vehicle;
            GunItem gunItem = (GunItem)item;
            item = player.getVehicle();
            if (!(item instanceof ArmedVehicleEntity) || !(vehicle = (ArmedVehicleEntity)item).banHand((Player)player)) {
                CompoundTag tag = NBTTool.getTag(stack);
                int x = w + (Integer)DisplayConfig.WEAPON_HUD_X_OFFSET.get();
                int y = h + (Integer)DisplayConfig.WEAPON_HUD_Y_OFFSET.get();
                PoseStack poseStack = guiGraphics.pose();
                GunData data = GunData.from(stack);
                guiGraphics.blit(gunItem.getGunIcon(), x - 135, y - 40, 0.0f, 0.0f, 64, 16, 64, 16);
                if (stack.getItem() != ModItems.MINIGUN.get()) {
                    guiGraphics.drawString(Minecraft.getInstance().font, "[" + ModKeyMappings.FIRE_MODE.getKey().getDisplayName().getString() + "]", (float)x - 111.5f, (float)(y - 20), 0xFFFFFF, false);
                }
                ResourceLocation fireMode = AmmoBarOverlay.getFireMode(data);
                if (stack.getItem() == ModItems.JAVELIN.get()) {
                    ResourceLocation resourceLocation = fireMode = tag.getBoolean("TopMode") ? TOP : DIR;
                }
                if (stack.getItem() == ModItems.MINIGUN.get()) {
                    fireMode = MOUSE;
                    guiGraphics.drawString(Minecraft.getInstance().font, data.rpm() + " RPM", (float)x - 111.0f, (float)(y - 20), 0xFFFFFF, false);
                    guiGraphics.blit(fireMode, x - 126, y - 22, 0.0f, 0.0f, 12, 12, 12, 12);
                } else {
                    guiGraphics.blit(fireMode, x - 95, y - 21, 0.0f, 0.0f, 8, 8, 8, 8);
                }
                if (stack.getItem() != ModItems.MINIGUN.get() && stack.getItem() != ModItems.TRACHELIUM.get()) {
                    guiGraphics.blit(LINE, x - 95, y - 16, 0.0f, 0.0f, 8, 8, 8, 8);
                }
                poseStack.pushPose();
                poseStack.scale(1.5f, 1.5f, 1.0f);
                guiGraphics.drawString(Minecraft.getInstance().font, AmmoBarOverlay.getGunAmmoString(data, (Player)player), (float)x / 1.5f - 42.666668f, (float)y / 1.5f - 32.0f, 0xFFFFFF, true);
                poseStack.popPose();
                guiGraphics.drawString(Minecraft.getInstance().font, AmmoBarOverlay.getBackupAmmoString(data, (Player)player), x - 64, y - 35, 0xCCCCCC, true);
                poseStack.pushPose();
                poseStack.scale(0.9f, 0.9f, 1.0f);
                String gunName = gunItem.getGunDisplayName();
                guiGraphics.drawString(Minecraft.getInstance().font, gunName, (float)x / 0.9f - (100.0f + (float)Minecraft.getInstance().font.width(gunName) / 2.0f) / 0.9f, (float)y / 0.9f - 66.66667f, 0xFFFFFF, true);
                String ammoName = gunItem.getAmmoDisplayName(data);
                guiGraphics.drawString(Minecraft.getInstance().font, ammoName, (float)x / 0.9f - (100.0f + (float)Minecraft.getInstance().font.width(ammoName) / 2.0f) / 0.9f, (float)y / 0.9f - 56.666668f, 13149817, true);
                poseStack.popPose();
            }
        }
    }

    private static ResourceLocation getFireMode(GunData data) {
        return switch (data.fireMode.get()) {
            default -> throw new MatchException(null, null);
            case FireMode.SEMI -> SEMI;
            case FireMode.BURST -> BURST;
            case FireMode.AUTO -> AUTO;
        };
    }
}

