/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.VehicleHudOverlay;
import com.atsuishio.superbwarfare.entity.vehicle.AnnihilatorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.Hpj11Entity;
import com.atsuishio.superbwarfare.entity.vehicle.Mk42Entity;
import com.atsuishio.superbwarfare.entity.vehicle.Mle1934Entity;
import com.atsuishio.superbwarfare.entity.vehicle.base.CannonEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Math;

@OnlyIn(value=Dist.CLIENT)
public class CannonHudOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("cannon_hud");

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        CannonEntity cannonEntity;
        int w = guiGraphics.guiWidth();
        int h = guiGraphics.guiHeight();
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        PoseStack poseStack = guiGraphics.pose();
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        if (!CannonHudOverlay.shouldRenderCrossHair((Player)player)) {
            return;
        }
        Entity vehicle = player.getVehicle();
        if (vehicle instanceof CannonEntity && (cannonEntity = (CannonEntity)vehicle) instanceof VehicleEntity) {
            Vec3 p;
            VehicleEntity cannon = (VehicleEntity)((Object)cannonEntity);
            poseStack.pushPose();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/compass_white.png"), (float)w / 2.0f - 128.0f, 10.0f, 128.0f + 1.4222223f * Mth.lerp((float)deltaTracker.getGameTimeDeltaPartialTick(true), (float)cannon.yRotO, (float)cannon.getYRot()), 0.0f, 256.0f, 16.0f, 512.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/roll_ind_white.png"), (float)w / 2.0f - 4.0f, 27.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
            String angle = FormatTool.DECIMAL_FORMAT_1ZZ.format(Mth.lerp((float)deltaTracker.getGameTimeDeltaPartialTick(true), (float)cannon.yRotO, (float)cannon.getYRot()));
            int width = Minecraft.getInstance().font.width(angle);
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)angle), w / 2 - width / 2, 40, -1, false);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/cannon/cannon_pitch.png"), (float)w / 2.0f + 166.0f, (float)h / 2.0f - 64.0f, 0.0f, 0.0f, 8.0f, 128.0f, 8.0f, 128.0f);
            String pitch = FormatTool.DECIMAL_FORMAT_1ZZ.format(-Mth.lerp((float)deltaTracker.getGameTimeDeltaPartialTick(true), (float)cannon.xRotO, (float)cannon.getXRot()));
            int widthP = Minecraft.getInstance().font.width(pitch);
            poseStack.pushPose();
            guiGraphics.pose().translate(0.0, (double)Mth.lerp((float)deltaTracker.getGameTimeDeltaPartialTick(true), (float)cannon.xRotO, (float)cannon.getXRot()) * 0.7, 0.0);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/cannon/cannon_pitch_ind.png"), (float)w / 2.0f + 158.0f, (float)h / 2.0f - 4.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)pitch), w / 2 + 157 - widthP, h / 2 - 4, -1, false);
            poseStack.popPose();
            if (Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON || ClientEventHandler.zoomVehicle) {
                float fovAdjust = 70.0f / (float)((Integer)Minecraft.getInstance().options.fov().get()).intValue();
                float f = Math.min((int)w, (int)h);
                float f1 = Math.min((float)((float)w / f), (float)((float)h / f)) * fovAdjust;
                int i = Mth.floor((float)(f * f1));
                int j = Mth.floor((float)(f * f1));
                int k = (w - i) / 2;
                int l = (h - j) / 2;
                if (ClientEventHandler.zoomVehicle) {
                    Vec3 shootPos = player.getEyePosition(deltaTracker.getRealtimeDeltaTicks());
                    if (!(cannon instanceof AnnihilatorEntity)) {
                        shootPos = cannon.driverZoomPos(deltaTracker.getRealtimeDeltaTicks());
                    }
                    Entity lookingEntity = TraceTool.camerafFindLookingEntity((Player)player, cameraPos, 512.0, deltaTracker.getRealtimeDeltaTicks());
                    boolean lookAtEntity = false;
                    BlockHitResult result = player.level().clip(new ClipContext(shootPos, shootPos.add(player.getViewVector(1.0f).scale(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                    Vec3 hitPos = result.getLocation();
                    double blockRange = player.getEyePosition(1.0f).distanceTo(hitPos);
                    double entityRange = 0.0;
                    if (lookingEntity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)lookingEntity;
                        lookAtEntity = true;
                        entityRange = player.distanceTo((Entity)living);
                    }
                    if (lookAtEntity) {
                        MutableComponent component = Component.translatable((String)"tips.superbwarfare.drone.range").append((Component)Component.literal((String)FormatTool.format1D(entityRange, "m ")));
                        if (lookingEntity.getDisplayName() != null) {
                            component.append(lookingEntity.getDisplayName());
                        }
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)component, w / 2 + 14, h / 2 - 20, -1, false);
                    } else if (blockRange > 511.0) {
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.drone.range").append((Component)Component.literal((String)"---m")), w / 2 + 14, h / 2 - 20, -1, false);
                    } else {
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tips.superbwarfare.drone.range").append((Component)Component.literal((String)FormatTool.format1D(blockRange, "m"))), w / 2 + 14, h / 2 - 20, -1, false);
                    }
                    if (!(cannon instanceof Hpj11Entity)) {
                        if (cannon instanceof AnnihilatorEntity) {
                            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/cannon/laser_cannon_crosshair.png"), k, l, 0.0f, 0.0f, i, j, i, j);
                        } else {
                            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/cannon/cannon_crosshair.png"), k, l, 0.0f, 0.0f, i, j, i, j);
                        }
                        float diffY = -Mth.wrapDegrees((float)(Mth.lerp((float)deltaTracker.getGameTimeDeltaPartialTick(true), (float)player.yHeadRotO, (float)player.getYHeadRot()) - Mth.lerp((float)deltaTracker.getGameTimeDeltaPartialTick(true), (float)cannon.yRotO, (float)cannon.getYRot())));
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/cannon/indicator.png"), (float)w / 2.0f - 4.3f + 0.45f * diffY, (float)h / 2.0f - 10.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
                    } else {
                        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/cannon/hpj_crosshair.png"), k, l, 0.0f, 0.0f, i, j, i, j);
                    }
                } else if (!(cannon instanceof Hpj11Entity)) {
                    RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/cannon/cannon_crosshair_notzoom.png"), k, l, 0.0f, 0.0f, i, j, i, j);
                } else {
                    RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/cannon/hpj_crosshair_notzoom.png"), k, l, 0.0f, 0.0f, i, j, i, j);
                }
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                VehicleHudOverlay.renderKillIndicator(guiGraphics, w, h);
            } else if (Minecraft.getInstance().options.getCameraType() == CameraType.THIRD_PERSON_BACK && !ClientEventHandler.zoomVehicle && (p = RenderHelper.worldToScreen(new Vec3(Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)player.xo, (double)player.getX()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)player.yo, (double)player.getY()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)player.zo, (double)player.getZ())).add(cannon.getViewVector(deltaTracker.getGameTimeDeltaPartialTick(true)).scale(128.0)), cameraPos)) != null) {
                Entity entity;
                poseStack.pushPose();
                float x = (float)p.x;
                float y = (float)p.y;
                poseStack.pushPose();
                RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/drone.png"), x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                VehicleHudOverlay.renderKillIndicator3P(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
                poseStack.pushPose();
                poseStack.translate(x, y, 0.0f);
                poseStack.scale(0.75f, 0.75f, 1.0f);
                if (player.getVehicle() instanceof Mk42Entity || player.getVehicle() instanceof Mle1934Entity) {
                    if (cannonEntity.getWeaponIndex(0) == 0) {
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("AP SHELL " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Player)player) ? "\u221e" : Integer.valueOf(cannonEntity.getAmmoCount((Player)player))))), 30, -9, -1, false);
                    } else {
                        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("HE SHELL " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Player)player) ? "\u221e" : Integer.valueOf(cannonEntity.getAmmoCount((Player)player))))), 30, -9, -1, false);
                    }
                }
                if ((entity = player.getVehicle()) instanceof AnnihilatorEntity) {
                    AnnihilatorEntity annihilatorEntity = (AnnihilatorEntity)entity;
                    guiGraphics.drawString(mc.font, (Component)Component.literal((String)("LASER " + FormatTool.format0D((double)(100 * annihilatorEntity.getEnergy()) / (double)annihilatorEntity.getMaxEnergy()) + "\uff05")), 30, -9, -1, false);
                }
                double heal = 1.0f - cannon.getHealth() / cannon.getMaxHealth();
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)("HP " + FormatTool.format0D(100.0f * cannon.getHealth() / cannon.getMaxHealth()))), 30, 1, Mth.hsvToRgb((float)0.0f, (float)((float)heal), (float)1.0f), false);
                poseStack.popPose();
                poseStack.popPose();
                poseStack.popPose();
            }
            poseStack.popPose();
        }
    }

    private static boolean shouldRenderCrossHair(Player player) {
        if (player == null) {
            return false;
        }
        return !player.isSpectator() && player.getVehicle() != null && player.getVehicle() instanceof CannonEntity;
    }
}

