/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DroneHudOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("drone_hud");
    public static int MAX_DISTANCE = 256;
    private static final ResourceLocation FRAME = Mod.loc("textures/screens/frame/frame.png");
    private static final ResourceLocation TV_FRAME = Mod.loc("textures/screens/land/tv_frame.png");

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int w = guiGraphics.guiWidth();
        int h = guiGraphics.guiHeight();
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        if (player == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        ItemStack stack = player.getMainHandItem();
        poseStack.pushPose();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CompoundTag tag = NBTTool.getTag(stack);
        if (stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked")) {
            guiGraphics.blit(Mod.loc("textures/screens/drone.png"), w / 2 - 16, h / 2 - 16, 0.0f, 0.0f, 32, 32, 32, 32);
            guiGraphics.blit(Mod.loc("textures/screens/drone_fov.png"), w / 2 + 100, h / 2 - 64, 0.0f, 0.0f, 64, 129, 64, 129);
            int addW = w / h * 48;
            int addH = w / h * 27;
            RenderHelper.preciseBlit(guiGraphics, TV_FRAME, (float)(-addW) / 2.0f, (float)(-addH) / 2.0f, 10.0f, 0.0f, 0.0f, w + addW, h + addH, w + addW, h + addH);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/drone_fov_move.png"), (float)w / 2.0f + 100.0f, (float)((double)(h / 2 - 64) - (ClientEventHandler.droneFovLerp - 1.0) * 23.8), 0.0f, 0.0f, 64.0f, 129.0f, 64.0f, 129.0f);
            guiGraphics.drawString(mc.font, (Component)Component.literal((String)FormatTool.format1D(ClientEventHandler.droneFovLerp, "x")), w / 2 + 144, h / 2 + 56 - (int)((ClientEventHandler.droneFovLerp - 1.0) * 23.8), -1, false);
            DroneEntity entity = EntityFindUtil.findDrone(player.level(), tag.getString("LinkedDrone"));
            if (entity != null) {
                boolean lookAtEntity = false;
                double distance = player.distanceTo((Entity)entity);
                BlockHitResult result = entity.level().clip(new ClipContext(cameraPos, cameraPos.add(entity.getViewVector(1.0f).scale(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity));
                Vec3 hitPos = result.getLocation();
                double blockRange = cameraPos.distanceTo(hitPos);
                double entityRange = 0.0;
                Entity lookingEntity = TraceTool.droneFindLookingEntity(entity, cameraPos, 512.0, deltaTracker.getGameTimeDeltaPartialTick(true));
                if (lookingEntity != null) {
                    lookAtEntity = true;
                    entityRange = entity.distanceTo(lookingEntity);
                }
                int color = -1;
                if (distance > (double)(MAX_DISTANCE - 48)) {
                    guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"tips.superbwarfare.drone.warning"), w / 2 - 18, h / 2 - 47, -65536, false);
                    color = -65536;
                }
                guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"tips.superbwarfare.drone.distance").append((Component)Component.literal((String)FormatTool.format1D(distance, "m"))), w / 2 + 10, h / 2 + 33, color, false);
                guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"tips.superbwarfare.drone.health").append((Component)Component.literal((String)(FormatTool.format1D(entity.getHealth()) + " / " + FormatTool.format1D(entity.getMaxHealth())))), w / 2 - 77, h / 2 + 33, -1, false);
                if ((Integer)entity.getEntityData().get(DroneEntity.KAMIKAZE_MODE) == 0) {
                    guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"tips.superbwarfare.drone.ammo").append((Component)Component.literal((String)FormatTool.format1D(((Integer)entity.getEntityData().get(DroneEntity.AMMO)).intValue(), " / 6"))), w / 2 + 12, h / 2 - 37, -1, false);
                } else {
                    guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"tips.superbwarfare.drone.kamikaze"), w / 2 + 12, h / 2 - 37, -65536, false);
                }
                if (lookAtEntity) {
                    Component displayName = lookingEntity.getDisplayName();
                    if (displayName == null) {
                        displayName = Component.empty();
                    }
                    guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"tips.superbwarfare.drone.range").append((Component)Component.literal((String)(FormatTool.format1D(entityRange, "m ") + displayName.getString()))), w / 2 + 12, h / 2 - 28, color, false);
                } else if (blockRange > 500.0) {
                    guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"tips.superbwarfare.drone.range").append((Component)Component.literal((String)"---m")), w / 2 + 12, h / 2 - 28, color, false);
                } else {
                    guiGraphics.drawString(mc.font, (Component)Component.translatable((String)"tips.superbwarfare.drone.range").append((Component)Component.literal((String)FormatTool.format1D(blockRange, "m"))), w / 2 + 12, h / 2 - 28, color, false);
                }
                List<Entity> entities = SeekTool.seekLivingEntities(entity, entity.level(), 256.0, 30.0);
                float fovAdjust2 = (float)((Integer)mc.options.fov().get() / 30) - 1.0f;
                double zoom = 0.975 * ClientEventHandler.droneFovLerp + 0.06 * (double)fovAdjust2;
                for (Entity e : entities) {
                    Vec3 lookAngle;
                    Vec3 cPos;
                    Vec3 droneVec = new Vec3(Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)entity.xo, (double)entity.getX()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)(entity.yo + (double)entity.getEyeHeight()), (double)entity.getEyeY()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)entity.zo, (double)entity.getZ()));
                    Vec3 pos = new Vec3(Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)e.xo, (double)e.getX()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)(e.yo + (double)e.getEyeHeight()), (double)e.getEyeY()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)e.zo, (double)e.getZ()));
                    Vec3 point = RenderHelper.worldToScreen(pos, cPos = droneVec.add(lookAngle = entity.getLookAngle().normalize().scale(pos.distanceTo(droneVec) * (1.0 - 1.0 / zoom))));
                    if (point == null) continue;
                    poseStack.pushPose();
                    float x = (float)point.x;
                    float y = (float)point.y;
                    RenderHelper.preciseBlit(guiGraphics, FRAME, x - 12.0f, y - 12.0f, 24.0f, 24.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                    poseStack.popPose();
                }
            }
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }
}

