/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.screens.DogTagEditorScreen;
import com.atsuishio.superbwarfare.client.tooltip.ClientDogTagImageTooltip;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.config.client.KillMessageConfig;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.KillMessageHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.DogTag;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.DamageTypeTool;
import com.atsuishio.superbwarfare.tools.PlayerKillRecord;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;

@OnlyIn(value=Dist.CLIENT)
public class KillMessageOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("kill_message");
    private static final ResourceLocation HEADSHOT = Mod.loc("textures/screens/damage_types/headshot.png");
    private static final ResourceLocation KNIFE = Mod.loc("textures/screens/damage_types/knife.png");
    private static final ResourceLocation EXPLOSION = Mod.loc("textures/screens/damage_types/explosion.png");
    private static final ResourceLocation CLAYMORE = Mod.loc("textures/screens/damage_types/claymore.png");
    private static final ResourceLocation GENERIC = Mod.loc("textures/screens/damage_types/generic.png");
    private static final ResourceLocation BEAST = Mod.loc("textures/screens/damage_types/beast.png");
    private static final ResourceLocation BLEEDING = Mod.loc("textures/screens/damage_types/bleeding.png");
    private static final ResourceLocation SHOCK = Mod.loc("textures/screens/damage_types/shock.png");
    private static final ResourceLocation BLOOD_CRYSTAL = Mod.loc("textures/screens/damage_types/blood_crystal.png");
    private static final ResourceLocation BURN = Mod.loc("textures/screens/damage_types/burn.png");
    private static final ResourceLocation DRONE = Mod.loc("textures/screens/damage_types/drone.png");
    private static final ResourceLocation LASER = Mod.loc("textures/screens/damage_types/laser.png");
    private static final ResourceLocation VEHICLE = Mod.loc("textures/screens/damage_types/vehicle_strike.png");
    private static final ResourceLocation WORLD_PEACE_STAFF = Mod.loc("textures/gun_icon/compat/world_peace_staff.png");

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!((Boolean)KillMessageConfig.SHOW_KILL_MESSAGE.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (KillMessageHandler.QUEUE.isEmpty()) {
            return;
        }
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        KillMessageConfig.KillMessagePosition pos = (KillMessageConfig.KillMessagePosition)((Object)KillMessageConfig.KILL_MESSAGE_POSITION.get());
        int posX = screenWidth;
        float posY = ((Integer)KillMessageConfig.KILL_MESSAGE_MARGIN_Y.get()).intValue();
        boolean left = false;
        boolean bottom = false;
        switch (pos) {
            case LEFT_TOP: {
                posX = (Integer)KillMessageConfig.KILL_MESSAGE_MARGIN_X.get();
                posY = ((Integer)KillMessageConfig.KILL_MESSAGE_MARGIN_Y.get()).intValue();
                left = true;
                break;
            }
            case RIGHT_TOP: {
                posX = screenWidth - (Integer)KillMessageConfig.KILL_MESSAGE_MARGIN_X.get();
                posY = ((Integer)KillMessageConfig.KILL_MESSAGE_MARGIN_Y.get()).intValue();
                break;
            }
            case LEFT_BOTTOM: {
                posX = (Integer)KillMessageConfig.KILL_MESSAGE_MARGIN_X.get();
                posY = screenHeight - (Integer)KillMessageConfig.KILL_MESSAGE_MARGIN_Y.get() - 10;
                left = true;
                bottom = true;
                break;
            }
            case RIGHT_BOTTOM: {
                posX = screenWidth - (Integer)KillMessageConfig.KILL_MESSAGE_MARGIN_X.get();
                posY = screenHeight - (Integer)KillMessageConfig.KILL_MESSAGE_MARGIN_Y.get() - 10;
                bottom = true;
            }
        }
        PlayerKillRecord[] arr = KillMessageHandler.QUEUE.toArray(new PlayerKillRecord[0]);
        PlayerKillRecord record = arr[0];
        if (record.freeze) {
            for (PlayerKillRecord playerKillRecord : arr) {
                playerKillRecord.freeze = false;
            }
        }
        if (record.tick >= 80 && arr.length > 1 && record.tick - arr[1].tick < (record.fastRemove ? 2 : 20)) {
            arr[1].fastRemove = true;
            record.fastRemove = true;
            for (int j = 1; j < arr.length; ++j) {
                arr[j].freeze = true;
            }
        }
        for (PlayerKillRecord r : KillMessageHandler.QUEUE) {
            posY = KillMessageOverlay.renderKillMessages(r, guiGraphics, deltaTracker.getGameTimeDeltaPartialTick(true), posX, posY, left, bottom);
        }
    }

    private static float renderKillMessages(PlayerKillRecord record, GuiGraphics guiGraphics, float partialTick, int width, float baseTop, boolean left, boolean bottom) {
        float top = baseTop;
        Font font = Minecraft.getInstance().font;
        String targetName = KillMessageOverlay.getEntityName(record.target);
        int targetNameWidth = font.width(targetName);
        guiGraphics.pose().pushPose();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        if (record.tick < 3) {
            guiGraphics.pose().translate(((float)(3 - record.tick) - partialTick) * 33.0f * (float)(left ? -1 : 1), 0.0f, 0.0f);
        }
        if (record.tick >= 80) {
            int animationTickCount = record.fastRemove ? 2 : 20;
            float rate = (float)Math.pow(((float)record.tick + partialTick - 80.0f) / (float)animationTickCount, 5.0);
            guiGraphics.pose().translate(rate * 100.0f * (float)(left ? -1 : 1), 0.0f, 0.0f);
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f - rate);
            baseTop += 10.0f * (1.0f - rate) * (float)(bottom ? -1 : 1);
        } else {
            baseTop += (float)(10 * (bottom ? -1 : 1));
        }
        if (!left) {
            ResourceLocation currentWeaponIcon;
            ResourceLocation damageTypeIcon;
            LivingEntity living;
            float currentPosX = (float)(width - targetNameWidth) - 10.0f;
            guiGraphics.drawString(Minecraft.getInstance().font, targetName, currentPosX, top, record.target.getTeamColor(), false);
            Entity entity = record.target;
            if (entity instanceof LivingEntity && KillMessageOverlay.shouldRenderDogTagIcon(living = (LivingEntity)entity)) {
                KillMessageOverlay.renderDogTagIcon(guiGraphics, living, currentPosX -= 14.0f, top - 0.5f);
            }
            if ((damageTypeIcon = KillMessageOverlay.getDamageTypeIcon(record)) != null) {
                RenderHelper.preciseBlit(guiGraphics, damageTypeIcon, currentPosX -= 18.0f, top - 2.0f, 0.0f, 0.0f, 12.0f, 12.0f, 12.0f, 12.0f);
            }
            if ((currentWeaponIcon = KillMessageOverlay.getWeaponIcon(record)) != null) {
                RenderHelper.preciseBlit(guiGraphics, currentWeaponIcon, currentPosX -= 36.0f, top, 0.0f, 0.0f, 32.0f, 8.0f, -32.0f, 8.0f);
            }
            String attackerName = KillMessageOverlay.getEntityName((Entity)record.attacker);
            guiGraphics.drawString(Minecraft.getInstance().font, attackerName, currentPosX -= (float)(font.width(attackerName) + 6), top, record.attacker.getTeamColor(), false);
            if (KillMessageOverlay.shouldRenderDogTagIcon((LivingEntity)record.attacker)) {
                KillMessageOverlay.renderDogTagIcon(guiGraphics, (LivingEntity)record.attacker, currentPosX -= 14.0f, top - 0.5f);
            }
        } else {
            LivingEntity living;
            Entity entity;
            ResourceLocation damageTypeIcon;
            float currentPosX = (float)width + 10.0f;
            if (KillMessageOverlay.shouldRenderDogTagIcon((LivingEntity)record.attacker)) {
                KillMessageOverlay.renderDogTagIcon(guiGraphics, (LivingEntity)record.attacker, currentPosX, top - 0.5f);
                currentPosX += 14.0f;
            }
            String attackerName = KillMessageOverlay.getEntityName((Entity)record.attacker);
            guiGraphics.drawString(Minecraft.getInstance().font, attackerName, currentPosX, top, record.attacker.getTeamColor(), false);
            currentPosX += (float)(font.width(attackerName) + 6);
            ResourceLocation currentWeaponIcon = KillMessageOverlay.getWeaponIcon(record);
            if (currentWeaponIcon != null) {
                RenderHelper.preciseBlit(guiGraphics, currentWeaponIcon, currentPosX, top, 0.0f, 0.0f, 32.0f, 8.0f, -32.0f, 8.0f);
                currentPosX += 36.0f;
            }
            if ((damageTypeIcon = KillMessageOverlay.getDamageTypeIcon(record)) != null) {
                RenderHelper.preciseBlit(guiGraphics, damageTypeIcon, currentPosX, top - 2.0f, 0.0f, 0.0f, 12.0f, 12.0f, 12.0f, 12.0f);
                currentPosX += 18.0f;
            }
            if ((entity = record.target) instanceof LivingEntity && KillMessageOverlay.shouldRenderDogTagIcon(living = (LivingEntity)entity)) {
                KillMessageOverlay.renderDogTagIcon(guiGraphics, living, currentPosX, top - 0.5f);
                currentPosX += 14.0f;
            }
            guiGraphics.drawString(Minecraft.getInstance().font, targetName, currentPosX, top, record.target.getTeamColor(), false);
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.pose().popPose();
        return baseTop;
    }

    @Nullable
    private static ResourceLocation getDamageTypeIcon(PlayerKillRecord record) {
        Object icon = record.headshot ? HEADSHOT : (DamageTypeTool.isGunDamage(record.damageType) ? null : (record.damageType == DamageTypes.EXPLOSION || record.damageType == DamageTypes.PLAYER_EXPLOSION || record.damageType == ModDamageTypes.PROJECTILE_BOOM || record.damageType == DamageTypes.FIREWORKS ? EXPLOSION : (record.damageType == DamageTypes.PLAYER_ATTACK ? KNIFE : (record.damageType == ModDamageTypes.BEAST ? BEAST : (record.damageType == ModDamageTypes.MINE ? CLAYMORE : (record.damageType == ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dreamaticvoyage", (String)"bleeding")) ? BLEEDING : (record.damageType == ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dreamaticvoyage", (String)"blood_crystal")) ? BLOOD_CRYSTAL : (record.damageType == ModDamageTypes.SHOCK ? SHOCK : (record.damageType == ModDamageTypes.BURN || record.damageType == DamageTypes.IN_FIRE || record.damageType == DamageTypes.ON_FIRE || record.damageType == DamageTypes.LAVA ? BURN : (record.damageType == ModDamageTypes.DRONE_HIT ? DRONE : (record.damageType == ModDamageTypes.LASER || record.damageType == ModDamageTypes.LASER_HEADSHOT || record.damageType == ModDamageTypes.LASER_STATIC ? LASER : (record.damageType == ModDamageTypes.VEHICLE_STRIKE ? VEHICLE : GENERIC))))))))))));
        return icon;
    }

    public static String getEntityName(Entity entity) {
        if (entity.getDisplayName() == null) {
            return "";
        }
        String name = entity.getDisplayName().getString();
        if (!((Boolean)DisplayConfig.DOG_TAG_NAME_VISIBLE.get()).booleanValue()) {
            return name;
        }
        if (entity instanceof Player) {
            Player targetPlayer = (Player)entity;
            return CuriosApi.getCuriosInventory((LivingEntity)targetPlayer).flatMap(c -> c.findFirstCurio((Item)ModItems.DOG_TAG.get())).map(s -> s.stack().getHoverName().getString()).orElse(name);
        }
        return name;
    }

    @Nullable
    public static ResourceLocation getWeaponIcon(PlayerKillRecord record) {
        Entity entity;
        Player player = record.attacker;
        if (player != null && (entity = player.getVehicle()) instanceof VehicleEntity) {
            ArmedVehicleEntity iArmedVehicle;
            VehicleEntity vehicleEntity = (VehicleEntity)entity;
            if (vehicleEntity instanceof ArmedVehicleEntity && (iArmedVehicle = (ArmedVehicleEntity)((Object)vehicleEntity)).banHand(player) || record.damageType == ModDamageTypes.VEHICLE_STRIKE) {
                return vehicleEntity.getVehicleIcon();
            }
            Item item = record.stack.getItem();
            if (item instanceof GunItem) {
                GunItem gunItem = (GunItem)item;
                return gunItem.getGunIcon();
            }
        } else {
            Item item = record.stack.getItem();
            if (item instanceof GunItem) {
                GunItem gunItem = (GunItem)item;
                return gunItem.getGunIcon();
            }
            if (record.stack.getItem().getDescriptionId().equals("item.dreamaticvoyage.world_peace_staff")) {
                return WORLD_PEACE_STAFF;
            }
        }
        return null;
    }

    public static boolean shouldRenderDogTagIcon(LivingEntity living) {
        return CuriosApi.getCuriosInventory((LivingEntity)living).flatMap(c -> c.findFirstCurio((Item)ModItems.DOG_TAG.get())).map(s -> ClientDogTagImageTooltip.shouldRenderIcon(s.stack())).orElse(false) != false && (Boolean)DisplayConfig.DOG_TAG_ICON_VISIBLE.get() != false;
    }

    public static void renderDogTagIcon(GuiGraphics guiGraphics, LivingEntity living, float x, float y) {
        CuriosApi.getCuriosInventory((LivingEntity)living).flatMap(c -> c.findFirstCurio((Item)ModItems.DOG_TAG.get())).ifPresent(s -> {
            short[][] icon = DogTag.getColors(s.stack());
            guiGraphics.pose().pushPose();
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    if (icon[i][j] == -1) continue;
                    ChatFormatting color = ChatFormatting.getById((int)icon[i][j]);
                    RenderHelper.fill(guiGraphics, RenderType.gui(), x + (float)i * 0.6f, y + (float)j * 0.6f, x + (float)(i + 1) * 0.6f, y + (float)(j + 1) * 0.6f, 0.0f, DogTagEditorScreen.getColorFromFormatting(color));
                }
            }
            guiGraphics.pose().popPose();
        });
    }
}

