/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RedTriangleOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("red_triangle");
    private static final ResourceLocation TRIANGLE = Mod.loc("textures/screens/red_triangle.png");

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        ArmedVehicleEntity iArmedVehicle;
        Minecraft mc = Minecraft.getInstance();
        PoseStack poseStack = guiGraphics.pose();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (!stack.is((Item)ModItems.RPG.get())) {
            return;
        }
        Entity entity = player.getVehicle();
        if (entity instanceof ArmedVehicleEntity && (iArmedVehicle = (ArmedVehicleEntity)entity).banHand((Player)player)) {
            return;
        }
        Entity idf = SeekTool.seekLivingEntity((Entity)player, player.level(), 128.0, 6.0);
        if (idf == null) {
            return;
        }
        Vec3 playerVec = new Vec3(Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)player.xo, (double)player.getX()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)(player.yo + (double)player.getEyeHeight()), (double)player.getEyeY()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)player.zo, (double)player.getZ()));
        double distance = idf.position().distanceTo(playerVec);
        Vec3 pos = new Vec3(Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)idf.xo, (double)idf.getX()), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)(idf.yo + (double)idf.getEyeHeight() + 0.5 + 0.07 * distance), (double)(idf.getEyeY() + 0.5 + 0.07 * distance)), Mth.lerp((double)deltaTracker.getGameTimeDeltaPartialTick(true), (double)idf.zo, (double)idf.getZ()));
        Vec3 point = RenderHelper.worldToScreen(pos, playerVec);
        if (point == null) {
            return;
        }
        poseStack.pushPose();
        float x = (float)point.x;
        float y = (float)point.y;
        RenderHelper.preciseBlit(guiGraphics, TRIANGLE, x - 4.0f, y - 4.0f, 8.0f, 8.0f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }
}

