/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VehicleTeamOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("vehicle_team");

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!((Boolean)DisplayConfig.VEHICLE_INFO.get()).booleanValue()) {
            return;
        }
        int w = guiGraphics.guiWidth();
        int h = guiGraphics.guiHeight();
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 cameraPos = camera.getPosition();
        PoseStack poseStack = guiGraphics.pose();
        if (player == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        CompoundTag tag = NBTTool.getTag(stack);
        if (stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked")) {
            return;
        }
        boolean lookAtEntity = false;
        double entityRange = 0.0;
        Entity lookingEntity = TraceTool.camerafFindLookingEntity((Player)player, cameraPos, 512.0, deltaTracker.getRealtimeDeltaTicks());
        if (lookingEntity instanceof VehicleEntity) {
            lookAtEntity = true;
            entityRange = player.distanceTo(lookingEntity);
        }
        if (lookAtEntity) {
            poseStack.pushPose();
            poseStack.scale(0.8f, 0.8f, 1.0f);
            Entity entity = lookingEntity.getFirstPassenger();
            if (entity instanceof Player) {
                Player passenger = (Player)entity;
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)(passenger.getDisplayName().getString() + (String)(passenger.getTeam() == null ? "" : " <" + passenger.getTeam().getName() + ">"))), w / 2 + 90, h / 2 - 4, passenger.getTeamColor(), false);
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)(lookingEntity.getDisplayName().getString() + " " + FormatTool.format1D(entityRange, "m"))), w / 2 + 90, h / 2 + 5, passenger.getTeamColor(), false);
            } else {
                guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)(lookingEntity.getDisplayName().getString() + " " + FormatTool.format1D(entityRange, "M"))), w / 2 + 90, h / 2 + 5, -1, false);
            }
            poseStack.popPose();
        }
    }
}

