/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.VehicleHudOverlay;
import com.atsuishio.superbwarfare.entity.vehicle.Yx100Entity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.CameraType;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Math;

@OnlyIn(value=Dist.CLIENT)
public class Yx100SwarmDroneHudOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation ID = Mod.loc("yx100_swarm_drone_hud");
    private static final ResourceLocation FRAME = Mod.loc("textures/screens/frame/frame.png");
    private static final ResourceLocation FRAME_LOCK = Mod.loc("textures/screens/frame/frame_lock.png");

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Yx100Entity yx100;
        int w = guiGraphics.guiWidth();
        int h = guiGraphics.guiHeight();
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        PoseStack poseStack = guiGraphics.pose();
        if (!Yx100SwarmDroneHudOverlay.shouldRenderCrossHair((Player)player)) {
            return;
        }
        Entity cannon = player.getVehicle();
        if (cannon == null) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Entity entity = player.getVehicle();
        if (entity instanceof Yx100Entity && (yx100 = (Yx100Entity)entity).banHand((Player)player) && Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON) {
            float fovAdjust = 70.0f / (float)((Integer)Minecraft.getInstance().options.fov().get()).intValue();
            float f = Math.min((int)w, (int)h);
            float f1 = Math.min((float)((float)w / f), (float)((float)h / f)) * fovAdjust;
            int i = Mth.floor((float)(f * f1));
            int j = Mth.floor((float)(f * f1));
            int k = (w - i) / 2;
            int l = (h - j) / 2;
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/land/lav_missile_cross.png"), k, l, 0.0f, 0.0f, i, j, i, j);
            VehicleHudOverlay.renderKillIndicator(guiGraphics, w, h);
            Entity naerestEntity = SeekTool.seekLivingEntity((Entity)player, player.level(), 384.0, 6.0);
            float fovAdjust2 = (float)((Integer)Minecraft.getInstance().options.fov().get() / 30) - 1.0f;
            double zoom = 1.0;
            if (ClientEventHandler.zoomVehicle) {
                zoom = (double)((Integer)Minecraft.getInstance().options.fov().get()).intValue() / ClientEventHandler.fov + 0.05 * (double)fovAdjust2;
            }
            if (naerestEntity != null) {
                Vec3 lookAngle;
                Vec3 cPos;
                Vec3 playerVec = new Vec3(Mth.lerp((double)deltaTracker.getRealtimeDeltaTicks(), (double)player.xo, (double)player.getX()), Mth.lerp((double)deltaTracker.getRealtimeDeltaTicks(), (double)(player.yo + (double)player.getEyeHeight()), (double)player.getEyeY()), Mth.lerp((double)deltaTracker.getRealtimeDeltaTicks(), (double)player.zo, (double)player.getZ()));
                Vec3 pos = new Vec3(Mth.lerp((double)deltaTracker.getRealtimeDeltaTicks(), (double)naerestEntity.xo, (double)naerestEntity.getX()), Mth.lerp((double)deltaTracker.getRealtimeDeltaTicks(), (double)(naerestEntity.yo + (double)naerestEntity.getEyeHeight()), (double)naerestEntity.getEyeY()), Mth.lerp((double)deltaTracker.getRealtimeDeltaTicks(), (double)naerestEntity.zo, (double)naerestEntity.getZ()));
                Vec3 point = RenderHelper.worldToScreen(pos, cPos = playerVec.add(lookAngle = player.getLookAngle().normalize().scale(pos.distanceTo(playerVec) * (1.0 - 1.0 / zoom))));
                if (point == null) {
                    return;
                }
                poseStack.pushPose();
                float x = (float)point.x;
                float y = (float)point.y;
                RenderHelper.preciseBlit(guiGraphics, FRAME_LOCK, x - 12.0f, y - 12.0f, 24.0f, 24.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
                poseStack.popPose();
            }
        }
    }

    private static boolean shouldRenderCrossHair(Player player) {
        Yx100Entity yx100;
        Entity entity;
        if (player == null) {
            return false;
        }
        return !player.isSpectator() && (entity = player.getVehicle()) instanceof Yx100Entity && (yx100 = (Yx100Entity)entity).getNthEntity(2) == player;
    }
}

