/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.entity;

import com.atsuishio.superbwarfare.client.model.entity.A10Model;
import com.atsuishio.superbwarfare.entity.vehicle.A10Entity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class A10Renderer
extends GeoEntityRenderer<A10Entity> {
    public A10Renderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new A10Model());
        this.shadowRadius = 0.5f;
    }

    public RenderType getRenderType(A10Entity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(animatable));
    }

    public void preRender(PoseStack poseStack, A10Entity entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        float scale;
        this.scaleHeight = scale = 1.0f;
        this.scaleWidth = scale;
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    public void render(A10Entity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.pushPose();
        Vec3 root = new Vec3(0.0, 2.375, 0.0);
        poseStack.rotateAround(Axis.YP.rotationDegrees(-entityYaw), (float)root.x, (float)root.y, (float)root.z);
        poseStack.rotateAround(Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot())), (float)root.x, (float)root.y, (float)root.z);
        poseStack.rotateAround(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.prevRoll, (float)entityIn.getRoll())), (float)root.x, (float)root.y, (float)root.z);
        super.render((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        poseStack.popPose();
    }

    public void renderRecursively(PoseStack poseStack, A10Entity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        String name = bone.getName();
        if (name.equals("wingLR")) {
            bone.setRotX(1.5f * Mth.lerp((float)partialTick, (float)animatable.flap1LRotO, (float)animatable.getFlap1LRot()) * ((float)Math.PI / 180));
        }
        if (name.equals("wingRR")) {
            bone.setRotX(1.5f * Mth.lerp((float)partialTick, (float)animatable.flap1RRotO, (float)animatable.getFlap1RRot()) * ((float)Math.PI / 180));
        }
        if (name.equals("wingLR2")) {
            bone.setRotX(1.5f * Mth.lerp((float)partialTick, (float)animatable.flap1L2RotO, (float)animatable.getFlap1L2Rot()) * ((float)Math.PI / 180));
        }
        if (name.equals("wingRR2")) {
            bone.setRotX(1.5f * Mth.lerp((float)partialTick, (float)animatable.flap1R2RotO, (float)animatable.getFlap1R2Rot()) * ((float)Math.PI / 180));
        }
        if (name.equals("wingLB")) {
            bone.setRotX(Mth.lerp((float)partialTick, (float)animatable.flap2LRotO, (float)animatable.getFlap2LRot()) * ((float)Math.PI / 180));
        }
        if (name.equals("wingRB")) {
            bone.setRotX(Mth.lerp((float)partialTick, (float)animatable.flap2RRotO, (float)animatable.getFlap2RRot()) * ((float)Math.PI / 180));
        }
        if (name.equals("weiyiL") || name.equals("weiyiR")) {
            bone.setRotY(Mth.clamp((float)Mth.lerp((float)partialTick, (float)animatable.flap3RotO, (float)animatable.getFlap3Rot()), (float)-20.0f, (float)20.0f) * ((float)Math.PI / 180));
        }
        if (name.equals("gear") || name.equals("gear2") || name.equals("gear3")) {
            bone.setRotX(Mth.lerp((float)partialTick, (float)animatable.gearRotO, (float)((Integer)animatable.getEntityData().get(MobileVehicleEntity.GEAR_ROT)).intValue()) * ((float)Math.PI / 180));
        }
        if (name.equals("qianzhou") || name.equals("qianzhou2")) {
            bone.setRotZ(Mth.lerp((float)partialTick, (float)animatable.propellerRotO, (float)animatable.getPropellerRot()));
        }
        if (name.equals("bomb1")) {
            bone.setHidden((Integer)animatable.getEntityData().get(A10Entity.LOADED_BOMB) < 3);
        }
        if (name.equals("bomb2")) {
            bone.setHidden((Integer)animatable.getEntityData().get(A10Entity.LOADED_BOMB) < 2);
        }
        if (name.equals("bomb3")) {
            bone.setHidden((Integer)animatable.getEntityData().get(A10Entity.LOADED_BOMB) < 1);
        }
        if (name.equals("missile1")) {
            bone.setHidden((Integer)animatable.getEntityData().get(A10Entity.LOADED_MISSILE) < 4);
        }
        if (name.equals("missile2")) {
            bone.setHidden((Integer)animatable.getEntityData().get(A10Entity.LOADED_MISSILE) < 3);
        }
        if (name.equals("missile4")) {
            bone.setHidden((Integer)animatable.getEntityData().get(A10Entity.LOADED_MISSILE) < 2);
        }
        if (name.equals("missile3")) {
            bone.setHidden((Integer)animatable.getEntityData().get(A10Entity.LOADED_MISSILE) < 1);
        }
        super.renderRecursively(poseStack, (Entity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }
}

