/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.entity;

import com.atsuishio.superbwarfare.client.layer.vehicle.AnnihilatorGlowLayer;
import com.atsuishio.superbwarfare.client.layer.vehicle.AnnihilatorLayer;
import com.atsuishio.superbwarfare.client.layer.vehicle.AnnihilatorLedLayer;
import com.atsuishio.superbwarfare.client.layer.vehicle.AnnihilatorLedLightLayer;
import com.atsuishio.superbwarfare.client.layer.vehicle.AnnihilatorPowerLayer;
import com.atsuishio.superbwarfare.client.layer.vehicle.AnnihilatorPowerLightLayer;
import com.atsuishio.superbwarfare.client.model.entity.AnnihilatorModel;
import com.atsuishio.superbwarfare.entity.vehicle.AnnihilatorEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class AnnihilatorRenderer
extends GeoEntityRenderer<AnnihilatorEntity> {
    public AnnihilatorRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new AnnihilatorModel());
        this.addRenderLayer(new AnnihilatorLayer((GeoRenderer<AnnihilatorEntity>)this));
        this.addRenderLayer(new AnnihilatorGlowLayer((GeoRenderer<AnnihilatorEntity>)this));
        this.addRenderLayer(new AnnihilatorPowerLayer((GeoRenderer<AnnihilatorEntity>)this));
        this.addRenderLayer(new AnnihilatorPowerLightLayer((GeoRenderer<AnnihilatorEntity>)this));
        this.addRenderLayer(new AnnihilatorLedLayer((GeoRenderer<AnnihilatorEntity>)this));
        this.addRenderLayer(new AnnihilatorLedLightLayer((GeoRenderer<AnnihilatorEntity>)this));
    }

    public RenderType getRenderType(AnnihilatorEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(animatable));
    }

    public void preRender(PoseStack poseStack, AnnihilatorEntity entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        float scale;
        this.scaleHeight = scale = 1.0f;
        this.scaleWidth = scale;
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    public void render(AnnihilatorEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        super.render((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public void renderRecursively(PoseStack poseStack, AnnihilatorEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        String name = bone.getName();
        Minecraft minecraft = Minecraft.getInstance();
        Frustum pCamera = minecraft.levelRenderer.getFrustum();
        AABB aabb = animatable.getBoundingBoxForCulling().inflate(0.5);
        if (aabb.hasNaN() || aabb.getSize() == 0.0) {
            aabb = new AABB(animatable.getX() - 6.0, animatable.getY() - 4.0, animatable.getZ() - 6.0, animatable.getX() + 6.0, animatable.getY() + 4.0, animatable.getZ() + 6.0);
        }
        if (name.equals("bone")) {
            bone.setHidden(!pCamera.isVisible(aabb));
        }
        if (name.equals("main") || name.equals("main2")) {
            bone.setRotY(-Mth.lerp((float)partialTick, (float)animatable.yRotO, (float)animatable.getYRot()) * ((float)Math.PI / 180));
        }
        if (name.equals("PaoGuan") || name.equals("PaoGuan2")) {
            bone.setRotX(-Mth.lerp((float)partialTick, (float)animatable.xRotO, (float)animatable.getXRot()) * ((float)Math.PI / 180));
        }
        super.renderRecursively(poseStack, (Entity)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }
}

