/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.screens;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.screens.FuMO25ScreenHelper;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.menu.FuMO25Menu;
import com.atsuishio.superbwarfare.network.message.send.RadarChangeModeMessage;
import com.atsuishio.superbwarfare.network.message.send.RadarSetParametersMessage;
import com.atsuishio.superbwarfare.network.message.send.RadarSetPosMessage;
import com.atsuishio.superbwarfare.network.message.send.RadarSetTargetMessage;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FuMO25Screen
extends AbstractContainerScreen<FuMO25Menu> {
    private static final ResourceLocation TEXTURE = Mod.loc("textures/gui/radar.png");
    private static final ResourceLocation SCAN = Mod.loc("textures/gui/radar_scan.png");
    private BlockPos currentPos = null;
    private Entity currentTarget = null;

    public FuMO25Screen(FuMO25Menu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.imageWidth = 340;
        this.imageHeight = 166;
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        pGuiGraphics.blit(TEXTURE, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 358, 328);
        this.renderTargets(pGuiGraphics);
        this.renderScan(pGuiGraphics);
        this.renderXLine(pGuiGraphics, i, j);
        long energy = ((FuMO25Menu)this.menu).getEnergy();
        float energyRate = (float)energy / 1000000.0f;
        pGuiGraphics.blit(TEXTURE, i + 278, j + 39, 178.0f, 167.0f, (int)(54.0f * energyRate), 16, 358, 328);
        this.renderInfo(pGuiGraphics);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderXLine(GuiGraphics guiGraphics, int i, int j) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        guiGraphics.blit(TEXTURE, i + 8, j + 11, 0.0f, 167.0f, 147, 147, 358, 328);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        poseStack.popPose();
    }

    private void renderTargets(GuiGraphics guiGraphics) {
        List<Entity> entities = FuMO25ScreenHelper.entities;
        if (entities == null || entities.isEmpty()) {
            return;
        }
        BlockPos pos = FuMO25ScreenHelper.pos;
        if (pos == null) {
            return;
        }
        if (!((FuMO25Menu)this.menu).isPowered()) {
            return;
        }
        int type = (int)((FuMO25Menu)this.menu).getFuncType();
        int range = type == 1 ? 128 : 96;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        int centerX = i + 81;
        int centerY = j + 84;
        for (Entity entity : entities) {
            double moveX = (entity.getX() - (double)pos.getX()) / (double)range * 74.0;
            double moveZ = (entity.getZ() - (double)pos.getZ()) / (double)range * 74.0;
            RenderHelper.preciseBlit(guiGraphics, TEXTURE, (float)((double)centerX + moveX), (float)((double)centerY + moveZ), 233.0f, 167.0f, 4.0f, 4.0f, 358.0f, 328.0f);
        }
        poseStack.popPose();
    }

    private void renderScan(GuiGraphics guiGraphics) {
        if (((FuMO25Menu)this.menu).getEnergy() <= 0L) {
            return;
        }
        if (!((FuMO25Menu)this.menu).isPowered()) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        poseStack.rotateAround(Axis.ZP.rotationDegrees((float)(System.currentTimeMillis() % 36000000L) / 30.0f), (float)(i + 9) + 72.5f, (float)(j + 12) + 72.5f, 0.0f);
        guiGraphics.blit(SCAN, i + 9, j + 12, 0.0f, 0.0f, 145, 145, 145, 145);
        poseStack.popPose();
    }

    private void renderInfo(GuiGraphics guiGraphics) {
        MutableComponent component;
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        if (this.currentPos != null) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"des.superbwarfare.fumo_25.current_pos", (Object[])new Object[]{"[" + this.currentPos.getX() + ", " + this.currentPos.getY() + ", " + this.currentPos.getZ() + "]"}), i + 173, j + 13, 0xFFFFFF);
        }
        if (this.currentTarget != null) {
            Entity entity;
            StringBuilder sb = new StringBuilder();
            if (this.currentTarget.getDisplayName() != null) {
                sb.append(this.currentTarget.getDisplayName().getString());
            }
            if ((entity = this.currentTarget) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                sb.append(" (HP: ").append(FormatTool.format1D(living.getHealth())).append("/").append(FormatTool.format1D(living.getMaxHealth())).append(")");
            } else {
                entity = this.currentTarget;
                if (entity instanceof VehicleEntity) {
                    VehicleEntity vehicle = (VehicleEntity)entity;
                    sb.append(" (HP: ").append(FormatTool.format1D(vehicle.getHealth())).append("/").append(FormatTool.format1D(vehicle.getMaxHealth())).append(")");
                }
            }
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"des.superbwarfare.fumo_25.current_target", (Object[])new Object[]{sb.toString()}), i + 173, j + 24, 0xFFFFFF);
        }
        int type = (int)((FuMO25Menu)this.menu).getFuncType();
        switch (type) {
            case 1: {
                MutableComponent mutableComponent = Component.translatable((String)"des.superbwarfare.fumo_25.type_1");
                break;
            }
            case 2: {
                MutableComponent mutableComponent = Component.translatable((String)"des.superbwarfare.fumo_25.type_2");
                break;
            }
            case 3: {
                MutableComponent mutableComponent = Component.translatable((String)"des.superbwarfare.fumo_25.type_3");
                break;
            }
            default: {
                MutableComponent mutableComponent = component = Component.translatable((String)"des.superbwarfare.fumo_25.type_0");
            }
        }
        if (type != 0) {
            component = component.append((Component)Component.literal((String)(" " + ((FuMO25Menu)this.menu).getTime() / 20L + "s")));
        }
        guiGraphics.drawString(this.font, (Component)component, i + 173, j + 43, 0xFFFFFF);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        List<Entity> entities = FuMO25ScreenHelper.entities;
        if (entities == null || entities.isEmpty()) {
            return super.mouseClicked(pMouseX, pMouseY, pButton);
        }
        BlockPos pos = FuMO25ScreenHelper.pos;
        if (pos == null) {
            return super.mouseClicked(pMouseX, pMouseY, pButton);
        }
        if (pButton != 0) {
            return super.mouseClicked(pMouseX, pMouseY, pButton);
        }
        if (!((FuMO25Menu)this.menu).isPowered()) {
            return super.mouseClicked(pMouseX, pMouseY, pButton);
        }
        int type = (int)((FuMO25Menu)this.menu).getFuncType();
        int range = type == 1 ? 128 : 96;
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        int centerX = i + 81;
        int centerY = j + 84;
        for (Entity entity : entities) {
            double moveX = (entity.getX() - (double)pos.getX()) / (double)range * 74.0;
            double moveZ = (entity.getZ() - (double)pos.getZ()) / (double)range * 74.0;
            if (!(pMouseX >= (double)centerX + moveX) || !(pMouseX <= (double)centerX + moveX + 4.0) || !(pMouseY >= (double)centerY + moveZ) || !(pMouseY <= (double)centerY + moveZ + 4.0)) continue;
            PacketDistributor.sendToServer((CustomPacketPayload)new RadarSetPosMessage(entity.getOnPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.currentPos = entity.getOnPos();
            this.currentTarget = entity;
            return true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.pose().pushPose();
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.pose().popPose();
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void renderTooltip(@NotNull GuiGraphics pGuiGraphics, int pX, int pY) {
        super.renderTooltip(pGuiGraphics, pX, pY);
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        tooltip.add(Component.translatable((String)"des.superbwarfare.charging_station.energy", (Object[])new Object[]{((FuMO25Menu)this.menu).getEnergy(), 1000000}));
        if (pX - i >= 278 && pX - i <= 332 && pY - j >= 39 && pY - j <= 55) {
            pGuiGraphics.renderTooltip(this.font, tooltip, Optional.empty(), pX, pY);
        }
    }

    protected void renderLabels(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
    }

    protected void init() {
        super.init();
        this.titleLabelX = 33;
        this.titleLabelY = 5;
        this.inventoryLabelX = 105;
        this.inventoryLabelY = 128;
        this.currentPos = null;
        this.currentTarget = null;
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        LockButton lockButton = new LockButton(i + 304, j + 61);
        this.addRenderableWidget((GuiEventListener)lockButton);
        ModeButton widerButton = new ModeButton(i + 171, j + 61, 1);
        this.addRenderableWidget((GuiEventListener)widerButton);
        ModeButton glowButton = new ModeButton(i + 201, j + 61, 2);
        this.addRenderableWidget((GuiEventListener)glowButton);
        ModeButton guideButton = new ModeButton(i + 231, j + 61, 3);
        this.addRenderableWidget((GuiEventListener)guideButton);
    }

    @OnlyIn(value=Dist.CLIENT)
    class LockButton
    extends AbstractButton {
        public LockButton(int pX, int pY) {
            super(pX, pY, 29, 15, (Component)Component.empty());
        }

        public void onPress() {
            if (((FuMO25Menu)FuMO25Screen.this.menu).getFuncType() == 3L && ((FuMO25Menu)FuMO25Screen.this.menu).getSlot(0).getItem().isEmpty()) {
                if (FuMO25Screen.this.currentTarget == null) {
                    return;
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new RadarSetTargetMessage(FuMO25Screen.this.currentTarget.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new RadarSetParametersMessage(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        protected void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            if (((FuMO25Menu)FuMO25Screen.this.menu).getFuncType() == 3L && ((FuMO25Menu)FuMO25Screen.this.menu).getSlot(0).getItem().isEmpty()) {
                pGuiGraphics.blit(TEXTURE, this.getX(), this.getY(), 148.0f, this.isHovered() ? 311.0f : 295.0f, 29, 15, 358, 328);
            } else {
                pGuiGraphics.blit(TEXTURE, this.getX(), this.getY(), 148.0f, this.isHovered() ? 183.0f : 167.0f, 29, 15, 358, 328);
            }
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ModeButton
    extends AbstractButton {
        private final int mode;

        public ModeButton(int pX, int pY, int mode) {
            super(pX, pY, 29, 15, (Component)Component.empty());
            this.mode = mode;
        }

        public void onPress() {
            PacketDistributor.sendToServer((CustomPacketPayload)new RadarChangeModeMessage((byte)this.mode), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            pGuiGraphics.blit(TEXTURE, this.getX(), this.getY(), 148.0f, this.isHovered() ? (float)(183 + this.mode * 32) : (float)(167 + this.mode * 32), 29, 15, 358, 328);
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }
    }
}

