/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.tooltip;

import com.atsuishio.superbwarfare.client.tooltip.ClientGunImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.perk.AmmoPerk;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.FormatTool;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class ClientBocekImageTooltip
extends ClientGunImageTooltip {
    public ClientBocekImageTooltip(GunImageComponent tooltip) {
        super(tooltip);
    }

    @Override
    protected Component getDamageComponent() {
        boolean slug = false;
        GunData data = GunData.from(this.stack);
        Perk perk = data.perk.get(Perk.Type.AMMO);
        if (perk instanceof AmmoPerk) {
            AmmoPerk ammoPerk = (AmmoPerk)perk;
            if (ammoPerk.slug) {
                slug = true;
            }
        }
        double damage = data.damage();
        if (slug) {
            return super.getDamageComponent();
        }
        double shotDamage = damage * 0.1;
        double extraDamage = -1.0;
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            shotDamage = instance.perk().getDisplayDamage(shotDamage, data, instance);
            if (!(instance.perk().getExtraDisplayDamage(shotDamage, data, instance) >= 0.0)) continue;
            extraDamage = instance.perk().getExtraDisplayDamage(shotDamage, data, instance);
        }
        return Component.translatable((String)"des.superbwarfare.guns.damage").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)(extraDamage >= 0.0 ? "(" + FormatTool.format1D(shotDamage) + " + " + FormatTool.format1D(extraDamage) + ") * 10" : FormatTool.format1D(shotDamage, " * 10"))).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)" / ").withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)FormatTool.format1D(shotDamage)).withStyle(ChatFormatting.GREEN));
    }
}

