/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.tooltip;

import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ClientChargingStationImageTooltip
implements ClientTooltipComponent {
    protected final int width;
    protected final int height;
    protected final ItemStack stack;

    public ClientChargingStationImageTooltip(GunImageComponent tooltip) {
        this.width = tooltip.width;
        this.height = tooltip.height;
        this.stack = tooltip.stack;
    }

    public void renderImage(@NotNull Font font, int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.pose().pushPose();
        this.renderEnergyTooltip(font, guiGraphics, x, y);
        guiGraphics.pose().popPose();
    }

    protected void renderEnergyTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawString(font, this.getEnergyComponent(), x, y, 0xFFFFFF);
    }

    protected Component getEnergyComponent() {
        int i;
        int energy = (Integer)this.stack.getOrDefault((DataComponentType)ModDataComponents.ENERGY.get(), (Object)0);
        int maxEnergy = 4000000;
        float percentage = Mth.clamp((float)((float)energy / (float)maxEnergy), (float)0.0f, (float)1.0f);
        MutableComponent component = Component.empty();
        ChatFormatting format = percentage <= 0.2f ? ChatFormatting.RED : (percentage <= 0.6f ? ChatFormatting.YELLOW : ChatFormatting.GREEN);
        int count = (int)(percentage * 50.0f);
        for (i = 0; i < count; ++i) {
            component.append((Component)Component.literal((String)"|").withStyle(format));
        }
        component.append((Component)Component.empty().withStyle(ChatFormatting.RESET));
        for (i = 0; i < 50 - count; ++i) {
            component.append((Component)Component.literal((String)"|").withStyle(ChatFormatting.GRAY));
        }
        component.append((Component)Component.literal((String)(" " + energy + "/" + maxEnergy + " FE")).withStyle(ChatFormatting.GRAY));
        return component;
    }

    public int getHeight() {
        return Math.max(20, this.height) - 10;
    }

    public int getWidth(@NotNull Font font) {
        if (Screen.hasShiftDown()) {
            return Math.max(this.width, 20);
        }
        return 20;
    }
}

