/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.tooltip;

import com.atsuishio.superbwarfare.client.tooltip.ClientGunImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class ClientEnergyImageTooltip
extends ClientGunImageTooltip {
    public ClientEnergyImageTooltip(GunImageComponent tooltip) {
        super(tooltip);
    }

    @Override
    public void renderImage(@NotNull Font font, int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.pose().pushPose();
        this.renderDamageAndRpmTooltip(font, guiGraphics, x, y);
        this.renderLevelAndUpgradePointTooltip(font, guiGraphics, x, y + 10);
        int yo = 20;
        if (this.shouldRenderBypassAndHeadshotTooltip(this.stack)) {
            this.renderBypassAndHeadshotTooltip(font, guiGraphics, x, y + yo);
            yo += 10;
        }
        if (this.shouldRenderEnergyTooltip()) {
            this.renderEnergyTooltip(font, guiGraphics, x, y + (yo += 10));
            yo += 10;
        }
        if (this.shouldRenderEditTooltip()) {
            this.renderWeaponEditTooltip(font, guiGraphics, x, y + yo);
            yo += 20;
        }
        if (this.shouldRenderPerks()) {
            if (!Screen.hasShiftDown()) {
                this.renderPerksShortcut(font, guiGraphics, x, y + yo);
            } else {
                this.renderPerks(font, guiGraphics, x, y + yo);
            }
        }
        guiGraphics.pose().popPose();
    }

    protected boolean shouldRenderEnergyTooltip() {
        return this.stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
    }

    protected void renderEnergyTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawString(font, this.getEnergyComponent(), x, y, 0xFFFFFF);
    }

    protected Component getEnergyComponent() {
        int i;
        IEnergyStorage storage = (IEnergyStorage)this.stack.getCapability(Capabilities.EnergyStorage.ITEM);
        assert (storage != null);
        int energy = storage.getEnergyStored();
        int maxEnergy = storage.getMaxEnergyStored();
        float percentage = Mth.clamp((float)((float)energy / (float)maxEnergy), (float)0.0f, (float)1.0f);
        MutableComponent component = Component.empty();
        ChatFormatting format = percentage <= 0.2f ? ChatFormatting.RED : (percentage <= 0.6f ? ChatFormatting.YELLOW : ChatFormatting.GREEN);
        int count = (int)(percentage * 50.0f);
        for (i = 0; i < count; ++i) {
            component.append((Component)Component.literal((String)"|").withStyle(format));
        }
        component.append((Component)Component.empty().withStyle(ChatFormatting.RESET));
        for (i = 0; i < 50 - count; ++i) {
            component.append((Component)Component.literal((String)"|").withStyle(ChatFormatting.GRAY));
        }
        component.append((Component)Component.literal((String)(" " + energy + "/" + maxEnergy + " FE")).withStyle(ChatFormatting.GRAY));
        return component;
    }

    @Override
    public int getHeight() {
        int height = super.getHeight();
        if (this.shouldRenderEnergyTooltip()) {
            height += 20;
        }
        return height;
    }

    @Override
    public int getWidth(@NotNull Font font) {
        int width = super.getWidth(font);
        if (this.shouldRenderEnergyTooltip()) {
            width = Math.max(width, font.width(this.getEnergyComponent().getVisualOrderText()) + 10);
        }
        return width;
    }
}

