/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.tooltip;

import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.AmmoPerk;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.FormatTool;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ClientGunImageTooltip
implements ClientTooltipComponent {
    protected final int width;
    protected final int height;
    protected final ItemStack stack;
    protected final GunData data;

    public ClientGunImageTooltip(GunImageComponent tooltip) {
        this.width = tooltip.width;
        this.height = tooltip.height;
        this.stack = tooltip.stack;
        this.data = GunData.from(this.stack);
    }

    public void renderImage(@NotNull Font font, int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.pose().pushPose();
        this.renderDamageAndRpmTooltip(font, guiGraphics, x, y);
        this.renderLevelAndUpgradePointTooltip(font, guiGraphics, x, y + 10);
        int yo = 20;
        if (this.shouldRenderBypassAndHeadshotTooltip(this.stack)) {
            this.renderBypassAndHeadshotTooltip(font, guiGraphics, x, y + yo);
            yo += 10;
        }
        if (this.shouldRenderEditTooltip()) {
            this.renderWeaponEditTooltip(font, guiGraphics, x, y + yo);
            yo += 20;
        }
        if (this.shouldRenderPerks()) {
            if (!Screen.hasShiftDown()) {
                this.renderPerksShortcut(font, guiGraphics, x, y + yo);
            } else {
                this.renderPerks(font, guiGraphics, x, y + yo);
            }
        }
        guiGraphics.pose().popPose();
    }

    protected boolean shouldRenderBypassAndHeadshotTooltip(ItemStack stack) {
        return !stack.is(ModTags.Items.LAUNCHER);
    }

    protected boolean shouldRenderEditTooltip() {
        Item item = this.stack.getItem();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            return gunItem.isCustomizable(this.stack);
        }
        return false;
    }

    protected boolean shouldRenderPerks() {
        return this.data.perk.get(Perk.Type.AMMO) != null || this.data.perk.get(Perk.Type.DAMAGE) != null || this.data.perk.get(Perk.Type.FUNCTIONAL) != null;
    }

    protected void renderDamageAndRpmTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawString(font, this.getDamageComponent(), x, y, 0xFFFFFF);
        int xo = font.width(this.getDamageComponent().getVisualOrderText());
        guiGraphics.drawString(font, this.getRpmComponent(), x + xo + 16, y, 0xFFFFFF);
    }

    protected Component getDamageComponent() {
        double damage = this.data.damage();
        double extraDamage = -1.0;
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = this.data.perk.getInstance(type);
            if (instance == null) continue;
            damage = instance.perk().getDisplayDamage(damage, this.data, instance);
            if (!(instance.perk().getExtraDisplayDamage(damage, this.data, instance) >= 0.0)) continue;
            extraDamage = instance.perk().getExtraDisplayDamage(damage, this.data, instance);
        }
        String dmgStr = FormatTool.format1D(damage) + (String)(extraDamage >= 0.0 ? " + " + FormatTool.format1D(extraDamage) : "");
        if (this.data.projectileAmount() > 1) {
            dmgStr = extraDamage >= 0.0 ? "(" + dmgStr + ") * " + this.data.projectileAmount() : dmgStr + " * " + this.data.projectileAmount();
        }
        return Component.translatable((String)"des.superbwarfare.guns.damage").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)dmgStr).withStyle(ChatFormatting.GREEN));
    }

    protected Component getRpmComponent() {
        if (this.stack.getItem() instanceof GunItem && (GunData.from(this.stack).getAvailableFireModes().contains((Object)FireMode.AUTO) || GunData.from(this.stack).getAvailableFireModes().contains((Object)FireMode.BURST))) {
            return Component.translatable((String)"des.superbwarfare.guns.rpm").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)FormatTool.format0D(this.data.rpm())).withStyle(ChatFormatting.GREEN));
        }
        return Component.empty();
    }

    protected void renderLevelAndUpgradePointTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawString(font, this.getLevelComponent(), x, y, 0xFFFFFF);
        int xo = font.width(this.getLevelComponent().getVisualOrderText());
        guiGraphics.drawString(font, this.getUpgradePointComponent(), x + xo + 16, y, 0xFFFFFF);
    }

    protected Component getLevelComponent() {
        int level = this.data.level.get();
        double rate = this.data.exp.get() / (20.0 * Math.pow(level, 2.0) + (double)(160 * level) + 20.0);
        ChatFormatting formatting = level < 10 ? ChatFormatting.WHITE : (level < 20 ? ChatFormatting.AQUA : (level < 30 ? ChatFormatting.LIGHT_PURPLE : (level < 40 ? ChatFormatting.GOLD : ChatFormatting.RED)));
        return Component.translatable((String)"des.superbwarfare.guns.level").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)("" + level)).withStyle(formatting).withStyle(ChatFormatting.BOLD)).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)(" (" + FormatTool.DECIMAL_FORMAT_2ZZZ.format(rate * 100.0) + "%)")).withStyle(ChatFormatting.GRAY));
    }

    protected Component getUpgradePointComponent() {
        int upgradePoint = Mth.floor((double)this.data.upgradePoint.get());
        return Component.translatable((String)"des.superbwarfare.guns.upgrade_point").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)String.valueOf(upgradePoint)).withStyle(ChatFormatting.WHITE).withStyle(ChatFormatting.BOLD));
    }

    protected void renderBypassAndHeadshotTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawString(font, this.getBypassComponent(), x, y, 0xFFFFFF);
        int xo = font.width(this.getBypassComponent().getVisualOrderText());
        guiGraphics.drawString(font, this.getHeadshotComponent(), x + xo + 16, y, 0xFFFFFF);
    }

    protected Component getBypassComponent() {
        double perkBypassArmorRate = 0.0;
        Perk perk = this.data.perk.get(Perk.Type.AMMO);
        if (perk instanceof AmmoPerk) {
            AmmoPerk ammoPerk = (AmmoPerk)perk;
            PerkInstance perkInstance = this.data.perk.getInstance(perk);
            short level = perkInstance == null ? (short)0 : perkInstance.level();
            perkBypassArmorRate = ammoPerk.bypassArmorRate + (perk == ModPerks.AP_BULLET.get() ? 0.05f * (float)(level - 1) : 0.0f);
        }
        double bypassRate = Math.max(this.data.bypassArmor() + perkBypassArmorRate, 0.0);
        return Component.translatable((String)"des.superbwarfare.guns.bypass").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)FormatTool.format2D(bypassRate * 100.0, "%")).withStyle(ChatFormatting.GOLD));
    }

    protected Component getHeadshotComponent() {
        double headshot = this.data.headshot();
        return Component.translatable((String)"des.superbwarfare.guns.headshot").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)FormatTool.format1D(headshot, "x")).withStyle(ChatFormatting.AQUA));
    }

    protected void renderWeaponEditTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawString(font, this.getEditComponent(), x, y + 10, 0xFFFFFF);
    }

    protected Component getEditComponent() {
        return Component.translatable((String)"des.superbwarfare.guns.edit", (Object[])new Object[]{"[" + ModKeyMappings.EDIT_MODE.getKey().getDisplayName().getString() + "]"}).withStyle(ChatFormatting.LIGHT_PURPLE).withStyle(ChatFormatting.ITALIC);
    }

    protected void renderPerksShortcut(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.pose().pushPose();
        int xOffset = -20;
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance perkInstance = this.data.perk.getInstance(type);
            if (perkInstance == null) continue;
            Item ammoItem = (Item)perkInstance.perk().getItem().get();
            ItemStack perkStack = ammoItem.getDefaultInstance();
            short level = perkInstance.level();
            perkStack.setCount((int)level);
            guiGraphics.renderItem(perkStack, x + (xOffset += 20), y + 2);
            guiGraphics.renderItemDecorations(font, perkStack, x + xOffset, y + 2);
        }
        guiGraphics.pose().popPose();
    }

    protected void renderPerks(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.pose().pushPose();
        guiGraphics.drawString(font, (Component)Component.translatable((String)"perk.superbwarfare.tips").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.UNDERLINE), x, y + 10, 0xFFFFFF);
        int yOffset = -5;
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance perkInstance = this.data.perk.getInstance(type);
            if (perkInstance == null) continue;
            Item ammoItem = (Item)perkInstance.perk().getItem().get();
            guiGraphics.renderItem(ammoItem.getDefaultInstance(), x, y + 4 + (yOffset += 25));
            String id = perkInstance.perk().descriptionId;
            MutableComponent component = Component.translatable((String)("item.superbwarfare." + id)).withStyle(type.getColor()).append((Component)Component.literal((String)" ").withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)(" Lvl. " + perkInstance.level())).withStyle(ChatFormatting.WHITE));
            MutableComponent descComponent = Component.translatable((String)("des.superbwarfare." + id)).withStyle(ChatFormatting.GRAY);
            guiGraphics.drawString(font, (Component)component, x + 20, y + yOffset + 2, 0xFFFFFF);
            guiGraphics.drawString(font, (Component)descComponent, x + 20, y + yOffset + 12, 0xFFFFFF);
        }
        guiGraphics.pose().popPose();
    }

    protected int getDefaultMaxWidth(Font font) {
        int width = font.width(this.getDamageComponent().getVisualOrderText()) + font.width(this.getRpmComponent().getVisualOrderText()) + 16;
        width = Math.max(width, font.width(this.getLevelComponent().getVisualOrderText()) + font.width(this.getUpgradePointComponent().getVisualOrderText()) + 16);
        if (this.shouldRenderBypassAndHeadshotTooltip(this.stack)) {
            width = Math.max(width, font.width(this.getBypassComponent().getVisualOrderText()) + font.width(this.getHeadshotComponent().getVisualOrderText()) + 16);
        }
        if (this.shouldRenderEditTooltip()) {
            width = Math.max(width, font.width(this.getEditComponent().getVisualOrderText()) + 16);
        }
        return width + 4;
    }

    protected int getMaxPerkDesWidth(Font font) {
        if (!this.shouldRenderPerks()) {
            return 0;
        }
        int width = 0;
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance perkInstance = this.data.perk.getInstance(type);
            if (perkInstance == null) continue;
            String id = perkInstance.perk().descriptionId;
            MutableComponent ammoDesComponent = Component.translatable((String)("des.superbwarfare." + id)).withStyle(ChatFormatting.GRAY);
            width = Math.max(width, font.width((FormattedText)ammoDesComponent));
        }
        return width + 25;
    }

    public int getHeight() {
        int height = Math.max(20, this.height);
        if (this.shouldRenderBypassAndHeadshotTooltip(this.stack)) {
            height += 10;
        }
        if (this.shouldRenderEditTooltip()) {
            height += 20;
        }
        if (this.shouldRenderPerks()) {
            height += 16;
            if (Screen.hasShiftDown()) {
                for (Perk.Type type : Perk.Type.values()) {
                    if (!this.data.perk.has(type)) continue;
                    height += 25;
                }
            }
        }
        return height;
    }

    public int getWidth(@NotNull Font font) {
        if (Screen.hasShiftDown()) {
            int width = this.getMaxPerkDesWidth(font);
            return width == 0 ? Math.max(this.width, this.getDefaultMaxWidth(font)) : Math.max(width, this.getDefaultMaxWidth(font));
        }
        return this.getDefaultMaxWidth(font);
    }
}

