/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.tooltip;

import com.atsuishio.superbwarfare.client.tooltip.ClientEnergyImageTooltip;
import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.FormatTool;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ClientSentinelImageTooltip
extends ClientEnergyImageTooltip {
    public ClientSentinelImageTooltip(GunImageComponent tooltip) {
        super(tooltip);
    }

    @Override
    protected Component getDamageComponent() {
        IEnergyStorage cap = (IEnergyStorage)this.stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (cap != null && cap.getEnergyStored() > 0) {
            double damage = this.data.damage();
            double extraDamage = -1.0;
            for (Perk.Type type : Perk.Type.values()) {
                PerkInstance instance = this.data.perk.getInstance(type);
                if (instance == null) continue;
                damage = instance.perk().getDisplayDamage(damage, this.data, instance);
                if (!(instance.perk().getExtraDisplayDamage(damage, this.data, instance) >= 0.0)) continue;
                extraDamage = instance.perk().getExtraDisplayDamage(damage, this.data, instance);
            }
            return Component.translatable((String)"des.superbwarfare.guns.damage").withStyle(ChatFormatting.GRAY).append((Component)Component.empty().withStyle(ChatFormatting.RESET)).append((Component)Component.literal((String)(FormatTool.format1D(damage) + (String)(extraDamage >= 0.0 ? " + " + FormatTool.format1D(extraDamage) : ""))).withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.BOLD));
        }
        return super.getDamageComponent();
    }
}

