/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.compat.jade.providers;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.block.ContainerBlock;
import com.atsuishio.superbwarfare.block.entity.ContainerBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum ContainerEntityProvider implements IBlockComponentProvider
{
    INSTANCE;

    private static final ResourceLocation ID;

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        ContainerBlockEntity container = (ContainerBlockEntity)blockAccessor.getBlockEntity();
        String registerName = EntityType.getKey(container.entityType).toString();
        String translationKey = ContainerBlock.getEntityTranslationKey(registerName);
        iTooltip.add((Component)Component.translatable((String)(translationKey == null ? "des.superbwarfare.container.empty" : translationKey)).withStyle(ChatFormatting.GRAY));
        EntityType entityType = EntityType.byString((String)registerName).orElse(null);
        if (entityType != null) {
            int h;
            float w = (float)Math.ceil(entityType.getDimensions().width() / 2.0f) * 2.0f;
            if ((int)w % 2 == 0) {
                w += 1.0f;
            }
            if ((h = (int)(entityType.getDimensions().height() + 1.0f)) != 0) {
                iTooltip.add((Component)Component.literal((String)((int)w + " x " + (int)w + " x " + h)).withStyle(ChatFormatting.YELLOW));
            }
        }
        if (!ContainerBlock.canOpen(blockAccessor.getLevel(), container.getBlockPos(), container.entityType)) {
            iTooltip.add((Component)Component.translatable((String)"des.superbwarfare.container.fail.open").withStyle(ChatFormatting.RED));
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }

    static {
        ID = Mod.loc("container_entity");
    }
}

