/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.component;

import com.atsuishio.superbwarfare.item.FiringParameters;
import com.atsuishio.superbwarfare.item.common.ammo.box.AmmoBoxInfo;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModDataComponents {
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"superbwarfare");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<FiringParameters.Parameters>> FIRING_PARAMETERS = ModDataComponents.register("firing_parameters", builder -> builder.persistent(RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(FiringParameters.Parameters::pos), (App)Codec.BOOL.fieldOf("is_depressed").forGetter(FiringParameters.Parameters::isDepressed)).apply((Applicative)instance, FiringParameters.Parameters::new))));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> ENERGY = ModDataComponents.register("energy", builder -> builder.persistent((Codec)Codec.INT));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<Pair<Integer, Double>>>> TRANSCRIPT_SCORE = ModDataComponents.register("transcript_score", builder -> builder.persistent(Codec.pair((Codec)Codec.INT.fieldOf("score").codec(), (Codec)Codec.DOUBLE.fieldOf("distance").codec()).listOf()));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<AmmoBoxInfo>> AMMO_BOX_INFO = ModDataComponents.register("ammo_box_info", builder -> builder.persistent(AmmoBoxInfo.CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<Short>>> DOG_TAG_IMAGE = ModDataComponents.register("dog_tag_image", builder -> builder.persistent(Codec.SHORT.listOf()));

    private static <T> DeferredHolder<DataComponentType<?>, DataComponentType<T>> register(String name, UnaryOperator<DataComponentType.Builder<T>> builderOperator) {
        return DATA_COMPONENT_TYPES.register(name, () -> ((DataComponentType.Builder)builderOperator.apply(DataComponentType.builder())).build());
    }

    public static void register(IEventBus eventBus) {
        for (Ammo type : Ammo.values()) {
            type.dataComponent = ModDataComponents.register("ammo_" + type.name, builder -> builder.persistent((Codec)Codec.INT));
        }
        DATA_COMPONENT_TYPES.register(eventBus);
    }
}

