/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.vehicle;

import com.atsuishio.superbwarfare.data.vehicle.DefaultVehicleData;
import com.atsuishio.superbwarfare.data.vehicle.VehicleDataTool;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VehicleData {
    public final String id;
    public final DefaultVehicleData data;
    public final VehicleEntity vehicle;
    public static final LoadingCache<VehicleEntity, VehicleData> dataCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<VehicleEntity, VehicleData>(){

        @NotNull
        public VehicleData load(@NotNull VehicleEntity entity) {
            return new VehicleData(entity);
        }
    });

    private VehicleData(VehicleEntity entity) {
        this.id = EntityType.getKey((EntityType)entity.getType()).toString();
        this.data = VehicleDataTool.vehicleData.getOrDefault(this.id, new DefaultVehicleData());
        this.vehicle = entity;
    }

    public static VehicleData from(VehicleEntity entity) {
        return (VehicleData)dataCache.getUnchecked((Object)entity);
    }

    public float maxHealth() {
        return this.data.maxHealth;
    }

    public int repairCooldown() {
        return this.data.repairCooldown;
    }

    public float repairAmount() {
        return this.data.repairAmount;
    }

    public String repairMaterial() {
        return this.data.repairMaterial;
    }

    public float repairMaterialHealAmount() {
        return this.data.repairMaterialHealAmount;
    }

    public boolean canRepairManually() {
        String material = this.repairMaterial();
        if (material == null) {
            return false;
        }
        if (material.startsWith("#")) {
            material = material.substring(1);
        }
        return ResourceLocation.tryParse((String)material) != null;
    }

    public boolean isRepairMaterial(ItemStack stack) {
        String material = this.repairMaterial();
        boolean useTag = false;
        if (material.startsWith("#")) {
            material = material.substring(1);
            useTag = true;
        }
        ResourceLocation location = ResourceLocation.parse((String)material);
        if (!useTag) {
            return stack.getItem() == BuiltInRegistries.ITEM.get(location);
        }
        return stack.is(ItemTags.create((ResourceLocation)location));
    }

    public float selfHurtPercent() {
        return Mth.clamp((float)this.data.selfHurtPercent, (float)0.0f, (float)1.0f);
    }

    public float selfHurtAmount() {
        return this.data.selfHurtAmount;
    }

    public int maxEnergy() {
        return this.data.maxEnergy;
    }

    public float upStep() {
        return this.data.upStep;
    }

    public boolean allowFreeCam() {
        return this.data.allowFreeCam;
    }

    public float mass() {
        return this.data.mass;
    }

    public DamageModifier damageModifier() {
        DamageModifier modifier = new DamageModifier();
        if (this.data.applyDefaultDamageModifiers) {
            modifier.immuneTo(EntityType.POTION).immuneTo(EntityType.AREA_EFFECT_CLOUD).immuneTo((ResourceKey<DamageType>)DamageTypes.FALL).immuneTo((ResourceKey<DamageType>)DamageTypes.DROWN).immuneTo((ResourceKey<DamageType>)DamageTypes.DRAGON_BREATH).immuneTo((ResourceKey<DamageType>)DamageTypes.WITHER).immuneTo((ResourceKey<DamageType>)DamageTypes.WITHER_SKULL).reduce(5.0f, ModDamageTypes.VEHICLE_STRIKE);
        }
        return modifier.addAll(this.data.damageModifiers);
    }
}

