/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.vehicle.DefaultVehicleData;
import com.atsuishio.superbwarfare.data.vehicle.VehicleData;
import com.atsuishio.superbwarfare.network.message.receive.VehiclesDataMessage;
import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="superbwarfare")
public class VehicleDataTool {
    public static HashMap<String, DefaultVehicleData> vehicleData = new HashMap();
    public static final String VEHICLE_DATA_FOLDER = "vehicles";

    public static void initJsonData(ResourceManager manager) {
        vehicleData.clear();
        VehicleData.dataCache.invalidateAll();
        for (Map.Entry entry : manager.listResources(VEHICLE_DATA_FOLDER, file -> file.getPath().endsWith(".json")).entrySet()) {
            Resource attribute = (Resource)entry.getValue();
            try {
                Object id;
                Gson gson = new Gson();
                DefaultVehicleData data = (DefaultVehicleData)gson.fromJson((Reader)new InputStreamReader(attribute.open()), DefaultVehicleData.class);
                if (!data.id.isEmpty()) {
                    id = data.id;
                } else {
                    String path = ((ResourceLocation)entry.getKey()).getPath();
                    id = "superbwarfare:" + path.substring(VEHICLE_DATA_FOLDER.length() + 1, path.length() - VEHICLE_DATA_FOLDER.length() - 1);
                    Mod.LOGGER.warn("Vehicle ID for {} is empty, try using {} as id", id, (Object)path);
                    data.id = id;
                }
                if (vehicleData.containsKey(id)) continue;
                vehicleData.put((String)id, data);
            }
            catch (Exception e) {
                Mod.LOGGER.error(e.getMessage());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MinecraftServer server = player2.getServer();
            if (server != null && server.isSingleplayerOwner(player2.getGameProfile())) {
                return;
            }
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)VehiclesDataMessage.create(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void serverStarted(ServerStartedEvent event) {
        VehicleDataTool.initJsonData(event.getServer().getResourceManager());
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        MinecraftServer server = event.getPlayerList().getServer();
        VehicleDataTool.initJsonData(server.getResourceManager());
        VehiclesDataMessage message = VehiclesDataMessage.create();
        for (ServerPlayer player : event.getRelevantPlayers().toList()) {
            if (server.isSingleplayerOwner(player.getGameProfile())) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

