/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.datagen;

import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModItems;
import java.util.List;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class ModBlockLootProvider
extends BlockLootSubProvider {
    public ModBlockLootProvider(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        this.dropSelf((Block)ModBlocks.SANDBAG.get());
        this.dropSelf((Block)ModBlocks.BARBED_WIRE.get());
        this.dropSelf((Block)ModBlocks.JUMP_PAD.get());
        this.dropSelf((Block)ModBlocks.DRAGON_TEETH.get());
        this.dropSelf((Block)ModBlocks.REFORGING_TABLE.get());
        this.dropSelf((Block)ModBlocks.LEAD_BLOCK.get());
        this.dropSelf((Block)ModBlocks.STEEL_BLOCK.get());
        this.dropSelf((Block)ModBlocks.TUNGSTEN_BLOCK.get());
        this.dropSelf((Block)ModBlocks.CEMENTED_CARBIDE_BLOCK.get());
        this.dropSelf((Block)ModBlocks.SILVER_BLOCK.get());
        this.dropSelf((Block)ModBlocks.CREATIVE_CHARGING_STATION.get());
        this.dropSelf((Block)ModBlocks.FUMO_25.get());
        this.dropSelf((Block)ModBlocks.VEHICLE_DEPLOYER.get());
        this.dropSelf((Block)ModBlocks.AIRCRAFT_CATAPULT.get());
        this.add((Block)ModBlocks.CHARGING_STATION.get(), this.createCopyComponentsDrops((Block)ModBlocks.CHARGING_STATION.get(), List.of((DataComponentType)ModDataComponents.ENERGY.get())));
        this.add((Block)ModBlocks.GALENA_ORE.get(), this.createOreDrop((Block)ModBlocks.GALENA_ORE.get(), (Item)ModItems.GALENA.get()));
        this.add((Block)ModBlocks.SCHEELITE_ORE.get(), this.createOreDrop((Block)ModBlocks.SCHEELITE_ORE.get(), (Item)ModItems.SCHEELITE.get()));
        this.add((Block)ModBlocks.SILVER_ORE.get(), this.createOreDrop((Block)ModBlocks.SILVER_ORE.get(), (Item)ModItems.RAW_SILVER.get()));
        this.add((Block)ModBlocks.DEEPSLATE_GALENA_ORE.get(), this.createOreDrop((Block)ModBlocks.DEEPSLATE_GALENA_ORE.get(), (Item)ModItems.GALENA.get()));
        this.add((Block)ModBlocks.DEEPSLATE_SCHEELITE_ORE.get(), this.createOreDrop((Block)ModBlocks.DEEPSLATE_SCHEELITE_ORE.get(), (Item)ModItems.SCHEELITE.get()));
        this.add((Block)ModBlocks.DEEPSLATE_SILVER_ORE.get(), this.createOreDrop((Block)ModBlocks.DEEPSLATE_SILVER_ORE.get(), (Item)ModItems.RAW_SILVER.get()));
        this.add((Block)ModBlocks.CONTAINER.get(), LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)ModBlocks.CONTAINER.get(), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModBlocks.CONTAINER.get()))).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.BLOCK_ENTITY_DATA)))));
        this.add((Block)ModBlocks.SMALL_CONTAINER.get(), LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)ModBlocks.SMALL_CONTAINER.get(), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModBlocks.SMALL_CONTAINER.get()))).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.CONTAINER_LOOT)))));
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return ModBlocks.REGISTRY.getEntries().stream().map(r -> (Block)r.value()).toList();
    }

    public LootTable.Builder createCopyComponentsDrops(Block pBlock, List<DataComponentType<?>> components) {
        LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)pBlock));
        if (!components.isEmpty()) {
            CopyComponentsFunction.Builder copy = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY);
            for (DataComponentType<?> type : components) {
                copy.include(type);
            }
            pool.apply((LootItemFunction.Builder)copy);
        }
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)pBlock, (ConditionUserBuilder)pool));
    }
}

