/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity;

import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

@EventBusSubscriber(modid="superbwarfare")
public class TargetEntity
extends LivingEntity
implements GeoEntity {
    public static final EntityDataAccessor<Integer> DOWN_TIME = SynchedEntityData.defineId(TargetEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public TargetEntity(EntityType<TargetEntity> type, Level world) {
        super(type, world);
        this.noCulling = true;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DOWN_TIME, (Object)0);
    }

    @NotNull
    public Iterable<ItemStack> getArmorSlots() {
        return NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    }

    @NotNull
    public ItemStack getItemBySlot(@NotNull EquipmentSlot pSlot) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(@NotNull EquipmentSlot pSlot, @NotNull ItemStack pStack) {
    }

    public boolean causeFallDamage(float l, float d, @NotNull DamageSource source) {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.IN_FIRE) || source.getDirectEntity() instanceof ThrownPotion || source.getDirectEntity() instanceof AreaEffectCloud || source.is(DamageTypes.FALL) || source.is(DamageTypes.CACTUS) || source.is(DamageTypes.DROWN) || source.is(DamageTypes.LIGHTNING_BOLT) || source.is(DamageTypes.FALLING_ANVIL) || source.is(DamageTypes.DRAGON_BREATH) || source.is(DamageTypes.WITHER) || source.is(DamageTypes.WITHER_SKULL) || source.is(DamageTypes.MAGIC) || (Integer)this.entityData.get(DOWN_TIME) > 0) {
            return false;
        }
        if (!this.level().isClientSide()) {
            this.level().playSound(null, BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ()), (SoundEvent)ModSounds.HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSounds.HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        return super.hurt(source, amount);
    }

    @SubscribeEvent
    public static void onTargetDown(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Entity sourceEntity = event.getSource().getEntity();
        if (entity instanceof TargetEntity) {
            TargetEntity targetEntity = (TargetEntity)entity;
            event.setCanceled(true);
            targetEntity.setHealth(targetEntity.getMaxHealth());
            if (sourceEntity == null) {
                return;
            }
            if (sourceEntity instanceof Player) {
                Player player = (Player)sourceEntity;
                player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.target.down", (Object[])new Object[]{FormatTool.format1D(entity.position().distanceTo(sourceEntity.position()), "m")}), true);
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.TARGET_DOWN.get(), 1.0f, 1.0f);
                targetEntity.entityData.set(DOWN_TIME, (Object)40);
            }
        }
    }

    public boolean isPickable() {
        return (Integer)this.entityData.get(DOWN_TIME) == 0;
    }

    public void die(@NotNull DamageSource source) {
        super.die(source);
    }

    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        if (player.getMainHandItem() != ItemStack.EMPTY) {
            return InteractionResult.PASS;
        }
        if (player.isShiftKeyDown()) {
            if (!this.level().isClientSide()) {
                this.discard();
            }
            if (!player.getAbilities().instabuild) {
                player.addItem(new ItemStack((ItemLike)ModItems.TARGET_DEPLOYER.get()));
            }
        } else {
            this.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3(player.getX(), this.getY(), player.getZ()));
            this.setXRot(0.0f);
            this.xRotO = this.getXRot();
            this.entityData.set(DOWN_TIME, (Object)0);
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    public void tick() {
        super.tick();
        if ((Integer)this.entityData.get(DOWN_TIME) > 0) {
            this.entityData.set(DOWN_TIME, (Object)((Integer)this.entityData.get(DOWN_TIME) - 1));
        }
    }

    @NotNull
    public Vec3 getDeltaMovement() {
        return new Vec3(0.0, 0.0, 0.0);
    }

    public boolean isPushable() {
        return false;
    }

    @NotNull
    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    protected void doPush(@NotNull Entity entityIn) {
    }

    protected void pushEntities() {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
        this.setNoGravity(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.MAX_HEALTH, 40.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.KNOCKBACK_RESISTANCE, 10.0).add(Attributes.FLYING_SPEED, 0.0);
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime >= 100) {
            this.spawnAtLocation(new ItemStack((ItemLike)ModItems.TARGET_DEPLOYER.get()));
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    private PlayState movementPredicate(AnimationState<TargetEntity> event) {
        if ((Integer)this.entityData.get(DOWN_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.target.down"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.target.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

