/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Tm62Entity
extends Entity
implements GeoEntity,
OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(Tm62Entity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    protected static final EntityDataAccessor<String> LAST_ATTACKER_UUID = SynchedEntityData.defineId(Tm62Entity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.defineId(Tm62Entity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> FUSE = SynchedEntityData.defineId(Tm62Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Tm62Entity(EntityType<Tm62Entity> type, Level world) {
        super(type, world);
    }

    public Tm62Entity(LivingEntity owner, Level level, boolean fuse) {
        super((EntityType)ModEntities.TM_62.get(), level);
        if (owner != null) {
            this.setOwnerUUID(owner.getUUID());
        }
        this.entityData.set(FUSE, (Object)fuse);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(OWNER_UUID, Optional.empty()).define(LAST_ATTACKER_UUID, (Object)"undefined").define(FUSE, (Object)false).define(HEALTH, (Object)Float.valueOf(100.0f));
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getDirectEntity() instanceof ThrownPotion || source.getDirectEntity() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        if (source.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (source.is(DamageTypes.DROWN)) {
            return false;
        }
        if (source.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        if (source.is(ModDamageTypes.CUSTOM_EXPLOSION) || source.is(ModDamageTypes.MINE) || source.is(ModDamageTypes.PROJECTILE_BOOM) || source.is(DamageTypes.EXPLOSION)) {
            amount *= 0.02f;
        }
        if (source.getEntity() != null) {
            this.entityData.set(LAST_ATTACKER_UUID, (Object)source.getEntity().getStringUUID());
        }
        this.entityData.set(HEALTH, (Object)Float.valueOf(((Float)this.entityData.get(HEALTH)).floatValue() - amount));
        return super.hurt(source, amount);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_UUID)).orElse(null);
    }

    public boolean isOwnedBy(LivingEntity pEntity) {
        return pEntity == this.getOwner();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat("Health", ((Float)this.entityData.get(HEALTH)).floatValue());
        compound.putString("LastAttacker", (String)this.entityData.get(LAST_ATTACKER_UUID));
        compound.putBoolean("Fuse", ((Boolean)this.entityData.get(FUSE)).booleanValue());
        if (this.getOwnerUUID() != null) {
            compound.putUUID("Owner", this.getOwnerUUID());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        UUID uuid;
        if (compound.contains("Health")) {
            this.entityData.set(HEALTH, (Object)Float.valueOf(compound.getFloat("Health")));
        }
        if (compound.contains("LastAttacker")) {
            this.entityData.set(LAST_ATTACKER_UUID, (Object)compound.getString("LastAttacker"));
        }
        if (compound.contains("Fuse")) {
            this.entityData.set(FUSE, (Object)compound.getBoolean("Fuse"));
        }
        if (compound.hasUUID("Owner")) {
            uuid = compound.getUUID("Owner");
        } else {
            String s = compound.getString("Owner");
            assert (this.getServer() != null);
            uuid = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.isOwnedBy((LivingEntity)player) && player.isShiftKeyDown()) {
            if (!this.level().isClientSide()) {
                this.discard();
            }
            if (!player.getAbilities().instabuild) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.TM_62.get()));
            }
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    public void tick() {
        Level level;
        super.tick();
        if (this.tickCount >= 20 && this.onGround() && !((Boolean)this.entityData.get(FUSE)).booleanValue()) {
            this.touchEntity();
        }
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        if (!this.level().noCollision(this.getBoundingBox())) {
            this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        float f = 0.98f;
        if (this.onGround()) {
            BlockPos pos = this.getBlockPosBelowThatAffectsMyMovement();
            f = this.level().getBlockState(pos).getFriction((LevelReader)this.level(), pos, (Entity)this) * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.98, (double)f));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
        if (((Boolean)this.entityData.get(FUSE)).booleanValue() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.SMOKE, this.xo, this.yo, this.zo, 1, 0.0, 0.0, 0.0, 0.01, true);
        }
        if (((Float)this.entityData.get(HEALTH)).floatValue() <= 0.0f || ((Boolean)this.entityData.get(FUSE)).booleanValue() && this.tickCount >= 100) {
            this.triggerExplode();
        }
        this.refreshDimensions();
    }

    public void touchEntity() {
        if (this.level() instanceof ServerLevel) {
            AABB frontBox = this.getBoundingBox().inflate(0.2);
            boolean trigger = false;
            List entities = this.level().getEntities(EntityTypeTest.forClass(Entity.class), frontBox, entity -> entity != this && !(entity instanceof HangingEntity) && (entity.getBoundingBox().getSize() > 1.5 || entity.getBoundingBox().getSize() > 0.9 && entity.getDeltaMovement().y() < -0.35)).stream().toList();
            for (Entity entity2 : entities) {
                if (entity2 == null) continue;
                trigger = true;
                break;
            }
            if (trigger) {
                this.triggerExplode();
            }
        }
    }

    private void triggerExplode() {
        CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this, (Entity)this.getOwner()), 450.0f, this.getX(), this.getEyeY(), this.getZ(), 13.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true);
        explosion.explode();
        EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
        explosion.finalizeExplosion(false);
        ParticleTool.spawnHugeExplosionParticles(this.level(), this.position());
        this.discard();
    }

    public boolean isPushable() {
        return super.isPushable();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void shoot(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        Vec3 vec3 = new Vec3(pX, pY, pZ).normalize().add(this.random.triangle(0.0, 0.0172275 * (double)pInaccuracy), this.random.triangle(0.0, 0.0172275 * (double)pInaccuracy), this.random.triangle(0.0, 0.0172275 * (double)pInaccuracy)).scale((double)pVelocity);
        this.setDeltaMovement(vec3);
    }
}

