/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.DecoyEntity;
import com.atsuishio.superbwarfare.entity.projectile.DestroyableProjectileEntity;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Agm65Entity
extends FastThrowableProjectile
implements GeoEntity,
DestroyableProjectileEntity,
ExplosiveProjectile {
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.defineId(Agm65Entity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.defineId(Agm65Entity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float damage = ((Integer)ExplosionConfig.AGM_65_DAMAGE.get()).intValue();
    private float explosionDamage = ((Integer)ExplosionConfig.AGM_65_EXPLOSION_DAMAGE.get()).intValue();
    private float explosionRadius = ((Double)ExplosionConfig.AGM_65_EXPLOSION_RADIUS.get()).floatValue();
    private boolean distracted = false;
    private int durability = 40;
    private boolean firstHit = true;

    public Agm65Entity(EntityType<? extends Agm65Entity> type, Level world) {
        super(type, world);
        this.noCulling = true;
    }

    public Agm65Entity(LivingEntity entity, Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.AGM_65.get()), entity, level);
    }

    public void setTargetUuid(String uuid) {
        this.entityData.set(TARGET_UUID, (Object)uuid);
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.AGM.get();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getDirectEntity() instanceof ThrownPotion || source.getDirectEntity() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        if (source.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (source.is(DamageTypes.DROWN)) {
            return false;
        }
        if (source.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        this.entityData.set(HEALTH, (Object)Float.valueOf(((Float)this.entityData.get(HEALTH)).floatValue() - amount));
        return super.hurt(source, amount);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HEALTH, (Object)Float.valueOf(30.0f)).define(TARGET_UUID, (Object)"none");
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Health")) {
            this.entityData.set(HEALTH, (Object)Float.valueOf(compound.getFloat("Health")));
        }
        if (compound.contains("Damage")) {
            this.damage = compound.getFloat("Damage");
        }
        if (compound.contains("ExplosionDamage")) {
            this.explosionDamage = compound.getFloat("ExplosionDamage");
        }
        if (compound.contains("Radius")) {
            this.explosionRadius = compound.getFloat("Radius");
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("Health", ((Float)this.entityData.get(HEALTH)).floatValue());
        compound.putFloat("Damage", this.damage);
        compound.putFloat("ExplosionDamage", this.explosionDamage);
        compound.putFloat("Radius", this.explosionRadius);
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        return true;
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (this.level() instanceof ServerLevel && this.tickCount > 8) {
            LivingEntity living;
            if (entity == this.getOwner() || this.getOwner() != null && entity == this.getOwner().getVehicle()) {
                return;
            }
            Entity entity2 = this.getOwner();
            if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).level().isClientSide() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.level().playSound(null, living.blockPosition(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            entity.hurt(ModDamageTypes.causeCannonFireDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.damage);
            if (entity instanceof LivingEntity) {
                entity.invulnerableTime = 0;
            }
            for (int i = 0; i < 5; ++i) {
                this.apExplode((HitResult)result, i);
            }
            this.causeExplode((HitResult)result);
            this.discard();
        }
    }

    public boolean isNoGravity() {
        return true;
    }

    public void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        if (this.level() instanceof ServerLevel) {
            float hardness;
            double x = blockHitResult.getLocation().x;
            double y = blockHitResult.getLocation().y;
            double z = blockHitResult.getLocation().z;
            if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() && (hardness = this.level().getBlockState(BlockPos.containing((double)x, (double)y, (double)z)).getBlock().defaultDestroyTime()) <= 50.0f && hardness != -1.0f) {
                BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
                Block.dropResources((BlockState)this.level().getBlockState(blockPos), (LevelAccessor)this.level(), (BlockPos)BlockPos.containing((double)x, (double)y, (double)z), null);
                this.level().destroyBlock(blockPos, true);
            }
            for (int i = 0; i < 5; ++i) {
                this.apExplode((HitResult)blockHitResult, i);
            }
            this.causeExplode((HitResult)blockHitResult);
        }
    }

    private void apExplode(HitResult result, int index) {
        CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.explosionDamage, result.getLocation().x + (double)index * this.getDeltaMovement().normalize().x, result.getLocation().y + (double)index * this.getDeltaMovement().normalize().y, result.getLocation().z + (double)index * this.getDeltaMovement().normalize().z, 0.5f * this.explosionRadius, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
        explosion.explode();
        EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
        explosion.finalizeExplosion(false);
    }

    @Override
    public void tick() {
        ServerLevel serverLevel;
        Level level;
        super.tick();
        Entity entity = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(TARGET_UUID));
        List<Entity> decoy = SeekTool.seekLivingEntities((Entity)this, this.level(), 32.0, 90.0);
        for (Entity e : decoy) {
            if (!(e instanceof DecoyEntity)) continue;
            DecoyEntity decoyEntity = (DecoyEntity)e;
            if (this.distracted) continue;
            this.entityData.set(TARGET_UUID, (Object)decoyEntity.getDecoyUUID());
            this.distracted = true;
        }
        if (!((String)this.entityData.get(TARGET_UUID)).equals("none") && entity != null && entity.level() instanceof ServerLevel) {
            if ((!entity.getPassengers().isEmpty() || entity instanceof VehicleEntity) && entity.tickCount % (int)Math.max((double)(0.04 * (double)this.distanceTo(entity)), (double)2.0) == 0) {
                entity.level().playSound(null, entity.getOnPos(), entity instanceof Pig ? SoundEvents.PIG_HURT : (SoundEvent)ModSounds.MISSILE_WARNING.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
            }
            Vec3 targetPos = new Vec3(entity.getX(), entity.getY() + (double)(entity instanceof EnderDragon ? -2 : 0) + 0.1 * (double)this.distanceTo(entity), entity.getZ());
            Vec3 toVec = this.getEyePosition().vectorTo(targetPos).normalize();
            if (this.tickCount > 8) {
                boolean lostTarget;
                boolean bl = lostTarget = VectorTool.calculateAngle(this.getDeltaMovement(), toVec) > 80.0;
                if (!lostTarget) {
                    this.setDeltaMovement(this.getDeltaMovement().add(toVec.scale(4.0)).scale(0.65).add(entity.getDeltaMovement().scale(0.2)));
                }
            }
        }
        if (this.tickCount == 8) {
            this.level().playSound(null, BlockPos.containing((Position)this.position()), (SoundEvent)ModSounds.MISSILE_START.get(), SoundSource.PLAYERS, 4.0f, 1.0f);
            if (!this.level().isClientSide() && (level = this.level()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                ParticleTool.sendParticle(serverLevel, ParticleTypes.CLOUD, this.xo, this.yo, this.zo, 15, 0.8, 0.8, 0.8, 0.01, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE, this.xo, this.yo, this.zo, 10, 0.8, 0.8, 0.8, 0.01, true);
            }
        }
        if (this.tickCount > 8) {
            if (!this.level().isClientSide() && (level = this.level()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                ParticleTool.sendParticle(serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE, this.xo, this.yo, this.zo, 1, 0.0, 0.0, 0.0, 0.0, true);
            }
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.06, 1.06, 1.06));
        }
        if (this.tickCount > 200 || this.isInWater() || ((Float)this.entityData.get(HEALTH)).floatValue() <= 0.0f) {
            if (this.level() instanceof ServerLevel) {
                ProjectileTool.causeCustomExplode(this, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), (Entity)this, this.explosionDamage, this.explosionRadius, 1.0f);
            }
            this.discard();
        }
        float f = (float)Mth.clamp((double)(1.0 - 0.005 * this.getDeltaMovement().length()), (double)0.001, (double)1.0);
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, (double)f, (double)f));
    }

    private void causeExplode(HitResult result) {
        CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.explosionDamage, this.getX(), this.getEyeY(), this.getZ(), this.explosionRadius, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
        explosion.explode();
        EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
        explosion.finalizeExplosion(false);
        ParticleTool.spawnHugeExplosionParticles(this.level(), result.getLocation());
    }

    private PlayState movementPredicate(AnimationState<Agm65Entity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.jvm.idle"));
    }

    protected double getDefaultGravity() {
        return this.tickCount > 8 ? 0.0 : (double)0.15f;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean shouldSyncMotion() {
        return true;
    }

    @Override
    @NotNull
    public SoundEvent getCloseSound() {
        return (SoundEvent)ModSounds.ROCKET_ENGINE.get();
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.ROCKET_FLY.get();
    }

    @Override
    public float getVolume() {
        return 0.7f;
    }

    @Override
    public void setDamage(float damage) {
        this.damage = damage;
    }

    @Override
    public void setExplosionDamage(float explosionDamage) {
        this.explosionDamage = explosionDamage;
    }

    @Override
    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }
}

