/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class C4Entity
extends Entity
implements GeoEntity,
OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(C4Entity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    protected static final EntityDataAccessor<String> LAST_ATTACKER_UUID = SynchedEntityData.defineId(C4Entity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    protected static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.defineId(C4Entity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> IS_CONTROLLABLE = SynchedEntityData.defineId(C4Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> BOMB_TICK = SynchedEntityData.defineId(C4Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final int DEFAULT_DEFUSE_PROGRESS = 100;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected boolean inGround;
    protected boolean onEntity;
    @Nullable
    private BlockState lastState;

    public C4Entity(EntityType<C4Entity> type, Level level) {
        super(type, level);
    }

    public C4Entity(LivingEntity owner, Level level) {
        this(owner, level, false);
    }

    public C4Entity(LivingEntity owner, Level level, boolean isControllable) {
        super((EntityType)ModEntities.C_4.get(), level);
        if (owner != null) {
            this.setOwnerUUID(owner.getUUID());
        }
        this.entityData.set(IS_CONTROLLABLE, (Object)isControllable);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(OWNER_UUID, Optional.empty()).define(LAST_ATTACKER_UUID, (Object)"undefined").define(TARGET_UUID, (Object)"undefined").define(IS_CONTROLLABLE, (Object)false).define(BOMB_TICK, (Object)0);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_UUID)).orElse(null);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        compound.putString("Target", (String)this.entityData.get(TARGET_UUID));
        compound.putString("LastAttacker", (String)this.entityData.get(LAST_ATTACKER_UUID));
        compound.putBoolean("IsControllable", ((Boolean)this.entityData.get(IS_CONTROLLABLE)).booleanValue());
        compound.putInt("BombTick", ((Integer)this.entityData.get(BOMB_TICK)).intValue());
        if (this.lastState != null) {
            compound.put("InBlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.lastState));
        }
        if (this.getOwnerUUID() != null) {
            compound.putUUID("Owner", this.getOwnerUUID());
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        UUID uuid;
        if (compound.contains("LastAttacker")) {
            this.entityData.set(LAST_ATTACKER_UUID, (Object)compound.getString("LastAttacker"));
        }
        if (compound.contains("Target")) {
            this.entityData.set(TARGET_UUID, (Object)compound.getString("Target"));
        }
        if (compound.contains("InBlockState", 10)) {
            this.lastState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compound.getCompound("InBlockState"));
        }
        if (compound.contains("IsControllable")) {
            this.entityData.set(IS_CONTROLLABLE, (Object)compound.getBoolean("IsControllable"));
        }
        if (compound.contains("BombTick")) {
            this.entityData.set(BOMB_TICK, (Object)compound.getInt("BombTick"));
        }
        if (compound.hasUUID("Owner")) {
            uuid = compound.getUUID("Owner");
        } else {
            String s = compound.getString("Owner");
            assert (this.getServer() != null);
            uuid = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.getOwner() == player && player.isShiftKeyDown()) {
            if (!this.level().isClientSide()) {
                this.discard();
            }
            if (!player.getAbilities().instabuild) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.getItemStack());
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return InteractionResult.PASS;
    }

    public void tick() {
        VoxelShape voxelshape;
        super.tick();
        if (!((Boolean)this.entityData.get(IS_CONTROLLABLE)).booleanValue()) {
            int countdown;
            int bombTick = (Integer)this.entityData.get(BOMB_TICK);
            if (bombTick >= (Integer)ExplosionConfig.C4_EXPLOSION_COUNTDOWN.get()) {
                this.explode();
            }
            if ((countdown = ((Integer)ExplosionConfig.C4_EXPLOSION_COUNTDOWN.get()).intValue()) - bombTick > 39 && bombTick % (20 * (countdown - bombTick) / countdown + 1) == 0) {
                this.level().playSound(null, this.getOnPos(), (SoundEvent)ModSounds.C4_BEEP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (bombTick == countdown - 39) {
                this.level().playSound(null, this.getOnPos(), (SoundEvent)ModSounds.C4_FINAL.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
            }
            this.entityData.set(BOMB_TICK, (Object)(bombTick + 1));
        }
        Vec3 motion = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f && !this.inGround) {
            double d0 = motion.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)motion.y, (double)d0) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        BlockPos blockpos = this.blockPosition();
        BlockState blockstate = this.level().getBlockState(blockpos);
        if (!blockstate.isAir() && !(voxelshape = blockstate.getCollisionShape((BlockGetter)this.level(), blockpos)).isEmpty()) {
            Vec3 vec31 = this.position();
            for (AABB aabb : voxelshape.toAabbs()) {
                if (!aabb.move(blockpos).contains(vec31)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.inGround) {
            if (this.lastState != blockstate && this.shouldFall()) {
                this.startFalling();
            }
        } else if (!this.onEntity) {
            Vec3 position = this.position();
            Vec3 nextPosition = position.add(motion);
            BlockHitResult hitresult = this.level().clip(new ClipContext(position, nextPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.getType() != HitResult.Type.MISS) {
                nextPosition = hitresult.getLocation();
            }
            while (!this.isRemoved()) {
                EntityHitResult entityhitresult = this.findHitEntity(position, nextPosition);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.getType() != HitResult.Type.MISS) {
                    this.onHit((HitResult)hitresult);
                    this.hasImpulse = true;
                    break;
                }
                if (entityhitresult == null) break;
                hitresult = null;
            }
            if (this.isRemoved()) {
                return;
            }
            motion = this.getDeltaMovement();
            double pX = motion.x;
            double pY = motion.y;
            double pZ = motion.z;
            double nX = this.getX() + pX;
            double nY = this.getY() + pY;
            double nZ = this.getZ() + pZ;
            this.updateRotation();
            float f = 0.99f;
            if (this.isInWater()) {
                for (int j = 0; j < 4; ++j) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, nX - pX * 0.25, nY - pY * 0.25, nZ - pZ * 0.25, pX, pY, pZ);
                }
                f = this.getWaterInertia();
            }
            this.setDeltaMovement(motion.scale((double)f));
            if (!this.isNoGravity()) {
                Vec3 vec34 = this.getDeltaMovement();
                this.setDeltaMovement(vec34.x, vec34.y - (double)0.05f, vec34.z);
            }
            this.setPos(nX, nY, nZ);
            this.checkInsideBlocks();
        } else {
            Entity target = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(TARGET_UUID));
            if (target != null) {
                this.setPos(target.getX(), target.getY() + (double)target.getBbHeight(), target.getZ());
            } else {
                this.onEntity = false;
            }
        }
        this.refreshDimensions();
    }

    private boolean shouldFall() {
        return this.inGround && this.level().noCollision(new AABB(this.position(), this.position()).inflate(0.06));
    }

    private void startFalling() {
        this.inGround = false;
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(vec3.multiply((double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f)));
    }

    @ParametersAreNonnullByDefault
    public void move(MoverType pType, Vec3 pPos) {
        super.move(pType, pPos);
        if (pType != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    public void look(Vec3 pTarget) {
        double d0 = pTarget.x;
        double d1 = pTarget.y;
        double d2 = pTarget.z;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.setXRot(Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875)))));
        this.setYHeadRot(this.getYRot());
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
    }

    protected void updateRotation() {
        if (this.getDeltaMovement().length() > 0.05 && !this.inGround && !this.onEntity) {
            Vec3 vec3 = this.getDeltaMovement();
            double d0 = vec3.horizontalDistance();
            this.setXRot(C4Entity.lerpRotation(this.xRotO, (float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875)));
            this.setYRot(C4Entity.lerpRotation(this.yRotO, (float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875)));
        }
    }

    protected static float lerpRotation(float pCurrentRotation, float pTargetRotation) {
        while (pTargetRotation - pCurrentRotation < -180.0f) {
            pCurrentRotation -= 360.0f;
        }
        while (pTargetRotation - pCurrentRotation >= 180.0f) {
            pCurrentRotation += 360.0f;
        }
        return Mth.lerp((float)0.2f, (float)pCurrentRotation, (float)pTargetRotation);
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)pStartVec, (Vec3)pEndVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), this::canHitEntity);
    }

    protected boolean canHitEntity(Entity pTarget) {
        if (!pTarget.canBeHitByProjectile()) {
            return false;
        }
        LivingEntity entity = this.getOwner();
        return entity == null || entity == pTarget && this.tickCount > 2 || !entity.isPassengerOfSameVehicle(pTarget);
    }

    protected void onHit(HitResult pResult) {
        switch (pResult.getType()) {
            case BLOCK: {
                this.onHitBlock((BlockHitResult)pResult);
                break;
            }
            case ENTITY: {
                this.onHitEntity((EntityHitResult)pResult);
                break;
            }
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult pResult) {
        Entity entity = pResult.getEntity();
        if (this.tickCount < 2 || entity == this.getVehicle() || entity instanceof C4Entity) {
            return;
        }
        this.entityData.set(TARGET_UUID, (Object)entity.getStringUUID());
        this.onEntity = true;
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.0, 0.0, 0.0));
        this.setXRot(-90.0f);
        this.xRotO = this.getXRot();
    }

    protected void onHitBlock(BlockHitResult pResult) {
        this.lastState = this.level().getBlockState(pResult.getBlockPos());
        Vec3 vec3 = pResult.getLocation().subtract(this.getX(), this.getY(), this.getZ());
        this.setDeltaMovement(vec3);
        Vec3 vec31 = vec3.normalize().scale((double)0.05f);
        this.setPosRaw(this.getX() - vec31.x, this.getY() - vec31.y, this.getZ() - vec31.z);
        this.look(Vec3.atLowerCornerOf((Vec3i)pResult.getDirection().getNormal()));
        this.setYRot(pResult.getDirection().get2DDataValue() * 90);
        BlockPos resultPos = pResult.getBlockPos();
        BlockState state = this.level().getBlockState(resultPos);
        SoundEvent event = state.getBlock().getSoundType(state, (LevelReader)this.level(), resultPos, (Entity)this).getBreakSound();
        double speed = this.getDeltaMovement().length();
        if (speed > 0.1) {
            this.level().playSound(null, pResult.getLocation().x, pResult.getLocation().y, pResult.getLocation().z, event, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        this.inGround = true;
    }

    public void explode() {
        Entity target;
        Vec3 pos = this.position();
        if (this.onEntity && (target = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(TARGET_UUID))) != null) {
            pos = target.position();
        }
        CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), this, (Entity)this.getOwner()), ((Integer)ExplosionConfig.C4_EXPLOSION_DAMAGE.get()).intValue(), pos.x, pos.y, pos.z, ((Integer)ExplosionConfig.C4_EXPLOSION_RADIUS.get()).intValue(), (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
        explosion.explode();
        EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
        ParticleTool.spawnHugeExplosionParticles(this.level(), this.position());
        explosion.finalizeExplosion(false);
        this.discard();
    }

    @NotNull
    public EntityDimensions getDimensions(@NotNull Pose pPose) {
        return super.getDimensions(pPose).scale(0.5f);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public boolean isPickable() {
        return true;
    }

    public ItemStack getItemStack() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.C4_BOMB.get());
        if (((Boolean)this.getEntityData().get(IS_CONTROLLABLE)).booleanValue()) {
            CompoundTag tag = NBTTool.getTag(stack);
            tag.putBoolean("Control", true);
            NBTTool.saveTag(stack, tag);
        }
        return stack;
    }

    public void defuse() {
        this.discard();
        ItemEntity entity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getItemStack());
        if (!this.level().isClientSide) {
            this.level().addFreshEntity((Entity)entity);
        }
    }

    public int getBombTick() {
        return (Integer)this.entityData.get(BOMB_TICK);
    }
}

