/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.network.message.receive.ClientMotionSyncMessage;
import com.atsuishio.superbwarfare.tools.ChunkLoadTool;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CannonShellEntity
extends FastThrowableProjectile
implements GeoEntity,
ExplosiveProjectile {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float damage = 0.0f;
    private float radius = 0.0f;
    private float explosionDamage = 0.0f;
    private float fireProbability = 0.0f;
    private int fireTime = 0;
    private int durability = 40;
    private boolean firstHit = true;
    public Set<Long> loadedChunks = new HashSet<Long>();
    private float gravity = 0.1f;

    public CannonShellEntity(EntityType<? extends CannonShellEntity> type, Level world) {
        super(type, world);
        this.noCulling = true;
    }

    public CannonShellEntity(LivingEntity entity, Level world, float damage, float radius, float explosionDamage, float fireProbability, int fireTime, float gravity) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.CANNON_SHELL.get()), entity, world);
        this.damage = damage;
        this.radius = radius;
        this.explosionDamage = explosionDamage;
        this.fireProbability = fireProbability;
        this.fireTime = fireTime;
        this.gravity = gravity;
    }

    public CannonShellEntity durability(int durability) {
        this.durability = durability;
        return this;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putFloat("Damage", this.damage);
        pCompound.putFloat("ExplosionDamage", this.explosionDamage);
        pCompound.putFloat("Radius", this.radius);
        pCompound.putFloat("FireProbability", this.fireProbability);
        pCompound.putInt("FireTime", this.fireTime);
        pCompound.putInt("Durability", this.durability);
        ListTag listTag = new ListTag();
        for (long chunkPos : this.loadedChunks) {
            CompoundTag tag = new CompoundTag();
            tag.putLong("Pos", chunkPos);
            listTag.add((Object)tag);
        }
        pCompound.put("Chunks", (Tag)listTag);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("Damage")) {
            this.damage = pCompound.getFloat("Damage");
        }
        if (pCompound.contains("ExplosionDamage")) {
            this.explosionDamage = pCompound.getFloat("ExplosionDamage");
        }
        if (pCompound.contains("Radius")) {
            this.radius = pCompound.getFloat("Radius");
        }
        if (pCompound.contains("FireProbability")) {
            this.fireProbability = pCompound.getFloat("FireProbability");
        }
        if (pCompound.contains("FireTime")) {
            this.fireTime = pCompound.getInt("FireTime");
        }
        if (pCompound.contains("Durability")) {
            this.durability = pCompound.getInt("Durability");
        }
        if (pCompound.contains("Chunks")) {
            ListTag listTag = pCompound.getList("Chunks", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag tag = listTag.getCompound(i);
                this.loadedChunks.add(tag.getLong("Pos"));
            }
        }
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.HE_5_INCHES.get();
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        return true;
    }

    public void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        if (this.level() instanceof ServerLevel) {
            LivingEntity living;
            Entity entity;
            Entity entity2 = entityHitResult.getEntity();
            entity2.hurt(ModDamageTypes.causeCannonFireDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.damage);
            if (entity2 instanceof LivingEntity) {
                entity2.invulnerableTime = 0;
            }
            if ((entity = this.getOwner()) instanceof LivingEntity && !(living = (LivingEntity)entity).level().isClientSide() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.level().playSound(null, living.blockPosition(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            ParticleTool.cannonHitParticles(this.level(), this.position(), (Entity)this);
            this.causeExplode(entityHitResult.getLocation());
            if (entity2 instanceof VehicleEntity) {
                this.discard();
            }
        }
    }

    public void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        if (this.level() instanceof ServerLevel) {
            double x = blockHitResult.getLocation().x;
            double y = blockHitResult.getLocation().y;
            double z = blockHitResult.getLocation().z;
            if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
                float hardness = this.level().getBlockState(BlockPos.containing((double)x, (double)y, (double)z)).getBlock().defaultDestroyTime();
                BlockState blockState = this.level().getBlockState(BlockPos.containing((double)x, (double)y, (double)z));
                if (hardness == -1.0f) {
                    this.discard();
                    this.causeExplode(blockHitResult.getLocation());
                    return;
                }
                this.durability -= (int)hardness;
                if (hardness <= 50.0f) {
                    BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
                    Block.dropResources((BlockState)this.level().getBlockState(blockPos), (LevelAccessor)this.level(), (BlockPos)BlockPos.containing((double)x, (double)y, (double)z), null);
                    this.level().destroyBlock(blockPos, true);
                }
                if (blockState.is((Block)ModBlocks.SANDBAG.get()) || blockState.is(Blocks.NETHERITE_BLOCK)) {
                    this.durability -= 10;
                }
                if (blockState.is(Blocks.IRON_BLOCK) || blockState.is(Blocks.COPPER_BLOCK)) {
                    this.durability -= 5;
                }
                if (blockState.is(Blocks.GOLD_BLOCK)) {
                    this.durability -= 3;
                }
                if (this.durability <= 0) {
                    this.causeExplode(blockHitResult.getLocation());
                } else {
                    if (this.firstHit) {
                        ParticleTool.cannonHitParticles(this.level(), this.position(), (Entity)this);
                        this.causeExplode(blockHitResult.getLocation());
                        this.firstHit = false;
                    }
                    this.apExplode((HitResult)blockHitResult);
                }
            } else {
                if (this.durability > 0) {
                    this.apExplode((HitResult)blockHitResult);
                }
                this.causeExplode(blockHitResult.getLocation());
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.SMOKE, this.xo, this.yo, this.zo, 1, 0.0, 0.0, 0.0, 0.001, true);
            ChunkLoadTool.updateLoadedChunks(serverLevel, (Entity)this, this.loadedChunks);
        }
        if (this.tickCount > 600 || this.isInWater()) {
            if (this.level() instanceof ServerLevel) {
                ProjectileTool.causeCustomExplode(this, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), (Entity)this, this.explosionDamage, this.radius, 1.25f);
            }
            this.discard();
        }
    }

    @Override
    public void syncMotion() {
        if (!this.level().isClientSide) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ClientMotionSyncMessage((Entity)this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void causeExplode(Vec3 vec) {
        if (Math.random() > (double)this.fireProbability) {
            this.fireTime = 0;
        }
        CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.explosionDamage, vec.x(), vec.y(), vec.z(), this.radius, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f).setFireTime(this.fireTime);
        explosion.explode();
        EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
        explosion.finalizeExplosion(false);
        if (this.radius > 7.0f) {
            ParticleTool.spawnHugeExplosionParticles(this.level(), vec);
        } else {
            ParticleTool.spawnMediumExplosionParticles(this.level(), vec);
        }
        this.discard();
    }

    private void apExplode(HitResult result) {
        if (Math.random() > (double)this.fireProbability) {
            this.fireTime = 0;
        }
        CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.explosionDamage, result.getLocation().x + 5.0 * this.getDeltaMovement().normalize().x, result.getLocation().y + 5.0 * this.getDeltaMovement().normalize().y, result.getLocation().z + 5.0 * this.getDeltaMovement().normalize().z, this.radius, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f).setFireTime(this.fireTime);
        explosion.explode();
        EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
        explosion.finalizeExplosion(false);
        if (this.radius > 7.0f) {
            ParticleTool.spawnHugeExplosionParticles(this.level(), result.getLocation());
        } else {
            ParticleTool.spawnMediumExplosionParticles(this.level(), result.getLocation());
        }
        this.discard();
    }

    private PlayState movementPredicate(AnimationState<CannonShellEntity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.cannon_shell.idle"));
    }

    protected double getDefaultGravity() {
        return this.gravity;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void onRemovedFromLevel() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkLoadTool.unloadAllChunks(serverLevel, (Entity)this, this.loadedChunks);
        }
        super.onRemovedFromLevel();
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.SHELL_FLY.get();
    }

    @Override
    public float getVolume() {
        return 0.07f;
    }

    @Override
    public void setDamage(float damage) {
        this.damage = damage;
    }

    @Override
    public void setExplosionDamage(float damage) {
        this.explosionDamage = damage;
    }

    @Override
    public void setExplosionRadius(float radius) {
        this.radius = radius;
    }
}

