/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.DecoyEntity;
import com.atsuishio.superbwarfare.entity.projectile.DestroyableProjectileEntity;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class JavelinMissileEntity
extends FastThrowableProjectile
implements GeoEntity,
DestroyableProjectileEntity,
ExplosiveProjectile {
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.defineId(JavelinMissileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.defineId(JavelinMissileEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> TOP = SynchedEntityData.defineId(JavelinMissileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> TARGET_X = SynchedEntityData.defineId(JavelinMissileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> TARGET_Y = SynchedEntityData.defineId(JavelinMissileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> TARGET_Z = SynchedEntityData.defineId(JavelinMissileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float monsterMultiplier = 0.0f;
    private float damage = 500.0f;
    private float explosionDamage = 140.0f;
    private float explosionRadius = 6.0f;
    private boolean distracted = false;
    private int guide_type = 0;

    public JavelinMissileEntity(EntityType<? extends JavelinMissileEntity> type, Level world) {
        super(type, world);
        this.noCulling = true;
    }

    public JavelinMissileEntity(LivingEntity entity, Level level, float damage, float explosionDamage, float explosionRadius, int guide_type, Vec3 targetPos) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.JAVELIN_MISSILE.get()), entity, level);
        this.damage = damage;
        this.explosionDamage = explosionDamage;
        this.explosionRadius = explosionRadius;
        this.guide_type = guide_type;
        this.entityData.set(TARGET_X, (Object)Float.valueOf((float)targetPos.x));
        this.entityData.set(TARGET_Y, (Object)Float.valueOf((float)targetPos.y));
        this.entityData.set(TARGET_Z, (Object)Float.valueOf((float)targetPos.z));
    }

    public void setMonsterMultiplier(float monsterMultiplier) {
        this.monsterMultiplier = monsterMultiplier;
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.JAVELIN_MISSILE.get();
    }

    public void setTargetUuid(String uuid) {
        this.entityData.set(TARGET_UUID, (Object)uuid);
    }

    public void setAttackMode(boolean mode) {
        this.entityData.set(TOP, (Object)mode);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getDirectEntity() instanceof ThrownPotion || source.getDirectEntity() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        if (source.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (source.is(DamageTypes.DROWN)) {
            return false;
        }
        if (source.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        this.entityData.set(HEALTH, (Object)Float.valueOf(((Float)this.entityData.get(HEALTH)).floatValue() - amount));
        return super.hurt(source, amount);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HEALTH, (Object)Float.valueOf(10.0f)).define(TARGET_UUID, (Object)"none").define(TOP, (Object)false).define(TARGET_X, (Object)Float.valueOf(0.0f)).define(TARGET_Y, (Object)Float.valueOf(0.0f)).define(TARGET_Z, (Object)Float.valueOf(0.0f));
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        super.readAdditionalSaveData(compound);
        if (compound.contains("Health")) {
            this.entityData.set(HEALTH, (Object)Float.valueOf(compound.getFloat("Health")));
        }
        if (compound.contains("Damage")) {
            this.damage = compound.getFloat("Damage");
        }
        if (compound.contains("ExplosionDamage")) {
            this.explosionDamage = compound.getFloat("ExplosionDamage");
        }
        if (compound.contains("Radius")) {
            this.explosionRadius = compound.getFloat("Radius");
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("Health", ((Float)this.entityData.get(HEALTH)).floatValue());
        compound.putFloat("Damage", this.damage);
        compound.putFloat("ExplosionDamage", this.explosionDamage);
        compound.putFloat("Radius", this.explosionRadius);
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        return true;
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity living;
        float damageMultiplier = 1.0f + this.monsterMultiplier;
        Entity entity = result.getEntity();
        if (entity == this.getOwner() || entity == this.getVehicle()) {
            return;
        }
        Entity entity2 = this.getOwner();
        if (entity2 instanceof LivingEntity && !(living = (LivingEntity)entity2).level().isClientSide() && living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            living.level().playSound(null, living.blockPosition(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (entity instanceof Monster) {
            Monster monster = (Monster)entity;
            monster.hurt(ModDamageTypes.causeCannonFireDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), ((Boolean)this.entityData.get(TOP) != false ? 1.3f : 1.0f) * this.damage * damageMultiplier);
        } else {
            entity.hurt(ModDamageTypes.causeCannonFireDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), ((Boolean)this.entityData.get(TOP) != false ? 1.3f : 1.0f) * this.damage);
        }
        if (entity instanceof LivingEntity) {
            entity.invulnerableTime = 0;
        }
        if (this.tickCount > 1 && this.level() instanceof ServerLevel) {
            this.causeExplode((HitResult)result);
        }
        this.discard();
    }

    public boolean isNoGravity() {
        return true;
    }

    public void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        BlockPos resultPos = blockHitResult.getBlockPos();
        BlockState state = this.level().getBlockState(resultPos);
        Block block = state.getBlock();
        if (block instanceof BellBlock) {
            BellBlock bell = (BellBlock)block;
            bell.attemptToRing(this.level(), resultPos, blockHitResult.getDirection());
        }
        if (this.tickCount > 1 && this.level() instanceof ServerLevel) {
            this.causeExplode((HitResult)blockHitResult);
        }
        this.discard();
    }

    @Override
    public void tick() {
        Level level;
        super.tick();
        Entity entity = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(TARGET_UUID));
        List<Entity> decoy = SeekTool.seekLivingEntities((Entity)this, this.level(), 32.0, 90.0);
        for (Entity e : decoy) {
            if (!(e instanceof DecoyEntity)) continue;
            DecoyEntity decoyEntity = (DecoyEntity)e;
            if (this.distracted) continue;
            this.entityData.set(TARGET_UUID, (Object)decoyEntity.getDecoyUUID());
            this.distracted = true;
        }
        if (this.guide_type == 0 || !((String)this.entityData.get(TARGET_UUID)).equals("none")) {
            if (entity != null && entity.level() instanceof ServerLevel) {
                this.entityData.set(TARGET_X, (Object)Float.valueOf((float)entity.getX()));
                this.entityData.set(TARGET_Y, (Object)Float.valueOf((float)entity.getY() + 0.5f * entity.getBbHeight()));
                this.entityData.set(TARGET_Z, (Object)Float.valueOf((float)entity.getZ()));
                if ((!entity.getPassengers().isEmpty() || entity instanceof VehicleEntity) && entity.tickCount % (int)Math.max(0.04 * (double)this.distanceTo(entity), 2.0) == 0) {
                    entity.level().playSound(null, entity.getOnPos(), entity instanceof Pig ? SoundEvents.PIG_HURT : (SoundEvent)ModSounds.MISSILE_WARNING.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
                }
            }
            double px = this.getX();
            double ex = ((Float)this.entityData.get(TARGET_X)).floatValue();
            double pz = this.getZ();
            double ez = ((Float)this.entityData.get(TARGET_Z)).floatValue();
            boolean dir = Math.sqrt(Math.pow(px - ex, 2.0) + Math.pow(pz - ez, 2.0)) < 30.0;
            Vec3 targetPos = new Vec3((double)((Float)this.entityData.get(TARGET_X)).floatValue(), (double)(((Float)this.entityData.get(TARGET_Y)).floatValue() + (float)(entity instanceof EnderDragon ? -3 : 0)), (double)((Float)this.entityData.get(TARGET_Z)).floatValue());
            if (entity != null) {
                Vec3 toVec = this.getEyePosition().vectorTo(targetPos.add(entity.getDeltaMovement().scale(0.5))).normalize();
                if (this.tickCount > 3) {
                    if (((Boolean)this.entityData.get(TOP)).booleanValue()) {
                        if (!dir) {
                            Vec3 targetTopPos = new Vec3((double)((Float)this.entityData.get(TARGET_X)).floatValue(), (double)(((Float)this.entityData.get(TARGET_Y)).floatValue() + (float)Mth.clamp((int)(5 * this.tickCount), (int)0, (int)90)), (double)((Float)this.entityData.get(TARGET_Z)).floatValue());
                            Vec3 toTopVec = this.getEyePosition().vectorTo(targetTopPos).normalize();
                            this.setDeltaMovement(this.getDeltaMovement().add(toTopVec.scale(0.5)));
                        } else {
                            boolean lostTarget;
                            boolean bl = lostTarget = this.getY() < entity.getY();
                            if (!lostTarget) {
                                this.setDeltaMovement(this.getDeltaMovement().add(toVec).scale(0.87));
                            }
                        }
                    } else {
                        boolean lostTarget;
                        boolean bl = lostTarget = VectorTool.calculateAngle(this.getDeltaMovement(), toVec) > 80.0;
                        if (!lostTarget) {
                            this.setDeltaMovement(this.getDeltaMovement().add(toVec).scale(0.87));
                        }
                    }
                }
            }
        } else if (this.guide_type == 1) {
            double px = this.getX();
            double ex = ((Float)this.entityData.get(TARGET_X)).floatValue();
            double pz = this.getZ();
            double ez = ((Float)this.entityData.get(TARGET_Z)).floatValue();
            boolean dir = Math.sqrt(Math.pow(px - ex, 2.0) + Math.pow(pz - ez, 2.0)) < 30.0;
            Vec3 targetPos = new Vec3((double)((Float)this.entityData.get(TARGET_X)).floatValue(), (double)((Float)this.entityData.get(TARGET_Y)).floatValue(), (double)((Float)this.entityData.get(TARGET_Z)).floatValue());
            Vec3 toVec = this.getEyePosition().vectorTo(targetPos).normalize();
            if (this.tickCount > 3) {
                if (((Boolean)this.entityData.get(TOP)).booleanValue()) {
                    if (!dir) {
                        Vec3 targetTopPos = new Vec3((double)((Float)this.entityData.get(TARGET_X)).floatValue(), (double)(((Float)this.entityData.get(TARGET_Y)).floatValue() + (float)Mth.clamp((int)(5 * this.tickCount), (int)0, (int)90)), (double)((Float)this.entityData.get(TARGET_Z)).floatValue());
                        Vec3 toTopVec = this.getEyePosition().vectorTo(targetTopPos).normalize();
                        this.setDeltaMovement(this.getDeltaMovement().add(toTopVec.scale(0.5)));
                    } else {
                        boolean lostTarget;
                        boolean bl = lostTarget = this.getY() < (double)((Float)this.entityData.get(TARGET_Y)).floatValue();
                        if (!lostTarget) {
                            this.setDeltaMovement(this.getDeltaMovement().add(toVec).scale(0.87));
                        }
                    }
                } else {
                    boolean lostTarget;
                    boolean bl = lostTarget = VectorTool.calculateAngle(this.getDeltaMovement(), toVec) > 80.0;
                    if (!lostTarget) {
                        this.setDeltaMovement(this.getDeltaMovement().add(toVec).scale(0.87));
                    }
                }
            }
        }
        if (this.tickCount == 4 && !this.level().isClientSide() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.CLOUD, this.xo, this.yo, this.zo, 15, 0.8, 0.8, 0.8, 0.01, true);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE, this.xo, this.yo, this.zo, 10, 0.8, 0.8, 0.8, 0.01, true);
        }
        if (this.tickCount > 4 && !this.level().isClientSide() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE, this.xo, this.yo, this.zo, 1, 0.0, 0.0, 0.0, 0.0, true);
        }
        if (this.tickCount > 200 || this.isInWater() || ((Float)this.entityData.get(HEALTH)).floatValue() <= 0.0f) {
            if (this.level() instanceof ServerLevel) {
                ProjectileTool.causeCustomExplode(this, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), (Entity)this, this.explosionDamage, this.explosionRadius, this.monsterMultiplier);
            }
            this.discard();
        }
        if (this.getDeltaMovement().length() < 2.6) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.06, 1.06, 1.06));
        }
        if (this.getDeltaMovement().length() > 2.9) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.9, 0.9, 0.9));
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.96, 0.96, 0.96));
    }

    private void causeExplode(HitResult result) {
        CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.explosionDamage, this.getX(), this.getEyeY(), this.getZ(), this.explosionRadius, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(this.monsterMultiplier);
        explosion.explode();
        EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
        explosion.finalizeExplosion(false);
        ParticleTool.spawnMediumExplosionParticles(this.level(), result.getLocation());
    }

    private PlayState movementPredicate(AnimationState<JavelinMissileEntity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.jvm.idle"));
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean shouldSyncMotion() {
        return true;
    }

    @Override
    @NotNull
    public SoundEvent getCloseSound() {
        return (SoundEvent)ModSounds.ROCKET_ENGINE.get();
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.ROCKET_FLY.get();
    }

    @Override
    public float getVolume() {
        return 0.4f;
    }

    @Override
    public void setDamage(float damage) {
        this.damage = damage;
    }

    @Override
    public void setExplosionDamage(float damage) {
        this.explosionDamage = damage;
    }

    @Override
    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }
}

