/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.block.BarbedWireBlock;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.config.server.ProjectileConfig;
import com.atsuishio.superbwarfare.entity.DPSGeneratorEntity;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.mixin.ICustomKnockback;
import com.atsuishio.superbwarfare.entity.projectile.CustomSyncMotionEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.Beast;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.network.message.receive.ClientMotionSyncMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.ExtendedEntityRayTraceResult;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.HitboxHelper;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ProjectileEntity
extends Projectile
implements IEntityWithComplexSpawn,
GeoEntity,
CustomSyncMotionEntity {
    public static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(ProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(ProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(ProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Predicate<Entity> PROJECTILE_TARGETS = input -> input != null && input.isPickable() && !input.isSpectator() && input.isAlive();
    private static final Predicate<BlockState> IGNORE_LIST = input -> input != null && (input.getBlock() instanceof LeavesBlock || input.getBlock() instanceof FenceBlock || input.is(Blocks.IRON_BARS) || input.getBlock() instanceof DoorBlock || input.getBlock() instanceof TrapDoorBlock || input.getBlock() instanceof BarbedWireBlock);
    @Nullable
    protected LivingEntity shooter;
    protected int shooterId;
    private float damage = 1.0f;
    private float headShot = 1.0f;
    private float monsterMultiplier = 0.0f;
    private float legShot = 0.5f;
    private boolean beast = false;
    private boolean zoom = false;
    private float bypassArmorRate = 0.0f;
    private float undeadMultiple = 1.0f;
    private int jhpLevel = 0;
    private int heLevel = 0;
    private int fireLevel = 0;
    private boolean dragonBreath = false;
    private float knockback = 0.05f;
    private boolean forceKnockback = false;
    private final ArrayList<MobEffectInstance> mobEffects = new ArrayList();
    private String gunItemId;

    public ProjectileEntity(EntityType<? extends ProjectileEntity> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
    }

    public ProjectileEntity(Level level) {
        super((EntityType)ModEntities.PROJECTILE.get(), level);
    }

    @Nullable
    protected EntityResult findEntityOnPath(Vec3 startVec, Vec3 endVec) {
        if (this.shooter == null) {
            return null;
        }
        Vec3 hitVec = null;
        Entity hitEntity = null;
        boolean headshot = false;
        boolean legShot = false;
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(this.beast ? 3.0 : 1.0), PROJECTILE_TARGETS);
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceToHit;
            Vec3 hitPos;
            EntityResult result;
            if (entity.equals((Object)this.shooter) || entity.equals((Object)this.shooter.getVehicle()) || entity instanceof TargetEntity && (Integer)entity.getEntityData().get(TargetEntity.DOWN_TIME) > 0 || entity instanceof DPSGeneratorEntity && (Integer)entity.getEntityData().get(DPSGeneratorEntity.DOWN_TIME) > 0 || (result = this.getHitResult(entity, startVec, endVec)) == null || (hitPos = result.getHitPos()) == null || !((distanceToHit = startVec.distanceTo(hitPos)) < closestDistance)) continue;
            hitVec = hitPos;
            hitEntity = entity;
            closestDistance = distanceToHit;
            headshot = result.isHeadshot();
            legShot = result.isLegShot();
        }
        return hitEntity != null ? new EntityResult(hitEntity, hitVec, headshot, legShot) : null;
    }

    @Nullable
    protected List<EntityResult> findEntitiesOnPath(Vec3 startVec, Vec3 endVec) {
        ArrayList<EntityResult> hitEntities = new ArrayList<EntityResult>();
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(this.beast ? 3.0 : 1.0), PROJECTILE_TARGETS);
        for (Entity entity : entities) {
            EntityResult result;
            if (this.shooter == null || entity == this.shooter || entity == this.shooter.getVehicle() || (result = this.getHitResult(entity, startVec, endVec)) == null || entity.getVehicle() != null && entity.getVehicle() == this.shooter.getVehicle()) continue;
            hitEntities.add(result);
        }
        return hitEntities;
    }

    @Nullable
    private EntityResult getHitResult(Entity entity, Vec3 startVec, Vec3 endVec) {
        Vec3 hitPos;
        double expandHeight = entity instanceof Player && !entity.isCrouching() ? 0.0625 : 0.0;
        AABB boundingBox = entity.getBoundingBox();
        Vec3 velocity = new Vec3(entity.getX() - entity.xOld, entity.getY() - entity.yOld, entity.getZ() - entity.zOld);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            LivingEntity livingEntity = this.shooter;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayerOwner = (ServerPlayer)livingEntity;
                int ping = Mth.floor((double)((double)serverPlayerOwner.connection.latency() / 1000.0 * 20.0 + 0.5));
                boundingBox = HitboxHelper.getBoundingBox((Player)player, ping);
                velocity = HitboxHelper.getVelocity((Player)player, ping);
            }
        }
        boundingBox = boundingBox.expandTowards(0.0, expandHeight, 0.0);
        boundingBox = boundingBox.expandTowards(velocity.x, velocity.y, velocity.z);
        double playerHitboxOffset = 3.0;
        if (entity instanceof ServerPlayer) {
            if (entity.getVehicle() != null) {
                boundingBox = boundingBox.move(velocity.multiply(playerHitboxOffset / 2.0, playerHitboxOffset / 2.0, playerHitboxOffset / 2.0));
            }
            boundingBox = boundingBox.move(velocity.multiply(playerHitboxOffset, playerHitboxOffset, playerHitboxOffset));
        }
        if (entity.getVehicle() != null) {
            boundingBox = boundingBox.move(velocity.multiply(-2.5, -2.5, -2.5));
        }
        boundingBox = boundingBox.move(velocity.multiply(-5.0, -5.0, -5.0));
        if (this.beast) {
            boundingBox = boundingBox.inflate(3.0);
        }
        if ((hitPos = (Vec3)boundingBox.clip(startVec, endVec).orElse(null)) == null) {
            return null;
        }
        Vec3 hitBoxPos = hitPos.subtract(entity.position());
        boolean headshot = false;
        boolean legShot = false;
        float eyeHeight = entity.getEyeHeight();
        float bodyHeight = entity.getBbHeight();
        if ((double)eyeHeight - 0.35 < hitBoxPos.y && hitBoxPos.y < (double)eyeHeight + 0.4 && entity instanceof LivingEntity) {
            headshot = true;
        }
        if (hitBoxPos.y < 0.33 * (double)bodyHeight && entity instanceof LivingEntity) {
            legShot = true;
        }
        return new EntityResult(entity, hitPos, headshot, legShot);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f)).define(COLOR_G, (Object)Float.valueOf(0.87058824f)).define(COLOR_B, (Object)Float.valueOf(0.15294118f));
    }

    public void tick() {
        Vec3 endVec;
        super.tick();
        this.updateHeading();
        Vec3 vec = this.getDeltaMovement();
        if (!this.level().isClientSide() && this.shooter != null) {
            Vec3 startVec = this.position();
            endVec = startVec.add(this.getDeltaMovement());
            Object result = ProjectileEntity.rayTraceBlocks(this.level(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), (Boolean)ProjectileConfig.ALLOW_PROJECTILE_DESTROY_GLASS.get() != false ? IGNORE_LIST : IGNORE_LIST.or(input -> input.is(Tags.Blocks.GLASS_PANES)));
            if (result.getType() != HitResult.Type.MISS) {
                endVec = result.getLocation();
            }
            ArrayList<EntityResult> entityResults = new ArrayList<EntityResult>();
            List<EntityResult> temp = this.findEntitiesOnPath(startVec, endVec);
            if (temp != null) {
                entityResults.addAll(temp);
            }
            entityResults.sort(Comparator.comparingDouble(e -> e.getHitPos().distanceTo(this.shooter.position())));
            for (EntityResult entityResult : entityResults) {
                DPSGeneratorEntity dpsGeneratorEntity;
                TargetEntity target;
                LivingEntity livingEntity;
                result = new ExtendedEntityRayTraceResult(entityResult);
                Entity entity = ((EntityHitResult)result).getEntity();
                if (entity instanceof Player) {
                    Player p;
                    Player player = (Player)entity;
                    livingEntity = this.shooter;
                    if (livingEntity instanceof Player && !(p = (Player)livingEntity).canHarmPlayer(player)) {
                        result = null;
                    }
                }
                if (result != null) {
                    this.onHit((HitResult)result);
                }
                if (this.beast) continue;
                this.bypassArmorRate -= 0.2f;
                if (!(this.bypassArmorRate < 0.8f) || result == null || (livingEntity = ((EntityHitResult)result).getEntity()) instanceof TargetEntity && (Integer)(target = (TargetEntity)livingEntity).getEntityData().get(TargetEntity.DOWN_TIME) > 0 || (livingEntity = ((EntityHitResult)result).getEntity()) instanceof DPSGeneratorEntity && (Integer)(dpsGeneratorEntity = (DPSGeneratorEntity)livingEntity).getEntityData().get(DPSGeneratorEntity.DOWN_TIME) > 0) continue;
                break;
            }
            if (entityResults.isEmpty()) {
                this.onHit((HitResult)result);
            }
            this.setPos(this.getX() + vec.x, this.getY() + vec.y, this.getZ() + vec.z);
        } else {
            this.setPosRaw(this.getX() + vec.x, this.getY() + vec.y, this.getZ() + vec.z);
        }
        this.setDeltaMovement(vec.x, vec.y - 0.02, vec.z);
        if (this.tickCount > (this.fireLevel > 0 ? 10 : 40)) {
            this.discard();
        }
        if (this.fireLevel > 0 && this.dragonBreath && (endVec = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)endVec;
            double randomPos = (double)this.tickCount * 0.08 * (Math.random() - 0.5);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.FLAME, (this.xo + this.getX()) / 2.0 + randomPos, (this.yo + this.getY()) / 2.0 + randomPos, (this.zo + this.getZ()) / 2.0 + randomPos, 0, this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z, Math.max(this.getDeltaMovement().length() - 1.1 * (double)this.tickCount, 0.2), true);
        }
        this.syncMotion();
    }

    @Override
    public void syncMotion() {
        if (!this.level().isClientSide) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ClientMotionSyncMessage((Entity)this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.damage = tag.getFloat("Damage");
        this.headShot = tag.getFloat("HeadShot");
        this.monsterMultiplier = tag.getFloat("MonsterMultiplier");
        this.legShot = tag.getFloat("LegShot");
        this.bypassArmorRate = tag.getFloat("BypassArmorRate");
        this.undeadMultiple = tag.getFloat("UndeadMultiple");
        this.knockback = tag.getFloat("Knockback");
        this.beast = tag.getBoolean("Beast");
        this.forceKnockback = tag.getBoolean("ForceKnockback");
        if (tag.contains("GunId")) {
            this.gunItemId = tag.getString("GunId");
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putFloat("Damage", this.damage);
        tag.putFloat("HeadShot", this.headShot);
        tag.putFloat("MonsterMultiplier", this.monsterMultiplier);
        tag.putFloat("LegShot", this.legShot);
        tag.putFloat("BypassArmorRate", this.bypassArmorRate);
        tag.putFloat("UndeadMultiple", this.undeadMultiple);
        tag.putFloat("Knockback", this.knockback);
        tag.putBoolean("Beast", this.beast);
        tag.putBoolean("ForceKnockback", this.forceKnockback);
        if (this.gunItemId != null) {
            tag.putString("GunId", this.gunItemId);
        }
    }

    protected void onHit(@NotNull HitResult result) {
        if (result instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)result;
            if (blockHitResult.getType() == HitResult.Type.MISS) {
                return;
            }
            BlockPos resultPos = blockHitResult.getBlockPos();
            BlockState state = this.level().getBlockState(resultPos);
            SoundEvent event = state.getBlock().getSoundType(state, (LevelReader)this.level(), resultPos, (Entity)this).getBreakSound();
            this.level().playSound(null, result.getLocation().x, result.getLocation().y, result.getLocation().z, event, SoundSource.AMBIENT, 1.0f, 1.0f);
            Vec3 hitVec = result.getLocation();
            Block block = state.getBlock();
            if (block instanceof BellBlock) {
                BellBlock bell = (BellBlock)block;
                bell.attemptToRing(this.level(), resultPos, blockHitResult.getDirection());
            }
            if (((Boolean)ProjectileConfig.ALLOW_PROJECTILE_DESTROY_GLASS.get()).booleanValue() && (state.is(Tags.Blocks.GLASS_BLOCKS) || state.is(Tags.Blocks.GLASS_PANES))) {
                this.level().destroyBlock(resultPos, false, (Entity)this.getShooter());
            }
            if (state.getBlock() instanceof TargetBlock) {
                if (this.shooter == null) {
                    return;
                }
                int rings = ProjectileEntity.getRings(blockHitResult, hitVec);
                double dis = this.shooter.position().distanceTo(hitVec);
                this.recordHitScore(rings, dis);
            }
            this.onHitBlock(hitVec);
            if (this.heLevel > 0) {
                this.explosionBulletBlock((Entity)this, this.damage, this.heLevel, this.monsterMultiplier + 1.0f, hitVec);
            }
            if (this.fireLevel > 0 && (block = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)block;
                ParticleTool.sendParticle(serverLevel, ParticleTypes.LAVA, hitVec.x, hitVec.y, hitVec.z, 3, 0.0, 0.0, 0.0, 0.5, true);
            }
        }
        if (result instanceof ExtendedEntityRayTraceResult) {
            Player player;
            ExtendedEntityRayTraceResult entityHitResult = (ExtendedEntityRayTraceResult)result;
            Entity entity = entityHitResult.getEntity();
            if (entity.getId() == this.shooterId) {
                return;
            }
            LivingEntity livingEntity = this.shooter;
            if (livingEntity instanceof Player && entity.hasIndirectPassenger((Entity)(player = (Player)livingEntity))) {
                return;
            }
            this.onHitEntity(entity, entityHitResult.isHeadshot(), entityHitResult.isLegShot());
            entity.invulnerableTime = 0;
        }
    }

    private static int getRings(@NotNull BlockHitResult blockHitResult, @NotNull Vec3 hitVec) {
        Direction direction = blockHitResult.getDirection();
        double x = Math.abs(Mth.frac((double)hitVec.x) - 0.5);
        double y = Math.abs(Mth.frac((double)hitVec.y) - 0.5);
        double z = Math.abs(Mth.frac((double)hitVec.z) - 0.5);
        Direction.Axis axis = direction.getAxis();
        double v = axis == Direction.Axis.Y ? Math.max(x, z) : (axis == Direction.Axis.Z ? Math.max(x, y) : Math.max(y, z));
        return Math.max(1, Mth.ceil((double)(10.0 * Mth.clamp((double)((0.5 - v) / 0.5), (double)0.0, (double)1.0))));
    }

    private void recordHitScore(int score, double distance) {
        ItemStack stack;
        LivingEntity livingEntity;
        LivingEntity livingEntity2 = this.shooter;
        if (!(livingEntity2 instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity2;
        player.displayClientMessage((Component)Component.literal((String)String.valueOf(score)).append((Component)Component.translatable((String)"tips.superbwarfare.shoot.rings")).append((Component)Component.literal((String)(" " + FormatTool.format1D(distance, "m")))), false);
        if (!this.shooter.level().isClientSide() && (livingEntity = this.shooter) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            Holder holder = score == 10 ? Holder.direct((Object)((SoundEvent)ModSounds.HEADSHOT.get())) : Holder.direct((Object)((SoundEvent)ModSounds.INDICATION.get()));
            serverPlayer.connection.send((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, player.level().random.nextLong()));
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientIndicatorMessage(score == 10 ? 1 : 0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if ((stack = player.getOffhandItem()).is((Item)ModItems.TRANSCRIPT.get())) {
            int size = 10;
            List scores = (List)stack.get(ModDataComponents.TRANSCRIPT_SCORE);
            if (scores == null) {
                scores = List.of();
            }
            ArrayDeque<Pair> queue = new ArrayDeque<Pair>(scores);
            queue.offer(new Pair((Object)score, (Object)distance));
            while (queue.size() > 10) {
                queue.poll();
            }
            stack.set(ModDataComponents.TRANSCRIPT_SCORE, List.copyOf(queue));
        }
    }

    protected void onHitBlock(Vec3 location) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.beast) {
                ParticleTool.sendParticle(serverLevel, ParticleTypes.END_ROD, location.x, location.y, location.z, 15, 0.1, 0.1, 0.1, 0.05, true);
            } else {
                ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.BULLET_HOLE.get(), location.x, location.y, location.z, 1, 0.0, 0.0, 0.0, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.SMOKE, location.x, location.y, location.z, 3, 0.0, 0.1, 0.0, 0.01, true);
                this.discard();
            }
            serverLevel.playSound(null, new BlockPos((int)location.x, (int)location.y, (int)location.z), (SoundEvent)ModSounds.LAND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    protected void onHitEntity(Entity entity, boolean headshot, boolean legShot) {
        LivingEntity living;
        if (this.shooter == null) {
            return;
        }
        float mMultiple = 1.0f + this.monsterMultiplier;
        if (entity == null) {
            return;
        }
        if (entity instanceof PartEntity) {
            PartEntity part = (PartEntity)entity;
            entity = part.getParent();
        }
        if (entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            living.level().playSound(null, living.getOnPos(), (SoundEvent)ModSounds.MELEE_HIT.get(), SoundSource.PLAYERS, 1.0f, (float)((2.0 * org.joml.Math.random() - 1.0) * (double)0.1f + 1.0));
        }
        if (this.beast && entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            Beast.beastKill((Entity)this.shooter, (Entity)living);
            return;
        }
        if (entity instanceof Monster) {
            this.damage *= mMultiple;
        }
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getType().is(EntityTypeTags.UNDEAD)) {
            this.damage *= this.undeadMultiple;
        }
        if (entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            if (this.jhpLevel > 0) {
                this.damage *= (1.0f + 0.12f * (float)this.jhpLevel) * ((float)(10.0 / (living.getAttributeValue(Attributes.ARMOR) + 10.0)) + 0.25f);
            }
        }
        if (this.heLevel > 0) {
            this.explosionBulletEntity((Entity)this, entity, this.damage, this.heLevel, mMultiple);
        }
        if (this.fireLevel > 0 && !entity.level().isClientSide() && entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(ModMobEffects.BURN, 60 + this.fireLevel * 20, this.fireLevel, false, false), (Entity)this.shooter);
        }
        if (headshot) {
            Object object;
            if (!this.shooter.level().isClientSide() && (object = this.shooter) instanceof ServerPlayer) {
                player = (ServerPlayer)object;
                holder = Holder.direct((Object)((SoundEvent)ModSounds.HEADSHOT.get()));
                player.connection.send((Packet)new ClientboundSoundPacket((Holder)holder, SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, player.level().random.nextLong()));
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(1, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.performOnHit(entity, this.damage, true, this.knockback);
        } else {
            if (!this.shooter.level().isClientSide() && (holder = this.shooter) instanceof ServerPlayer) {
                player = (ServerPlayer)holder;
                holder = Holder.direct((Object)((SoundEvent)ModSounds.INDICATION.get()));
                player.connection.send((Packet)new ClientboundSoundPacket((Holder)holder, SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, player.level().random.nextLong()));
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (legShot) {
                if (entity instanceof LivingEntity) {
                    Player player;
                    living = (LivingEntity)entity;
                    if (living instanceof Player && (player = (Player)living).isCreative()) {
                        return;
                    }
                    if (!living.level().isClientSide()) {
                        living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 2, false, false));
                    }
                }
                this.damage *= this.legShot;
            }
            this.performOnHit(entity, this.damage, false, this.knockback);
        }
        if (!this.mobEffects.isEmpty() && entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            for (MobEffectInstance instance : this.mobEffects) {
                living.addEffect(instance, (Entity)this.shooter);
            }
        }
        this.discard();
    }

    public void performOnHit(Entity entity, float damage, boolean headshot, double knockback) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.forceKnockback) {
                Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize();
                living.addDeltaMovement(vec3.scale(knockback));
                this.performDamage(entity, damage, headshot);
            } else {
                ICustomKnockback iCustomKnockback = ICustomKnockback.getInstance(living);
                iCustomKnockback.superbWarfare$setKnockbackStrength(knockback);
                this.performDamage(entity, damage, headshot);
                iCustomKnockback.superbWarfare$resetKnockbackStrength();
            }
        } else {
            this.performDamage(entity, damage, headshot);
        }
    }

    protected void explosionBulletBlock(Entity projectile, float damage, int heLevel, float monsterMultiple, Vec3 hitVec) {
        CustomExplosion explosion = new CustomExplosion(projectile.level(), projectile, ModDamageTypes.causeProjectileBoomDamage(projectile.level().registryAccess(), projectile, (Entity)this.getShooter()), (float)(0.9 * (double)damage * (1.0 + 0.1 * (double)heLevel)), hitVec.x, hitVec.y, hitVec.z, (float)((1.5 + 0.02 * (double)damage) * (1.0 + 0.05 * (double)heLevel))).setDamageMultiplier(monsterMultiple).bulletExplode();
        explosion.explode();
        EventHooks.onExplosionStart((Level)projectile.level(), (Explosion)explosion);
        explosion.finalizeExplosion(false);
        ParticleTool.spawnMiniExplosionParticles(this.level(), hitVec);
    }

    protected void explosionBulletEntity(Entity projectile, Entity target, float damage, int heLevel, float monsterMultiple) {
        CustomExplosion explosion = new CustomExplosion(projectile.level(), projectile, ModDamageTypes.causeProjectileBoomDamage(projectile.level().registryAccess(), projectile, (Entity)this.getShooter()), (float)(0.8 * (double)damage * (1.0 + 0.1 * (double)heLevel)), target.getX(), target.getY(), target.getZ(), (float)((1.5 + 0.02 * (double)damage) * (1.0 + 0.05 * (double)heLevel))).setDamageMultiplier(monsterMultiple).bulletExplode();
        explosion.explode();
        EventHooks.onExplosionStart((Level)projectile.level(), (Explosion)explosion);
        explosion.finalizeExplosion(false);
        ParticleTool.spawnMiniExplosionParticles(target.level(), target.position());
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    public void shoot(Player player, double vecX, double vecY, double vecZ, float velocity, float spread) {
        Vec3 vec3 = new Vec3(vecX, vecY, vecZ).normalize().add(this.random.triangle(0.0, 0.0172275 * (double)spread), this.random.triangle(0.0, 0.0172275 * (double)spread), this.random.triangle(0.0, 0.0172275 * (double)spread)).scale((double)velocity);
        this.setDeltaMovement(vec3);
        double d0 = vec3.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    private static BlockHitResult rayTraceBlocks(Level world, ClipContext context, Predicate<BlockState> ignorePredicate) {
        return ProjectileEntity.performRayTrace(context, (rayTraceContext, blockPos) -> {
            BlockState blockState = world.getBlockState(blockPos);
            if (ignorePredicate.test(blockState)) {
                return null;
            }
            FluidState fluidState = world.getFluidState(blockPos);
            Vec3 startVec = rayTraceContext.getFrom();
            Vec3 endVec = rayTraceContext.getTo();
            VoxelShape blockShape = rayTraceContext.getBlockShape(blockState, (BlockGetter)world, blockPos);
            BlockHitResult blockResult = world.clipWithInteractionOverride(startVec, endVec, blockPos, blockShape, blockState);
            VoxelShape fluidShape = rayTraceContext.getFluidShape(fluidState, (BlockGetter)world, blockPos);
            BlockHitResult fluidResult = fluidShape.clip(startVec, endVec, blockPos);
            double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.getFrom().distanceToSqr(blockResult.getLocation());
            double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.getFrom().distanceToSqr(fluidResult.getLocation());
            return blockDistance <= fluidDistance ? blockResult : fluidResult;
        }, rayTraceContext -> {
            Vec3 Vector3d = rayTraceContext.getFrom().subtract(rayTraceContext.getTo());
            return BlockHitResult.miss((Vec3)rayTraceContext.getTo(), (Direction)Direction.getNearest((double)Vector3d.x, (double)Vector3d.y, (double)Vector3d.z), (BlockPos)BlockPos.containing((Position)rayTraceContext.getTo()));
        });
    }

    private static <T> T performRayTrace(ClipContext context, BiFunction<ClipContext, BlockPos, T> hitFunction, Function<ClipContext, T> p_217300_2_) {
        Vec3 endVec;
        Vec3 startVec = context.getFrom();
        if (!startVec.equals((Object)(endVec = context.getTo()))) {
            int blockZ;
            int blockY;
            double startX = Mth.lerp((double)-1.0E-7, (double)endVec.x, (double)startVec.x);
            double startY = Mth.lerp((double)-1.0E-7, (double)endVec.y, (double)startVec.y);
            double startZ = Mth.lerp((double)-1.0E-7, (double)endVec.z, (double)startVec.z);
            double endX = Mth.lerp((double)-1.0E-7, (double)startVec.x, (double)endVec.x);
            double endY = Mth.lerp((double)-1.0E-7, (double)startVec.y, (double)endVec.y);
            double endZ = Mth.lerp((double)-1.0E-7, (double)startVec.z, (double)endVec.z);
            int blockX = Mth.floor((double)endX);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(blockX, blockY = Mth.floor((double)endY), blockZ = Mth.floor((double)endZ));
            T t = hitFunction.apply(context, (BlockPos)mutablePos);
            if (t != null) {
                return t;
            }
            double deltaX = startX - endX;
            double deltaY = startY - endY;
            double deltaZ = startZ - endZ;
            int signX = Mth.sign((double)deltaX);
            int signY = Mth.sign((double)deltaY);
            int signZ = Mth.sign((double)deltaZ);
            double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / deltaX;
            double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / deltaY;
            double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / deltaZ;
            double d12 = d9 * (signX > 0 ? 1.0 - Mth.frac((double)endX) : Mth.frac((double)endX));
            double d13 = d10 * (signY > 0 ? 1.0 - Mth.frac((double)endY) : Mth.frac((double)endY));
            double d14 = d11 * (signZ > 0 ? 1.0 - Mth.frac((double)endZ) : Mth.frac((double)endZ));
            while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
                T t1;
                if (d12 < d13) {
                    if (d12 < d14) {
                        blockX += signX;
                        d12 += d9;
                    } else {
                        blockZ += signZ;
                        d14 += d11;
                    }
                } else if (d13 < d14) {
                    blockY += signY;
                    d13 += d10;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }
                if ((t1 = hitFunction.apply(context, (BlockPos)mutablePos.set(blockX, blockY, blockZ))) == null) continue;
                return t1;
            }
        }
        return p_217300_2_.apply(context);
    }

    @Nullable
    public LivingEntity getShooter() {
        return this.shooter;
    }

    public int getShooterId() {
        return this.shooterId;
    }

    public float getBypassArmorRate() {
        return this.bypassArmorRate;
    }

    public void updateHeading() {
        double horizontalDistance = this.getDeltaMovement().horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)this.getDeltaMovement().x(), (double)this.getDeltaMovement().z()) * 57.29577951308232));
        this.setXRot((float)(Mth.atan2((double)this.getDeltaMovement().y(), (double)horizontalDistance) * 57.29577951308232));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    private void performDamage(Entity entity, float damage, boolean isHeadshot) {
        float headShotModifier;
        float rate = Mth.clamp((float)this.bypassArmorRate, (float)0.0f, (float)1.0f);
        float normalDamage = damage * Mth.clamp((float)(1.0f - rate), (float)0.0f, (float)1.0f);
        float absoluteDamage = damage * Mth.clamp((float)rate, (float)0.0f, (float)1.0f);
        entity.invulnerableTime = 0;
        float f = headShotModifier = isHeadshot ? this.headShot : 1.0f;
        if (normalDamage > 0.0f) {
            entity.hurt(isHeadshot ? ModDamageTypes.causeGunFireHeadshotDamage(this.level().registryAccess(), (Entity)this, (Entity)this.shooter) : ModDamageTypes.causeGunFireDamage(this.level().registryAccess(), (Entity)this, (Entity)this.shooter), normalDamage * headShotModifier);
            entity.invulnerableTime = 0;
        }
        if (absoluteDamage > 0.0f) {
            entity.hurt(isHeadshot ? ModDamageTypes.causeGunFireHeadshotAbsoluteDamage(this.level().registryAccess(), (Entity)this, (Entity)this.shooter) : ModDamageTypes.causeGunFireAbsoluteDamage(this.level().registryAccess(), (Entity)this, (Entity)this.shooter), absoluteDamage * headShotModifier);
            entity.invulnerableTime = 0;
            if (entity instanceof VehicleEntity) {
                VehicleEntity vehicle = (VehicleEntity)entity;
                if (this.bypassArmorRate > 1.0f) {
                    vehicle.hurt(ModDamageTypes.causeGunFireAbsoluteDamage(this.level().registryAccess(), (Entity)this, (Entity)this.shooter), absoluteDamage * (this.bypassArmorRate - 1.0f) * 0.5f);
                }
            }
        }
    }

    public void readSpawnData(@NotNull RegistryFriendlyByteBuf additionalData) {
    }

    public void writeSpawnData(@NotNull RegistryFriendlyByteBuf buffer) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isZoom() {
        return this.zoom;
    }

    @Nullable
    public String getGunItemId() {
        return this.gunItemId;
    }

    public ProjectileEntity shooter(LivingEntity shooter) {
        this.shooter = shooter;
        return this;
    }

    public ProjectileEntity damage(float damage) {
        this.damage = damage;
        return this;
    }

    public ProjectileEntity headShot(float headShot) {
        this.headShot = headShot;
        return this;
    }

    public ProjectileEntity setMonsterMultiplier(float monsterMultiplier) {
        this.monsterMultiplier = monsterMultiplier;
        return this;
    }

    public ProjectileEntity legShot(float legShot) {
        this.legShot = legShot;
        return this;
    }

    public ProjectileEntity beast() {
        this.beast = true;
        return this;
    }

    public ProjectileEntity jhpBullet(int jhpLevel) {
        this.jhpLevel = jhpLevel;
        return this;
    }

    public ProjectileEntity heBullet(int heLevel) {
        this.heLevel = heLevel;
        return this;
    }

    public ProjectileEntity fireBullet(int fireLevel, boolean dragonBreath) {
        this.fireLevel = fireLevel;
        this.dragonBreath = dragonBreath;
        return this;
    }

    public ProjectileEntity zoom(boolean zoom) {
        this.zoom = zoom;
        return this;
    }

    public ProjectileEntity bypassArmorRate(float bypassArmorRate) {
        this.bypassArmorRate = bypassArmorRate;
        return this;
    }

    public ProjectileEntity undeadMultiple(float undeadMultiple) {
        this.undeadMultiple = undeadMultiple;
        return this;
    }

    public ProjectileEntity effect(ArrayList<MobEffectInstance> mobEffectInstances) {
        this.mobEffects.addAll(mobEffectInstances);
        return this;
    }

    public void setRGB(float[] rgb) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(rgb[0]));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(rgb[1]));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(rgb[2]));
    }

    public ProjectileEntity knockback(float knockback) {
        this.knockback = knockback;
        return this;
    }

    public ProjectileEntity forceKnockback() {
        this.forceKnockback = true;
        return this;
    }

    public ProjectileEntity setGunItemId(ItemStack stack) {
        this.gunItemId = stack.getDescriptionId();
        return this;
    }

    public ProjectileEntity setGunItemId(String id) {
        this.gunItemId = id;
        return this;
    }

    public static class EntityResult {
        private final Entity entity;
        private final Vec3 hitVec;
        private final boolean headshot;
        private final boolean legShot;

        public EntityResult(Entity entity, Vec3 hitVec, boolean headshot, boolean legShot) {
            this.entity = entity;
            this.hitVec = hitVec;
            this.headshot = headshot;
            this.legShot = legShot;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public Vec3 getHitPos() {
            return this.hitVec;
        }

        public boolean isHeadshot() {
            return this.headshot;
        }

        public boolean isLegShot() {
            return this.legShot;
        }
    }
}

