/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.DecoyEntity;
import com.atsuishio.superbwarfare.entity.projectile.DestroyableProjectileEntity;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SwarmDroneEntity
extends FastThrowableProjectile
implements GeoEntity,
DestroyableProjectileEntity,
ExplosiveProjectile {
    public static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.defineId(SwarmDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Float> TARGET_X = SynchedEntityData.defineId(SwarmDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> TARGET_Y = SynchedEntityData.defineId(SwarmDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> TARGET_Z = SynchedEntityData.defineId(SwarmDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.defineId(SwarmDroneEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean distracted = false;
    private float explosionDamage = 80.0f;
    private float explosionRadius = 5.0f;
    private float randomFloat;
    private int guideType = 0;

    public SwarmDroneEntity(EntityType<? extends SwarmDroneEntity> type, Level level) {
        super(type, level);
        this.noCulling = true;
    }

    public SwarmDroneEntity(double x, double y, double z, Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.SWARM_DRONE.get()), x, y, z, level);
    }

    public SwarmDroneEntity(LivingEntity entity, Level level, float explosionDamage, float explosionRadius) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.SWARM_DRONE.get()), entity, level);
        this.explosionDamage = explosionDamage;
        this.explosionRadius = explosionRadius;
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.DRONE.get();
    }

    public void setTargetUuid(String uuid) {
        this.entityData.set(TARGET_UUID, (Object)uuid);
    }

    public void setGuideType(int guideType) {
        this.guideType = guideType;
    }

    public void setTargetVec(Vec3 targetPos) {
        this.entityData.set(TARGET_X, (Object)Float.valueOf((float)targetPos.x));
        this.entityData.set(TARGET_Y, (Object)Float.valueOf((float)targetPos.y));
        this.entityData.set(TARGET_Z, (Object)Float.valueOf((float)targetPos.z));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getDirectEntity() instanceof ThrownPotion || source.getDirectEntity() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        if (source.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (source.is(DamageTypes.DROWN)) {
            return false;
        }
        if (source.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        if (source.getDirectEntity() instanceof SwarmDroneEntity) {
            return false;
        }
        this.entityData.set(HEALTH, (Object)Float.valueOf(((Float)this.entityData.get(HEALTH)).floatValue() - amount));
        return super.hurt(source, amount);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TARGET_UUID, (Object)"none").define(HEALTH, (Object)Float.valueOf(10.0f)).define(TARGET_X, (Object)Float.valueOf(0.0f)).define(TARGET_Y, (Object)Float.valueOf(0.0f)).define(TARGET_Z, (Object)Float.valueOf(0.0f));
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Health")) {
            this.entityData.set(HEALTH, (Object)Float.valueOf(compound.getFloat("Health")));
        }
        if (compound.contains("TargetUUID")) {
            this.entityData.set(TARGET_UUID, (Object)compound.getString("TargetUUID"));
        }
        if (compound.contains("TargetX")) {
            this.entityData.set(TARGET_X, (Object)Float.valueOf(compound.getFloat("TargetX")));
        }
        if (compound.contains("TargetY")) {
            this.entityData.set(TARGET_X, (Object)Float.valueOf(compound.getFloat("TargetY")));
        }
        if (compound.contains("TargetZ")) {
            this.entityData.set(TARGET_X, (Object)Float.valueOf(compound.getFloat("TargetZ")));
        }
        if (compound.contains("ExplosionDamage")) {
            this.explosionDamage = compound.getFloat("ExplosionDamage");
        }
        if (compound.contains("Radius")) {
            this.explosionRadius = compound.getFloat("Radius");
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("Health", ((Float)this.entityData.get(HEALTH)).floatValue());
        compound.putString("TargetUUID", (String)this.entityData.get(TARGET_UUID));
        compound.putFloat("TargetX", ((Float)this.entityData.get(TARGET_X)).floatValue());
        compound.putFloat("TargetY", ((Float)this.entityData.get(TARGET_Y)).floatValue());
        compound.putFloat("TargetZ", ((Float)this.entityData.get(TARGET_Z)).floatValue());
        compound.putFloat("ExplosionDamage", this.explosionDamage);
        compound.putFloat("Radius", this.explosionRadius);
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        return true;
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        LivingEntity living;
        if (result.getEntity() instanceof SwarmDroneEntity) {
            return;
        }
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity && !(living = (LivingEntity)entity).level().isClientSide() && living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            living.level().playSound(null, living.blockPosition(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (this.level() instanceof ServerLevel) {
            this.causeMissileExplode(ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.explosionDamage, this.explosionRadius);
        }
    }

    public void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (this.level() instanceof ServerLevel) {
            this.causeMissileExplode(ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.explosionDamage, this.explosionRadius);
        }
    }

    @Override
    public void tick() {
        Entity e2;
        super.tick();
        Entity entity = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(TARGET_UUID));
        List<Entity> decoy = SeekTool.seekLivingEntities((Entity)this, this.level(), 32.0, 90.0);
        for (Entity e2 : decoy) {
            if (!(e2 instanceof DecoyEntity)) continue;
            DecoyEntity decoyEntity = (DecoyEntity)e2;
            if (this.distracted) continue;
            this.entityData.set(TARGET_UUID, (Object)decoyEntity.getDecoyUUID());
            this.distracted = true;
        }
        if (this.tickCount == 1 && !this.level().isClientSide() && (e2 = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)e2;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.CLOUD, this.xo, this.yo, this.zo, 15, 0.8, 0.8, 0.8, 0.01, true);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE, this.xo, this.yo, this.zo, 10, 0.8, 0.8, 0.8, 0.01, true);
        }
        if (this.tickCount > 10 && this.getOwner() != null) {
            Vec3 targetPos;
            Entity shooter = this.getOwner();
            if (this.guideType == 0 && entity != null) {
                targetPos = entity.getEyePosition();
                this.entityData.set(TARGET_X, (Object)Float.valueOf((float)targetPos.x));
                this.entityData.set(TARGET_Y, (Object)Float.valueOf((float)targetPos.y));
                this.entityData.set(TARGET_Z, (Object)Float.valueOf((float)targetPos.z));
            } else {
                targetPos = new Vec3((double)((Float)this.entityData.get(TARGET_X)).floatValue(), (double)((Float)this.entityData.get(TARGET_Y)).floatValue(), (double)((Float)this.entityData.get(TARGET_Z)).floatValue());
            }
            if (this.tickCount % 5 == 0) {
                this.randomFloat = this.random.nextFloat();
            }
            double dis = this.position().distanceTo(targetPos);
            double disShooter = shooter.position().distanceTo(targetPos);
            double randomPos = (double)(Mth.sin((float)(0.25f * ((float)this.tickCount + this.randomFloat))) * this.randomFloat) * Mth.clamp((double)Mth.sin((float)((float)(3.1415927410125732 * (dis / disShooter)))), (double)0.0, (double)0.8);
            Vec3 toVec = this.position().vectorTo(targetPos).normalize().add(new Vec3(randomPos, 0.1 * randomPos, randomPos));
            this.setDeltaMovement(this.getDeltaMovement().add(toVec.scale(0.5)));
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.85, 0.85, 0.85));
            if (dis < 0.5) {
                if (this.level() instanceof ServerLevel) {
                    this.causeMissileExplode(ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.explosionDamage, this.explosionRadius);
                }
                this.discard();
            }
        }
        if (this.tickCount > 300 || this.isInWater() || ((Float)this.entityData.get(HEALTH)).floatValue() <= 0.0f) {
            if (this.level() instanceof ServerLevel) {
                this.causeMissileExplode(ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.explosionDamage, this.explosionRadius);
            }
            this.discard();
        }
    }

    protected void updateRotation() {
    }

    public void causeMissileExplode(@Nullable DamageSource source, float damage, float radius) {
        CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, source, damage, this.getX(), this.getY(), this.getZ(), radius, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.25f);
        explosion.explode();
        EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
        explosion.finalizeExplosion(false);
        ParticleTool.spawnMediumExplosionParticles(this.level(), this.position());
        this.discard();
    }

    private PlayState movementPredicate(AnimationState<SwarmDroneEntity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.sd.fly"));
    }

    protected double getDefaultGravity() {
        return this.tickCount > 10 ? 0.0 : (double)0.1f;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean shouldSyncMotion() {
        return true;
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.DRONE_SOUND.get();
    }

    @Override
    public float getVolume() {
        return 0.07f;
    }

    @Override
    public void setDamage(float damage) {
    }

    @Override
    public void setExplosionDamage(float explosionDamage) {
        this.explosionDamage = explosionDamage;
    }

    @Override
    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }
}

