/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.projectile.AerialBombEntity;
import com.atsuishio.superbwarfare.entity.projectile.HeliRocketEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.HelicopterEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.HeliRocketWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SmallCannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.CameraTool;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Ah6Entity
extends ContainerMobileVehicleEntity
implements GeoEntity,
HelicopterEntity,
WeaponVehicleEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Float> PROPELLER_ROT = SynchedEntityData.defineId(Ah6Entity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Integer> LOADED_ROCKET = SynchedEntityData.defineId(Ah6Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public boolean engineStart;
    public boolean engineStartOver;
    public double velocity;
    public int fireIndex;
    public int holdTick;
    public int holdPowerTick;
    public float destroyRot;
    public float delta_xo;
    public float delta_yo;
    public float delta_x;
    public float delta_y;

    public Ah6Entity(EntityType<Ah6Entity> type, Level world) {
        super(type, world);
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new SmallCannonShellWeapon().blockInteraction((Boolean)VehicleConfig.AH_6_CANNON_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP).damage(((Integer)VehicleConfig.AH_6_CANNON_DAMAGE.get()).intValue()).explosionDamage(((Integer)VehicleConfig.AH_6_CANNON_EXPLOSION_DAMAGE.get()).floatValue()).explosionRadius(((Double)VehicleConfig.AH_6_CANNON_EXPLOSION_RADIUS.get()).floatValue()).sound((SoundEvent)ModSounds.INTO_CANNON.get()).icon(Mod.loc("textures/screens/vehicle_weapon/cannon_20mm.png")).sound1p((SoundEvent)ModSounds.HELICOPTER_CANNON_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.HELICOPTER_CANNON_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.HELICOPTER_CANNON_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.HELICOPTER_CANNON_VERYFAR.get()), new HeliRocketWeapon().damage(((Integer)VehicleConfig.AH_6_ROCKET_DAMAGE.get()).intValue()).explosionDamage(((Integer)VehicleConfig.AH_6_ROCKET_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Integer)VehicleConfig.AH_6_ROCKET_EXPLOSION_RADIUS.get()).intValue()).sound((SoundEvent)ModSounds.INTO_MISSILE.get()).sound1p((SoundEvent)ModSounds.HELICOPTER_ROCKET_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.HELICOPTER_ROCKET_FIRE_3P.get())}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(7.0, 1.0, -2.7);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LOADED_ROCKET, (Object)0).define(PROPELLER_ROT, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("LoadedRocket", ((Integer)this.entityData.get(LOADED_ROCKET)).intValue());
        compound.putFloat("PropellerRot", ((Float)this.entityData.get(PROPELLER_ROT)).floatValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(LOADED_ROCKET, (Object)compound.getInt("LoadedRocket"));
        this.entityData.set(PROPELLER_ROT, (Object)Float.valueOf(compound.getFloat("PropellerRot")));
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> {
            if (source.getDirectEntity() instanceof AerialBombEntity) {
                damage = Float.valueOf(damage.floatValue() * 2.0f);
            }
            damage = Float.valueOf(damage.floatValue() * (this.getHealth() > 0.1f ? 0.7f : 0.05f));
            return damage;
        });
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() == ModItems.ROCKET_70.get() && (Integer)this.entityData.get(LOADED_ROCKET) < 14) {
            this.entityData.set(LOADED_ROCKET, (Object)((Integer)this.entityData.get(LOADED_ROCKET) + 1));
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.MISSILE_RELOAD.get(), this.getSoundSource(), 2.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.interact(player, hand);
    }

    @Override
    public void baseTick() {
        this.delta_xo = this.delta_x;
        this.delta_yo = this.delta_y;
        super.baseTick();
        if (this.level() instanceof ServerLevel) {
            if (this.reloadCoolDown > 0) {
                --this.reloadCoolDown;
            }
            this.handleAmmo();
        }
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.8, 1.0, 0.8));
        } else {
            this.setZRot(this.getRoll() * (this.backInputDown ? 0.9f : 0.99f));
            float f = (float)Mth.clamp((double)((double)0.95f - 0.015 * this.getDeltaMovement().length() + (double)(0.02f * Mth.abs((float)(90.0f - (float)Ah6Entity.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f)))) / 90.0f)), (double)0.01, (double)0.99);
            this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).scale((this.getXRot() < 0.0f ? -0.035 : (this.getXRot() > 0.0f ? 0.035 : 0.0)) * this.getDeltaMovement().length())));
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.95, (double)f));
        }
        if (this.isInWater() && this.tickCount % 4 == 0 && this.getSubmergedHeight(this) > 0.5 * (double)this.getBbHeight()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 0.6, 0.6));
            this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, this.getFirstPassenger() == null ? this : this.getFirstPassenger()), 6.0f + (float)(20.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
        }
        this.releaseDecoy();
        this.lowHealthWarning();
        this.terrainCompact(2.7f, 2.7f);
        this.refreshDimensions();
    }

    private void handleAmmo() {
        Entity entity = this.getFirstPassenger();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int ammoCount = this.getItemStacks().stream().filter(stack -> {
            if (stack.is((Item)ModItems.AMMO_BOX.get())) {
                return Ammo.HEAVY.get((ItemStack)stack) > 0;
            }
            return false;
        }).mapToInt(Ammo.HEAVY::get).sum() + this.countItem((Item)ModItems.SMALL_SHELL.get());
        if ((this.hasItem((Item)ModItems.ROCKET_70.get()) || InventoryTool.hasCreativeAmmoBox(player)) && this.reloadCoolDown == 0 && (Integer)this.getEntityData().get(LOADED_ROCKET) < 14) {
            this.entityData.set(LOADED_ROCKET, (Object)((Integer)this.getEntityData().get(LOADED_ROCKET) + 1));
            this.reloadCoolDown = 25;
            if (!InventoryTool.hasCreativeAmmoBox(player)) {
                this.getItemStacks().stream().filter(stack -> stack.is((Item)ModItems.ROCKET_70.get())).findFirst().ifPresent(stack -> stack.shrink(1));
            }
            this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.MISSILE_RELOAD.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
        if (this.getWeaponIndex(0) == 0) {
            this.entityData.set(AMMO, (Object)ammoCount);
        } else {
            this.entityData.set(AMMO, (Object)((Integer)this.getEntityData().get(LOADED_ROCKET)));
        }
    }

    @Override
    public void travel() {
        Entity passenger = this.getFirstPassenger();
        Entity passenger2 = this.getNthEntity(1);
        Entity passenger3 = this.getNthEntity(2);
        Entity passenger4 = this.getNthEntity(3);
        if (this.getHealth() > 0.1f * this.getMaxHealth()) {
            if (passenger == null) {
                this.leftInputDown = false;
                this.rightInputDown = false;
                this.forwardInputDown = false;
                this.backInputDown = false;
                this.upInputDown = false;
                this.downInputDown = false;
                this.setZRot(this.roll * 0.98f);
                this.setXRot(this.getXRot() * 0.98f);
                if (passenger2 == null && passenger3 == null && passenger4 == null) {
                    this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() * 0.99f));
                }
            } else if (passenger instanceof Player) {
                if (this.rightInputDown) {
                    ++this.holdTick;
                    this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() - 2.0f * (float)Math.min((int)this.holdTick, (int)7) * ((Float)this.entityData.get(POWER)).floatValue()));
                } else if (this.leftInputDown) {
                    ++this.holdTick;
                    this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() + 2.0f * (float)Math.min((int)this.holdTick, (int)7) * ((Float)this.entityData.get(POWER)).floatValue()));
                } else {
                    this.holdTick = 0;
                }
                this.delta_x = (this.onGround() ? 0.0f : 1.5f) * ((Float)this.entityData.get(MOUSE_SPEED_Y)).floatValue() * ((Float)this.entityData.get(PROPELLER_ROT)).floatValue();
                this.delta_y = Mth.clamp((float)((this.onGround() ? 0.1f : 2.0f) * ((Float)this.entityData.get(MOUSE_SPEED_X)).floatValue() * ((Float)this.entityData.get(PROPELLER_ROT)).floatValue()), (float)-10.0f, (float)10.0f);
                this.setYRot(this.getYRot() + this.delta_y);
                this.setXRot(this.getXRot() + this.delta_x);
                this.setZRot(this.getRoll() - ((Float)this.entityData.get(DELTA_ROT)).floatValue() + (this.onGround() ? 0.0f : 0.25f) * ((Float)this.entityData.get(MOUSE_SPEED_X)).floatValue() * ((Float)this.entityData.get(PROPELLER_ROT)).floatValue());
            }
            if (this.level() instanceof ServerLevel) {
                if (this.getEnergy() > 0) {
                    boolean up = this.upInputDown || this.forwardInputDown;
                    boolean down = this.downInputDown;
                    if (!this.engineStart && up) {
                        this.engineStart = true;
                        this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.HELICOPTER_ENGINE_START.get(), this.getSoundSource(), 3.0f, 1.0f);
                    }
                    if (up && this.engineStartOver) {
                        ++this.holdPowerTick;
                        this.entityData.set(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.entityData.get(POWER)).floatValue() + 7.0E-4f * (float)Math.min((int)this.holdPowerTick, (int)10)), (float)0.12f)));
                    }
                    if (this.engineStartOver) {
                        if (down) {
                            ++this.holdPowerTick;
                            this.entityData.set(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.entityData.get(POWER)).floatValue() - 0.001f * (float)Math.min((int)this.holdPowerTick, (int)5)), (float)(this.onGround() ? 0.0f : 0.025f))));
                        } else if (this.backInputDown) {
                            ++this.holdPowerTick;
                            this.entityData.set(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.entityData.get(POWER)).floatValue() - 0.001f * (float)Math.min((int)this.holdPowerTick, (int)5)), (float)(this.onGround() ? 0.0f : 0.052f))));
                            if (passenger != null) {
                                passenger.setXRot(0.8f * passenger.getXRot());
                            }
                        }
                    }
                    if (this.engineStart && !this.engineStartOver) {
                        this.entityData.set(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.entityData.get(POWER)).floatValue() + 0.0012f), (float)0.045f)));
                    }
                    if (!up && !down && !this.backInputDown && this.engineStartOver) {
                        if (this.getDeltaMovement().y() < 0.0) {
                            this.entityData.set(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.entityData.get(POWER)).floatValue() + 2.0E-4f), (float)0.12f)));
                        } else {
                            this.entityData.set(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.entityData.get(POWER)).floatValue() - (this.onGround() ? 5.0E-5f : 2.0E-4f)), (float)0.0f)));
                        }
                        this.holdPowerTick = 0;
                    }
                } else {
                    this.entityData.set(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.entityData.get(POWER)).floatValue() - 1.0E-4f), (float)0.0f)));
                    this.forwardInputDown = false;
                    this.backInputDown = false;
                    this.engineStart = false;
                    this.engineStartOver = false;
                }
            }
        } else if (!this.onGround() && this.engineStartOver) {
            this.entityData.set(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.entityData.get(POWER)).floatValue() - 3.0E-4f), (float)0.01f)));
            this.destroyRot += 0.08f;
            float diffX = 45.0f - this.getXRot();
            float diffZ = -20.0f - this.getRoll();
            this.setXRot(this.getXRot() + diffX * 0.05f * ((Float)this.entityData.get(PROPELLER_ROT)).floatValue());
            this.setYRot(this.getYRot() + this.destroyRot);
            this.setZRot(this.getRoll() + diffZ * 0.1f * ((Float)this.entityData.get(PROPELLER_ROT)).floatValue());
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(-this.destroyRot) * 0.004, 0.0));
        }
        this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() * 0.9f));
        this.entityData.set(PROPELLER_ROT, (Object)Float.valueOf(Mth.lerp((float)0.18f, (float)((Float)this.entityData.get(PROPELLER_ROT)).floatValue(), (float)((Float)this.entityData.get(POWER)).floatValue())));
        this.setPropellerRot(this.getPropellerRot() + 30.0f * ((Float)this.entityData.get(PROPELLER_ROT)).floatValue());
        this.entityData.set(PROPELLER_ROT, (Object)Float.valueOf(((Float)this.entityData.get(PROPELLER_ROT)).floatValue() * 0.9995f));
        if (this.engineStart) {
            this.consumeEnergy((int)((double)((Integer)VehicleConfig.AH_6_MIN_ENERGY_COST.get()).intValue() + (double)((Float)this.entityData.get(POWER)).floatValue() * ((double)((Integer)VehicleConfig.AH_6_MAX_ENERGY_COST.get() - (Integer)VehicleConfig.AH_6_MIN_ENERGY_COST.get()) / 0.12)));
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f force0 = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f force1 = this.transformPosition(transform, 0.0f, 1.0f, 0.0f);
        Vec3 force = new Vec3((double)force0.x, (double)force0.y, (double)force0.z).vectorTo(new Vec3((double)force1.x, (double)force1.y, (double)force1.z));
        this.setDeltaMovement(this.getDeltaMovement().add(force.scale((double)((Float)this.entityData.get(POWER)).floatValue())));
        if (((Float)this.entityData.get(POWER)).floatValue() > 0.04f) {
            this.engineStartOver = true;
        }
        if (((Float)this.entityData.get(POWER)).floatValue() < 4.0E-4f) {
            this.engineStart = false;
            this.engineStartOver = false;
        }
    }

    @Override
    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.HELICOPTER_ENGINE.get();
    }

    @Override
    public float getEngineSoundVolume() {
        return ((Float)this.entityData.get(PROPELLER_ROT)).floatValue() * 2.0f;
    }

    protected void clampRotation(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            float f2 = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
            float f3 = Mth.clamp((float)f2, (float)-80.0f, (float)80.0f);
            entity.yRotO += f3 - f2;
            entity.setYRot(entity.getYRot() + f3 - f2);
            entity.setYBodyRot(this.getYRot());
        } else if (entity == this.getNthEntity(1)) {
            float f = Mth.wrapDegrees((float)entity.getXRot());
            float f1 = Mth.clamp((float)f, (float)-80.0f, (float)80.0f);
            entity.xRotO += f1 - f;
            entity.setXRot(entity.getXRot() + f1 - f);
            float f2 = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
            float f3 = Mth.clamp((float)f2, (float)-80.0f, (float)80.0f);
            entity.yRotO += f3 - f2;
            entity.setYRot(entity.getYRot() + f3 - f2);
            entity.setYBodyRot(this.getYRot());
        } else if (entity == this.getNthEntity(2)) {
            float f2 = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
            float f3 = Mth.clamp((float)f2, (float)10.0f, (float)170.0f);
            entity.yRotO += f3 - f2;
            entity.setYRot(entity.getYRot() + f3 - f2);
            entity.setYBodyRot(this.getYRot() + 90.0f);
        } else if (entity == this.getNthEntity(3)) {
            float f2 = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
            float f3 = Mth.clamp((float)f2, (float)-170.0f, (float)-10.0f);
            entity.yRotO += f3 - f2;
            entity.setYRot(entity.getYRot() + f3 - f2);
            entity.setYBodyRot(this.getYRot() - 90.0f);
        }
    }

    public void onPassengerTurned(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    public void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.hasPassenger(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        float x = 0.6f;
        float y = -0.65f;
        float z = 1.0f;
        int i = this.getOrderedPassengers().indexOf(passenger);
        if (i == 0) {
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        } else if (i == 1) {
            Vector4f worldPosition = this.transformPosition(transform, -x, y, z);
            passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        } else if (i == 2) {
            Vector4f worldPosition = this.transformPosition(transform, -1.4f, -1.05f, 0.0f);
            passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        } else if (i == 3) {
            Vector4f worldPosition = this.transformPosition(transform, 1.4f, -1.05f, 0.0f);
            passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        }
        if (passenger != this.getFirstPassenger()) {
            passenger.setXRot(passenger.getXRot() + (this.getXRot() - this.xRotO));
        }
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.setYHeadRot(entity.getYHeadRot() + this.delta_y);
            entity.setYRot(entity.getYRot() + this.delta_y);
            entity.setYBodyRot(this.getYRot());
        } else if (entity == this.getNthEntity(1)) {
            float f = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
            float g = Mth.clamp((float)f, (float)-105.0f, (float)105.0f);
            entity.yRotO += g - f;
            entity.setYRot(entity.getYRot() + g - f + 0.9f * this.destroyRot);
            entity.setYHeadRot(entity.getYRot());
            entity.setYBodyRot(this.getYRot());
        } else if (entity == this.getNthEntity(2)) {
            float f = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
            float g = Mth.clamp((float)f, (float)10.0f, (float)170.0f);
            entity.yRotO += g - f;
            entity.setYRot(entity.getYRot() + g - f + 0.9f * this.destroyRot);
            entity.setYHeadRot(entity.getYRot());
            entity.setYBodyRot(this.getYRot() + 90.0f);
        } else if (entity == this.getNthEntity(3)) {
            float f = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
            float g = Mth.clamp((float)f, (float)-170.0f, (float)-10.0f);
            entity.yRotO += g - f;
            entity.setYRot(entity.getYRot() + g - f + 0.9f * this.destroyRot);
            entity.setYHeadRot(entity.getYRot());
            entity.setYBodyRot(this.getYRot() - 90.0f);
        }
    }

    @Override
    public Matrix4f getVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.lerp((double)ticks, (double)this.xo, (double)this.getX()), (float)Mth.lerp((double)ticks, (double)(this.yo + (double)1.45f), (double)(this.getY() + (double)1.45f)), (float)Mth.lerp((double)ticks, (double)this.zo, (double)this.getZ()));
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees(-Mth.lerp((float)ticks, (float)this.yRotO, (float)this.getYRot())));
        transform.rotate((Quaternionfc)Axis.XP.rotationDegrees(Mth.lerp((float)ticks, (float)this.xRotO, (float)this.getXRot())));
        transform.rotate((Quaternionfc)Axis.ZP.rotationDegrees(Mth.lerp((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    @Override
    public void destroy() {
        if (this.crash) {
            this.crashPassengers();
        } else {
            this.explodePassengers();
        }
        if (this.level() instanceof ServerLevel) {
            CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this, this.getAttacker()), 300.0f, this.getX(), this.getY(), this.getZ(), 8.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
            explosion.explode();
            EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
            explosion.finalizeExplosion(false);
            ParticleTool.spawnHugeExplosionParticles(this.level(), this.position());
        }
        super.destroy();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public Vec3 shootPos(float tickDelta) {
        Matrix4f transform = this.getVehicleTransform(tickDelta);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, -0.83f, 0.8f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 shootVec(float tickDelta) {
        Matrix4f transform = this.getVehicleTransform(tickDelta);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 0.01f, 1.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z).vectorTo(new Vec3((double)worldPosition2.x, (double)worldPosition2.y, (double)worldPosition2.z)).normalize();
    }

    @Override
    public void vehicleShoot(Player player, int type) {
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers() - 1; ++i) {
            Player pPlayer;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox(pPlayer = (Player)entity)) continue;
            hasCreativeAmmo = true;
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        if (this.getWeaponIndex(0) == 0) {
            Vector4f worldPosition2;
            Vector4f worldPosition;
            if (this.cannotFire) {
                return;
            }
            if (this.fireIndex == 0) {
                worldPosition = this.transformPosition(transform, 1.15f, -0.83f, 0.8f);
                worldPosition2 = this.transformPosition(transform, 1.157f, -0.81799996f, 1.8f);
                this.fireIndex = 1;
            } else {
                worldPosition = this.transformPosition(transform, -1.15f, -0.83f, 0.8f);
                worldPosition2 = this.transformPosition(transform, -1.139f, -0.81799996f, 1.8f);
                this.fireIndex = 0;
            }
            Vec3 shootVec = new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z).vectorTo(new Vec3((double)worldPosition2.x, (double)worldPosition2.y, (double)worldPosition2.z)).normalize();
            if ((Integer)this.entityData.get(AMMO) > 0 || hasCreativeAmmo) {
                SmallCannonShellEntity entityToSpawn = ((SmallCannonShellWeapon)this.getWeapon(0)).create((LivingEntity)player);
                entityToSpawn.setPos(worldPosition.x, worldPosition.y, worldPosition.z);
                entityToSpawn.shoot(shootVec.x, shootVec.y, shootVec.z, 20.0f, 0.15f);
                this.level().addFreshEntity((Entity)entityToSpawn);
                ParticleTool.sendParticle((ServerLevel)this.level(), ParticleTypes.LARGE_SMOKE, worldPosition.x, worldPosition.y, worldPosition.z, 1, 0.0, 0.0, 0.0, 0.0, false);
                if (!hasCreativeAmmo) {
                    ItemStack ammoBox = this.getItemStacks().stream().filter(stack -> {
                        if (stack.is((Item)ModItems.AMMO_BOX.get())) {
                            return Ammo.HEAVY.get((ItemStack)stack) > 0;
                        }
                        return false;
                    }).findFirst().orElse(ItemStack.EMPTY);
                    if (!ammoBox.isEmpty()) {
                        Ammo.HEAVY.add(ammoBox, -1);
                    } else {
                        this.getItemStacks().stream().filter(stack -> stack.is((Item)ModItems.SMALL_SHELL.get())).findFirst().ifPresent(stack -> stack.shrink(1));
                    }
                }
            }
            this.entityData.set(HEAT, (Object)((Integer)this.entityData.get(HEAT) + 4));
            if (!player.level().isClientSide) {
                this.playShootSound3p(player, 0, 4, 12, 24);
            }
        } else if (this.getWeaponIndex(0) == 1 && (Integer)this.getEntityData().get(LOADED_ROCKET) > 0) {
            Vector4f worldPosition2;
            Vector4f worldPosition;
            HeliRocketEntity heliRocketEntity = ((HeliRocketWeapon)this.getWeapon(0)).create((LivingEntity)player);
            if (this.fireIndex == 0) {
                worldPosition = this.transformPosition(transform, 1.7f, -0.83f, 0.8f);
                worldPosition2 = this.transformPosition(transform, 1.7064999f, -0.81799996f, 1.8f);
                this.fireIndex = 1;
            } else {
                worldPosition = this.transformPosition(transform, -1.7f, -0.83f, 0.8f);
                worldPosition2 = this.transformPosition(transform, -1.6885f, -0.81799996f, 1.8f);
                this.fireIndex = 0;
            }
            Vec3 shootVec = new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z).vectorTo(new Vec3((double)worldPosition2.x, (double)worldPosition2.y, (double)worldPosition2.z)).normalize();
            heliRocketEntity.setPos(worldPosition.x, worldPosition.y, worldPosition.z);
            heliRocketEntity.shoot(shootVec.x, shootVec.y, shootVec.z, 7.0f, 0.25f);
            player.level().addFreshEntity((Entity)heliRocketEntity);
            if (!player.level().isClientSide) {
                this.playShootSound3p(player, 0, 6, 6, 6);
            }
            this.entityData.set(LOADED_ROCKET, (Object)((Integer)this.getEntityData().get(LOADED_ROCKET) - 1));
            this.reloadCoolDown = 30;
        }
    }

    @Override
    public int mainGunRpm(Player player) {
        return 500;
    }

    @Override
    public boolean canShoot(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return ((Integer)this.entityData.get(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox(player)) && !this.cannotFire;
        }
        if (this.getWeaponIndex(0) == 1) {
            return (Integer)this.entityData.get(AMMO) > 0;
        }
        return false;
    }

    @Override
    public int getAmmoCount(Player player) {
        return (Integer)this.entityData.get(AMMO);
    }

    @Override
    public boolean hidePassenger(Entity entity) {
        return false;
    }

    @Override
    public int zoomFov() {
        return 3;
    }

    @Override
    public int getWeaponHeat(Player player) {
        return (Integer)this.entityData.get(HEAT);
    }

    @Override
    public float getRotX(float tickDelta) {
        return this.getPitch(tickDelta);
    }

    @Override
    public float getRotY(float tickDelta) {
        return this.getYaw(tickDelta);
    }

    @Override
    public float getRotZ(float tickDelta) {
        return this.getRoll(tickDelta);
    }

    @Override
    public float getPower() {
        return ((Float)this.entityData.get(POWER)).floatValue();
    }

    @Override
    public int getDecoy() {
        return (Integer)this.entityData.get(DECOY_COUNT);
    }

    @Override
    public int getMaxPassengers() {
        return 4;
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/ah_6_icon.png");
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return seatIndex == 0 ? 0.0 : original;
    }

    @Override
    public double getMouseSensitivity() {
        return 0.15;
    }

    @Override
    public double getMouseSpeedX() {
        return 0.35;
    }

    @Override
    public double getMouseSpeedY() {
        return 0.2;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Pair<Quaternionf, Quaternionf> getPassengerRotation(Entity entity, float tickDelta) {
        if (this.getSeatIndex(entity) == 2) {
            return Pair.of((Object)Axis.XP.rotationDegrees(-this.getRoll(tickDelta)), (Object)Axis.ZP.rotationDegrees(this.getViewXRot(tickDelta)));
        }
        if (this.getSeatIndex(entity) == 3) {
            return Pair.of((Object)Axis.XP.rotationDegrees(this.getRoll(tickDelta)), (Object)Axis.ZP.rotationDegrees(-this.getViewXRot(tickDelta)));
        }
        return Pair.of((Object)Axis.XP.rotationDegrees(-this.getViewXRot(tickDelta)), (Object)Axis.ZP.rotationDegrees(-this.getRoll(tickDelta)));
    }

    public Matrix4f getClientVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.lerp((double)ticks, (double)this.xo, (double)this.getX()), (float)Mth.lerp((double)ticks, (double)(this.yo + (double)1.45f), (double)(this.getY() + (double)1.45f)), (float)Mth.lerp((double)ticks, (double)this.zo, (double)this.getZ()));
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees((float)((double)(-Mth.lerp((float)ticks, (float)this.yRotO, (float)this.getYRot())) + ClientMouseHandler.freeCameraYaw)));
        transform.rotate((Quaternionfc)Axis.XP.rotationDegrees((float)((double)Mth.lerp((float)ticks, (float)this.xRotO, (float)this.getXRot()) + ClientMouseHandler.freeCameraPitch)));
        transform.rotate((Quaternionfc)Axis.ZP.rotationDegrees(Mth.lerp((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (this.getSeatIndex((Entity)player) == 0) {
            return new Vec2((float)((double)(this.getRotY(partialTicks) - 0.5f * Mth.lerp((float)partialTicks, (float)this.delta_yo, (float)this.delta_y)) - ClientMouseHandler.freeCameraYaw), (float)((double)(this.getRotX(partialTicks) - 0.5f * Mth.lerp((float)partialTicks, (float)this.delta_xo, (float)this.delta_x)) + ClientMouseHandler.freeCameraPitch));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (this.getSeatIndex((Entity)player) == 0) {
            Matrix4f transform = this.getClientVehicleTransform(partialTicks);
            Vector4f maxCameraPosition = this.transformPosition(transform, -2.1f, 1.0f, -10.0f - (float)ClientMouseHandler.custom3pDistanceLerp);
            Vec3 finalPos = CameraTool.getMaxZoom(transform, maxCameraPosition);
            if (isFirstPerson) {
                return new Vec3(Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()), Mth.lerp((double)partialTicks, (double)(player.yo + (double)player.getEyeHeight()), (double)player.getEyeY()), Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()));
            }
            return finalPos;
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/aircraft.png");
    }
}

