/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.projectile.AerialBombEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.CannonEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.EnergyVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.LaserWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.FiringParameters;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.Comparator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AnnihilatorEntity
extends EnergyVehicleEntity
implements GeoEntity,
CannonEntity {
    public static final EntityDataAccessor<Integer> COOL_DOWN = SynchedEntityData.defineId(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> LASER_LEFT_LENGTH = SynchedEntityData.defineId(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> LASER_MIDDLE_LENGTH = SynchedEntityData.defineId(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> LASER_RIGHT_LENGTH = SynchedEntityData.defineId(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> PITCH = SynchedEntityData.defineId(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> YAW = SynchedEntityData.defineId(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<String> SHOOTER_UUID = SynchedEntityData.defineId(AnnihilatorEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public Vec3 barrelLookAt;

    public AnnihilatorEntity(EntityType<AnnihilatorEntity> type, Level world) {
        super(type, world);
        this.noCulling = true;
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new LaserWeapon()}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(16.0 + 2.0 * ClientMouseHandler.custom3pDistanceLerp, 1.3, 0.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COOL_DOWN, (Object)0).define(SHOOTER_UUID, (Object)"none").define(LASER_LEFT_LENGTH, (Object)Float.valueOf(0.0f)).define(LASER_MIDDLE_LENGTH, (Object)Float.valueOf(0.0f)).define(LASER_RIGHT_LENGTH, (Object)Float.valueOf(0.0f)).define(PITCH, (Object)Float.valueOf(0.0f)).define(YAW, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("CoolDown", ((Integer)this.entityData.get(COOL_DOWN)).intValue());
        compound.putFloat("Pitch", ((Float)this.entityData.get(PITCH)).floatValue());
        compound.putFloat("Yaw", ((Float)this.entityData.get(YAW)).floatValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(COOL_DOWN, (Object)compound.getInt("CoolDown"));
        this.entityData.set(PITCH, (Object)Float.valueOf(compound.getFloat("Pitch")));
        this.entityData.set(YAW, (Object)Float.valueOf(compound.getFloat("Yaw")));
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        if (player.getMainHandItem().getItem() == ModItems.FIRING_PARAMETERS.get() && player.isCrouching()) {
            this.setTarget(player.getOffhandItem());
            return InteractionResult.SUCCESS;
        }
        if (player.getOffhandItem().getItem() == ModItems.FIRING_PARAMETERS.get() && player.isCrouching()) {
            this.setTarget(player.getOffhandItem());
            return InteractionResult.SUCCESS;
        }
        if (stack.is((Item)ModItems.CROWBAR.get()) && !player.isCrouching()) {
            if ((Integer)this.entityData.get(COOL_DOWN) == 0) {
                this.vehicleShoot(player, 0);
                this.entityData.set(SHOOTER_UUID, (Object)player.getStringUUID());
            }
            return InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    public void setTarget(ItemStack stack) {
        FiringParameters.Parameters parameters = (FiringParameters.Parameters)stack.get(ModDataComponents.FIRING_PARAMETERS);
        if (parameters == null) {
            return;
        }
        BlockPos pos = parameters.pos();
        int targetX = pos.getX();
        int targetY = pos.getY();
        int targetZ = pos.getZ();
        this.look(new Vec3((double)targetX, (double)targetY, (double)targetZ));
    }

    private void look(Vec3 pTarget) {
        float yRot = this.getYRot();
        if (yRot < 0.0f) {
            yRot += 360.0f;
        }
        Vector3d BarrelRoot = new Vector3d(4.95, 2.25, 0.0);
        BarrelRoot.rotateY((double)(-(yRot += 90.0f) * ((float)Math.PI / 180)));
        Vec3 vec3 = new Vec3(this.getX() + BarrelRoot.x, this.getY() + BarrelRoot.y, this.getZ() + BarrelRoot.z);
        double d0 = pTarget.x - vec3.x;
        double d1 = pTarget.y - vec3.y;
        double d2 = pTarget.z - vec3.z;
        double d3 = org.joml.Math.sqrt((double)(d0 * d0 + d2 * d2));
        this.entityData.set(YAW, (Object)Float.valueOf(Mth.wrapDegrees((float)((float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f))));
        this.entityData.set(PITCH, (Object)Float.valueOf(Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875))))));
    }

    public void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.hasPassenger(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleFlatTransform(1.0f);
        float x = 0.0f;
        float y = 3.3f;
        float z = 1.5f;
        Vector4f worldPosition = this.transformPosition(transform, x, y, z);
        passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 3.0f) * damage.floatValue())).custom((source, damage) -> {
            if (source.getDirectEntity() instanceof AerialBombEntity) {
                return Float.valueOf(8.0f * damage.floatValue());
            }
            return damage;
        });
    }

    @NotNull
    public Vec3 getDeltaMovement() {
        return new Vec3(0.0, org.joml.Math.min((double)super.getDeltaMovement().y, (double)0.0), 0.0);
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if ((Integer)this.entityData.get(COOL_DOWN) > 0) {
            this.entityData.set(COOL_DOWN, (Object)((Integer)this.entityData.get(COOL_DOWN) - 1));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.onGround()) {
            this.setDeltaMovement(Vec3.ZERO);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.lowHealthWarning();
        float delta = org.joml.Math.abs((float)(this.getYRot() - this.yRotO));
        while (this.getYRot() > 180.0f) {
            this.setYRot(this.getYRot() - 360.0f);
            this.yRotO = this.getYRot() - delta;
        }
        while (this.getYRot() <= -180.0f) {
            this.setYRot(this.getYRot() + 360.0f);
            this.yRotO = delta + this.getYRot();
        }
        float yRot = this.getYRot();
        if (yRot < 0.0f) {
            yRot += 360.0f;
        }
        Vector3d BarrelRoot = new Vector3d(4.95, 2.25, 0.0);
        BarrelRoot.rotateY((double)(-(yRot += 90.0f) * ((float)Math.PI / 180)));
        Vec3 BarrelRootPos = new Vec3(this.getX() + BarrelRoot.x, this.getY() + BarrelRoot.y, this.getZ() + BarrelRoot.z);
        Vector3d leftPos = new Vector3d(16.0, 0.0, -2.703125);
        leftPos.rotateZ((double)(-this.getXRot() * ((float)Math.PI / 180)));
        leftPos.rotateY((double)(-yRot * ((float)Math.PI / 180)));
        Vec3 BarrelLeftPos = new Vec3(BarrelRootPos.x + leftPos.x, BarrelRootPos.y + leftPos.y, BarrelRootPos.z + leftPos.z);
        Vector3d middlePos = new Vector3d(16.0, 0.0, 0.0);
        middlePos.rotateZ((double)(-this.getXRot() * ((float)Math.PI / 180)));
        middlePos.rotateY((double)(-yRot * ((float)Math.PI / 180)));
        Vec3 BarrelMiddlePos = new Vec3(BarrelRootPos.x + middlePos.x, BarrelRootPos.y + middlePos.y, BarrelRootPos.z + middlePos.z);
        Vector3d rightPos = new Vector3d(16.0, 0.0, 2.703125);
        rightPos.rotateZ((double)(-this.getXRot() * ((float)Math.PI / 180)));
        rightPos.rotateY((double)(-yRot * ((float)Math.PI / 180)));
        Vec3 BarrelRightPos = new Vec3(BarrelRootPos.x + rightPos.x, BarrelRootPos.y + rightPos.y, BarrelRootPos.z + rightPos.z);
        if ((Integer)this.entityData.get(COOL_DOWN) > 88) {
            this.entityData.set(LASER_LEFT_LENGTH, (Object)Float.valueOf(org.joml.Math.min((float)this.laserLength(BarrelLeftPos, this), (float)this.laserLengthEntity(BarrelLeftPos, this))));
            this.entityData.set(LASER_MIDDLE_LENGTH, (Object)Float.valueOf(org.joml.Math.min((float)this.laserLength(BarrelMiddlePos, this), (float)this.laserLengthEntity(BarrelMiddlePos, this))));
            this.entityData.set(LASER_RIGHT_LENGTH, (Object)Float.valueOf(org.joml.Math.min((float)this.laserLength(BarrelRightPos, this), (float)this.laserLengthEntity(BarrelRightPos, this))));
        }
        if ((Integer)this.entityData.get(COOL_DOWN) == 20) {
            this.level().playSound(null, this.getOnPos(), (SoundEvent)ModSounds.ANNIHILATOR_RELOAD.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public void handleClientSync() {
        if (this.isControlledByLocalInstance()) {
            this.interpolationSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedYaw = Mth.wrapDegrees((double)(this.serverYRot - (double)this.getYRot()));
        this.setYRot(this.getYRot() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.setXRot(this.getXRot() + (float)(this.serverXRot - (double)this.getXRot()) / (float)this.interpolationSteps);
        this.setRot(this.getYRot(), this.getXRot());
    }

    @Override
    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.serverYRot = yRot;
        this.serverXRot = xRot;
        this.interpolationSteps = 10;
    }

    private float laserLength(Vec3 pos, Entity cannon) {
        if (this.level() instanceof ServerLevel) {
            BlockHitResult result = cannon.level().clip(new ClipContext(pos, pos.add(cannon.getViewVector(1.0f).scale(512.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, cannon));
            Vec3 looking = Vec3.atLowerCornerOf((Vec3i)result.getBlockPos());
            Vec3 hitPos = result.getLocation();
            BlockPos _pos = BlockPos.containing((double)looking.x, (double)looking.y, (double)looking.z);
            float hardness = this.level().getBlockState(_pos).getBlock().defaultDestroyTime();
            if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() && hardness != -1.0f) {
                Block.dropResources((BlockState)this.level().getBlockState(_pos), (LevelAccessor)this.level(), (BlockPos)_pos, null);
                this.level().destroyBlock(_pos, true);
            }
            if ((Integer)this.entityData.get(COOL_DOWN) > 98) {
                this.laserExplosion(hitPos);
            }
            if (this.getFirstPassenger() != null) {
                this.level().explode(this.getFirstPassenger(), hitPos.x, hitPos.y, hitPos.z, 5.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
            } else {
                Entity shooter = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(SHOOTER_UUID));
                this.level().explode(shooter, hitPos.x, hitPos.y, hitPos.z, 5.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
            }
        }
        return (float)pos.distanceTo(Vec3.atLowerCornerOf((Vec3i)cannon.level().clip(new ClipContext(pos, pos.add(cannon.getViewVector(1.0f).scale(512.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, cannon)).getBlockPos()));
    }

    private float laserLengthEntity(Vec3 pos, Entity cannon) {
        if (this.level() instanceof ServerLevel) {
            AABB aabb;
            double blockReach;
            double distance = 262144.0;
            HitResult hitResult = cannon.pick(512.0, 1.0f, false);
            if (hitResult.getType() != HitResult.Type.MISS && (distance = hitResult.getLocation().distanceToSqr(pos)) > (blockReach = 5.0) * blockReach) {
                Vec3 posB = hitResult.getLocation();
                hitResult = BlockHitResult.miss((Vec3)posB, (Direction)Direction.getNearest((double)pos.x, (double)pos.y, (double)pos.z), (BlockPos)BlockPos.containing((Position)posB));
            }
            Vec3 viewVec = cannon.getViewVector(1.0f);
            Vec3 toVec = pos.add(viewVec.x * 512.0, viewVec.y * 512.0, viewVec.z * 512.0);
            EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)cannon, (Vec3)pos, (Vec3)toVec, (AABB)(aabb = cannon.getBoundingBox().expandTowards(viewVec.scale(512.0)).inflate(1.0, 1.0, 1.0)), p -> !p.isSpectator(), (double)distance);
            if (entityhitresult != null) {
                Vec3 targetPos = entityhitresult.getLocation();
                double distanceToTarget = pos.distanceToSqr(targetPos);
                if (distanceToTarget > distance || distanceToTarget > 262144.0) {
                    hitResult = BlockHitResult.miss((Vec3)targetPos, (Direction)Direction.getNearest((double)viewVec.x, (double)viewVec.y, (double)viewVec.z), (BlockPos)BlockPos.containing((Position)targetPos));
                } else if (distanceToTarget < distance) {
                    hitResult = entityhitresult;
                }
                if (hitResult.getType() == HitResult.Type.ENTITY) {
                    Entity passenger = this.getFirstPassenger();
                    Entity target = ((EntityHitResult)hitResult).getEntity();
                    if (passenger != null) {
                        target.hurt(ModDamageTypes.causeLaserDamage(this.level().registryAccess(), this, passenger), 200.0f);
                    } else {
                        Entity shooter = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(SHOOTER_UUID));
                        target.hurt(ModDamageTypes.causeLaserDamage(this.level().registryAccess(), this, shooter), 200.0f);
                    }
                    target.invulnerableTime = 0;
                    if ((Integer)this.entityData.get(COOL_DOWN) > 98) {
                        this.laserExplosion(targetPos);
                    }
                    return (float)pos.distanceTo(target.position());
                }
            }
        }
        return 512.0f;
    }

    private void laserExplosion(Vec3 pos) {
        Entity passenger = this.getFirstPassenger();
        if (passenger != null) {
            CustomExplosion explosion = new CustomExplosion(this.level(), passenger, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), this, passenger), 300.0f, pos.x, pos.y, pos.z, 15.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
            explosion.explode();
            EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
            explosion.finalizeExplosion(false);
            ParticleTool.spawnHugeExplosionParticles(this.level(), pos);
        } else {
            Entity shooter = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(SHOOTER_UUID));
            CustomExplosion explosion = new CustomExplosion(this.level(), shooter, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), this, shooter), 300.0f, pos.x, pos.y, pos.z, 15.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
            explosion.explode();
            EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
            explosion.finalizeExplosion(false);
            ParticleTool.spawnHugeExplosionParticles(this.level(), pos);
        }
    }

    @Override
    public void destroy() {
        if (this.level() instanceof ServerLevel) {
            CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this.getAttacker(), this.getAttacker()), 600.0f, this.getX(), this.getY(), this.getZ(), 15.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
            explosion.explode();
            EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
            explosion.finalizeExplosion(false);
            ParticleTool.spawnHugeExplosionParticles(this.level(), this.position());
        }
        this.explodePassengers();
        super.destroy();
    }

    @Override
    public void vehicleShoot(Player player, int type) {
        if ((Integer)this.entityData.get(COOL_DOWN) > 0) {
            return;
        }
        if (!this.canConsume((Integer)VehicleConfig.ANNIHILATOR_SHOOT_COST.get())) {
            player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.annihilator.energy_not_enough").withStyle(ChatFormatting.RED), true);
            return;
        }
        Level level = player.level();
        if (level instanceof ServerLevel) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.ANNIHILATOR_FIRE_1P.get(), 1.0f, 1.0f);
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.ANNIHILATOR_FIRE_3P.get(), SoundSource.PLAYERS, 6.0f, 1.0f);
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.ANNIHILATOR_FAR.get(), SoundSource.PLAYERS, 16.0f, 1.0f);
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.ANNIHILATOR_VERYFAR.get(), SoundSource.PLAYERS, 32.0f, 1.0f);
            }
            this.entityData.set(COOL_DOWN, (Object)100);
            this.consumeEnergy((Integer)VehicleConfig.ANNIHILATOR_SHOOT_COST.get());
            Vec3 center = new Vec3(this.getX(), this.getEyeY(), this.getZ());
            for (Entity target : level.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate(20.0), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList()) {
                if (!(target instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)target;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShakeClientMessage(15.0, 15.0, 25.0, this.getX(), this.getEyeY(), this.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Override
    public void travel() {
        Entity passenger = this.getFirstPassenger();
        if (this.getEnergy() <= 0) {
            return;
        }
        if (passenger instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)passenger;
            float yRot = this.getYRot();
            if (yRot < 0.0f) {
                yRot += 360.0f;
            }
            Vector3d BarrelRoot = new Vector3d(4.95, 2.25, 0.0);
            BarrelRoot.rotateY((double)(-(yRot += 90.0f) * ((float)Math.PI / 180)));
            Vec3 barrelRootPos = new Vec3(this.getX() + BarrelRoot.x, this.getY() + BarrelRoot.y, this.getZ() + BarrelRoot.z);
            Vec3 passengersEyePos = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
            Entity lookingAt = TraceTool.findLookingEntity((Entity)entity, 512.0);
            if (lookingAt == null) {
                BlockHitResult result = entity.level().clip(new ClipContext(passengersEyePos, passengersEyePos.add(entity.getViewVector(1.0f).scale(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity));
                Vec3 blockHitPos = result.getLocation();
                this.barrelLookAt = new Vec3(blockHitPos.x - barrelRootPos.x, blockHitPos.y - barrelRootPos.y, blockHitPos.z - barrelRootPos.z);
            } else {
                this.barrelLookAt = new Vec3(lookingAt.getX() - barrelRootPos.x, lookingAt.getEyeY() - barrelRootPos.y, lookingAt.getZ() - barrelRootPos.z);
            }
            float offset = (float)VectorTool.calculateAngle(entity.getViewVector(1.0f), this.barrelLookAt);
            this.entityData.set(YAW, (Object)Float.valueOf(passenger.getYHeadRot()));
            this.entityData.set(PITCH, (Object)Float.valueOf(Mth.clamp((float)(passenger.getXRot() - offset), (float)-45.0f, (float)5.0f)));
        }
        float diffY = Mth.wrapDegrees((float)(((Float)this.entityData.get(YAW)).floatValue() - this.getYRot()));
        float diffX = Mth.wrapDegrees((float)(((Float)this.entityData.get(PITCH)).floatValue() - this.getXRot()));
        this.turretTurnSound(diffX, diffY, 0.8f);
        this.setYRot(this.getYRot() + Mth.clamp((float)(0.5f * diffY), (float)-0.6f, (float)0.6f));
        this.setXRot(Mth.clamp((float)(this.getXRot() + Mth.clamp((float)diffX, (float)-0.8f, (float)0.8f)), (float)-45.0f, (float)5.0f));
    }

    protected void clampRotation(Entity entity) {
        float f = Mth.wrapDegrees((float)entity.getXRot());
        float f1 = Mth.clamp((float)f, (float)-45.0f, (float)5.0f);
        entity.xRotO += f1 - f;
        entity.setXRot(entity.getXRot() + f1 - f);
    }

    public void onPassengerTurned(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    private PlayState movementPredicate(AnimationState<AnnihilatorEntity> event) {
        if ((Integer)this.entityData.get(COOL_DOWN) > 85) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.annihilator.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.annihilator.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public int mainGunRpm(Player player) {
        return 0;
    }

    @Override
    public boolean canShoot(Player player) {
        return true;
    }

    @Override
    public int getAmmoCount(Player player) {
        IEnergyStorage cap = (IEnergyStorage)this.getCapability(Capabilities.EnergyStorage.ENTITY, null);
        return (int)((float)(cap != null ? cap.getEnergyStored() : 0) * 100.0f / (float)this.getMaxEnergy());
    }

    @Override
    public boolean hidePassenger(Entity entity) {
        return true;
    }

    @Override
    public int zoomFov() {
        return 5;
    }

    @Override
    public int getWeaponHeat(Player player) {
        return 0;
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/annihilator_icon.png");
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return zoom ? 0.15 : 0.3;
    }

    @Override
    public boolean isEnclosed(int index) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            return new Vec2(Mth.lerp((float)partialTicks, (float)player.yRotO, (float)player.getYRot()), Mth.lerp((float)partialTicks, (float)player.xRotO, (float)player.getXRot()));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            return new Vec3(Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()), Mth.lerp((double)partialTicks, (double)(player.yo + (double)player.getEyeHeight()), (double)player.getEyeY()), Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()));
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useFixedCameraPos(Entity entity) {
        return true;
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/defense.png");
    }
}

