/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.projectile.AerialBombEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.WgMissileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.ProjectileWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SmallCannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.WgMissileWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.mojang.math.Axis;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Bmp2Entity
extends ContainerMobileVehicleEntity
implements GeoEntity,
LandArmorEntity,
WeaponVehicleEntity {
    public static final EntityDataAccessor<Integer> CANNON_FIRE_TIME = SynchedEntityData.defineId(Bmp2Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> LOADED_MISSILE = SynchedEntityData.defineId(Bmp2Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> MISSILE_COUNT = SynchedEntityData.defineId(Bmp2Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int reloadCoolDown;

    public Bmp2Entity(EntityType<Bmp2Entity> type, Level world) {
        super(type, world);
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new SmallCannonShellWeapon().damage(((Integer)VehicleConfig.BMP_2_CANNON_DAMAGE.get()).intValue()).explosionDamage(((Integer)VehicleConfig.BMP_2_CANNON_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfig.BMP_2_CANNON_EXPLOSION_RADIUS.get()).floatValue()).sound((SoundEvent)ModSounds.INTO_MISSILE.get()).icon(Mod.loc("textures/screens/vehicle_weapon/cannon_30mm.png")).sound1p((SoundEvent)ModSounds.BMP_CANNON_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.BMP_CANNON_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.LAV_CANNON_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.LAV_CANNON_VERYFAR.get()), new ProjectileWeapon().damage(9.5f).headShot(2.0f).zoom(false).sound((SoundEvent)ModSounds.INTO_CANNON.get()).icon(Mod.loc("textures/screens/vehicle_weapon/gun_7_62mm.png")).sound1p((SoundEvent)ModSounds.COAX_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.M_60_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.M_60_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.M_60_VERYFAR.get()), new WgMissileWeapon().damage(((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_DAMAGE.get()).intValue()).explosionDamage(((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Integer)ExplosionConfig.WIRE_GUIDE_MISSILE_EXPLOSION_RADIUS.get()).intValue()).sound((SoundEvent)ModSounds.INTO_MISSILE.get()).sound1p((SoundEvent)ModSounds.BMP_MISSILE_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.BMP_MISSILE_FIRE_3P.get())}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(3.0 + ClientMouseHandler.custom3pDistanceLerp, 1.0, 0.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CANNON_FIRE_TIME, (Object)0).define(LOADED_MISSILE, (Object)0).define(MISSILE_COUNT, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("LoadedMissile", ((Integer)this.entityData.get(LOADED_MISSILE)).intValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(LOADED_MISSILE, (Object)compound.getInt("LoadedMissile"));
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.4f) * damage.floatValue())).custom((source, damage) -> {
            if (source.getDirectEntity() instanceof AerialBombEntity) {
                return Float.valueOf(2.0f * damage.floatValue());
            }
            return damage;
        });
    }

    @ParametersAreNonnullByDefault
    protected void playStepSound(BlockPos pPos, BlockState pState) {
        this.playSound((SoundEvent)ModSounds.WHEEL_STEP.get(), (float)(this.getDeltaMovement().length() * 0.15), this.random.nextFloat() * 0.15f + 1.05f);
    }

    @Override
    public double getSubmergedHeight(Entity entity) {
        return super.getSubmergedHeight(entity);
    }

    @Override
    public void baseTick() {
        Level level;
        super.baseTick();
        if (this.getLeftTrack() < 0.0f) {
            this.setLeftTrack(100.0f);
        }
        if (this.getLeftTrack() > 100.0f) {
            this.setLeftTrack(0.0f);
        }
        if (this.getRightTrack() < 0.0f) {
            this.setRightTrack(100.0f);
        }
        if (this.getRightTrack() > 100.0f) {
            this.setRightTrack(0.0f);
        }
        if (this.level() instanceof ServerLevel) {
            if (this.reloadCoolDown > 0) {
                --this.reloadCoolDown;
            }
            this.handleAmmo();
        }
        double fluidFloat = 0.052 * this.getSubmergedHeight(this);
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, fluidFloat, 0.0));
        if (this.onGround()) {
            float f0 = 0.54f + 0.25f * Mth.abs((float)(90.0f - (float)Bmp2Entity.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f)))) / 90.0f;
            this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).normalize().scale(0.05 * this.getDeltaMovement().dot(this.getViewVector(1.0f)))));
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)f0, 0.99, (double)f0));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.99, 0.99, 0.99));
        }
        if (this.isInWater()) {
            float f1 = (float)((double)0.7f - (double)0.04f * Math.min((double)this.getSubmergedHeight(this), (double)this.getBbHeight()) + (double)(0.08f * Mth.abs((float)(90.0f - (float)Bmp2Entity.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f)))) / 90.0f));
            this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).normalize().scale(0.04 * this.getDeltaMovement().dot(this.getViewVector(1.0f)))));
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)f1, 0.85, (double)f1));
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isInWater() && this.getDeltaMovement().length() > 0.1) {
                ParticleTool.sendParticle(serverLevel, ParticleTypes.CLOUD, this.getX() + 0.5 * this.getDeltaMovement().x, this.getY() + this.getSubmergedHeight(this) - 0.2, this.getZ() + 0.5 * this.getDeltaMovement().z, (int)(2.0 + 4.0 * this.getDeltaMovement().length()), 0.65, 0.0, 0.65, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.BUBBLE_COLUMN_UP, this.getX() + 0.5 * this.getDeltaMovement().x, this.getY() + this.getSubmergedHeight(this) - 0.2, this.getZ() + 0.5 * this.getDeltaMovement().z, (int)(2.0 + 10.0 * this.getDeltaMovement().length()), 0.65, 0.0, 0.65, 0.0, true);
            }
        }
        this.turretAngle(25.0f, 25.0f);
        this.terrainCompact(4.0f, 5.0f);
        this.inertiaRotate(1.0f);
        this.releaseSmokeDecoy(this.getTurretVector(1.0f));
        this.lowHealthWarning();
        this.refreshDimensions();
    }

    @Override
    public void terrainCompact(float w, float l) {
        if (this.onGround()) {
            float x1 = this.terrainCompactTrackValue(w, l)[0];
            float x2 = this.terrainCompactTrackValue(w, l - 1.0f)[0];
            float x3 = this.terrainCompactTrackValue(w, l - 2.0f)[0];
            float x4 = this.terrainCompactTrackValue(w, l - 3.0f)[0];
            float x5 = this.terrainCompactTrackValue(w, l - 4.0f)[0];
            float x6 = this.terrainCompactTrackValue(w, l - 5.0f)[0];
            List<Float> numbersX = Arrays.asList(Float.valueOf(x1), Float.valueOf(x2), Float.valueOf(x3), Float.valueOf(x4), Float.valueOf(x5), Float.valueOf(x6));
            float maxX = Collections.max(numbersX).floatValue();
            float minX = Collections.min(numbersX).floatValue();
            float z1 = this.terrainCompactTrackValue(w, l)[1];
            float z2 = this.terrainCompactTrackValue(w, l - 1.0f)[1];
            float z3 = this.terrainCompactTrackValue(w, l - 2.0f)[1];
            float z4 = this.terrainCompactTrackValue(w, l - 3.0f)[1];
            float z5 = this.terrainCompactTrackValue(w, l - 4.0f)[1];
            float z6 = this.terrainCompactTrackValue(w, l - 5.0f)[1];
            List<Float> numbersZ = Arrays.asList(Float.valueOf(z1), Float.valueOf(z2), Float.valueOf(z3), Float.valueOf(z4), Float.valueOf(z5), Float.valueOf(z6));
            float maxZ = Collections.max(numbersZ).floatValue();
            float minZ = Collections.min(numbersZ).floatValue();
            float diffX = Math.clamp((float)-15.0f, (float)15.0f, (float)((minX + maxX) / 2.0f));
            this.setXRot(Mth.clamp((float)(this.getXRot() + 0.15f * diffX), (float)-45.0f, (float)45.0f));
            float diffZ = Math.clamp((float)-15.0f, (float)15.0f, (float)(minZ + maxZ));
            this.setZRot(Mth.clamp((float)(this.getRoll() + 0.15f * diffZ), (float)-45.0f, (float)45.0f));
        } else if (this.isInWater()) {
            this.setXRot(this.getXRot() * 0.9f);
            this.setZRot(this.getRoll() * 0.9f);
        }
    }

    @Override
    public boolean canCollideHardBlock() {
        return this.getDeltaMovement().horizontalDistance() > 0.07 || (double)Mth.abs((float)((Float)this.entityData.get(POWER)).floatValue()) > 0.12;
    }

    private void handleAmmo() {
        Entity entity = this.getFirstPassenger();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int ammoCount = this.getItemStacks().stream().filter(stack -> {
            if (stack.is((Item)ModItems.AMMO_BOX.get())) {
                return Ammo.RIFLE.get((ItemStack)stack) > 0;
            }
            return false;
        }).mapToInt(Ammo.RIFLE::get).sum() + this.countItem((Item)ModItems.RIFLE_AMMO.get());
        if ((this.hasItem((Item)ModItems.WIRE_GUIDE_MISSILE.get()) || InventoryTool.hasCreativeAmmoBox(player)) && this.reloadCoolDown <= 0 && (Integer)this.getEntityData().get(LOADED_MISSILE) < 1) {
            this.entityData.set(LOADED_MISSILE, (Object)((Integer)this.getEntityData().get(LOADED_MISSILE) + 1));
            this.reloadCoolDown = 160;
            if (!InventoryTool.hasCreativeAmmoBox(player)) {
                this.getItemStacks().stream().filter(stack -> stack.is((Item)ModItems.WIRE_GUIDE_MISSILE.get())).findFirst().ifPresent(stack -> stack.shrink(1));
            }
            this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.BMP_MISSILE_RELOAD.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
        if (this.getWeaponIndex(0) == 0) {
            this.entityData.set(AMMO, (Object)this.countItem((Item)ModItems.SMALL_SHELL.get()));
        } else if (this.getWeaponIndex(0) == 1) {
            this.entityData.set(AMMO, (Object)ammoCount);
        } else {
            this.entityData.set(AMMO, (Object)((Integer)this.getEntityData().get(LOADED_MISSILE)));
        }
        this.entityData.set(MISSILE_COUNT, (Object)this.countItem((Item)ModItems.WIRE_GUIDE_MISSILE.get()));
    }

    @Override
    public void vehicleShoot(Player player, int type) {
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers() - 1; ++i) {
            Player pPlayer;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox(pPlayer = (Player)entity)) continue;
            hasCreativeAmmo = true;
        }
        Matrix4f transform = this.getBarrelTransform(1.0f);
        if (this.getWeaponIndex(0) == 0) {
            if (this.cannotFire) {
                return;
            }
            float x = -0.45f;
            float y = 0.4f;
            float z = 4.2f;
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            SmallCannonShellEntity smallCannonShell = ((SmallCannonShellWeapon)this.getWeapon(0)).create((LivingEntity)player);
            smallCannonShell.setPos((double)worldPosition.x - 1.1 * this.getDeltaMovement().x, worldPosition.y, (double)worldPosition.z - 1.1 * this.getDeltaMovement().z);
            smallCannonShell.shoot(this.getBarrelVector((float)1.0f).x, this.getBarrelVector((float)1.0f).y + (double)0.005f, this.getBarrelVector((float)1.0f).z, 35.0f, 0.25f);
            this.level().addFreshEntity((Entity)smallCannonShell);
            ParticleTool.sendParticle((ServerLevel)this.level(), ParticleTypes.LARGE_SMOKE, (double)worldPosition.x - 1.1 * this.getDeltaMovement().x, worldPosition.y, (double)worldPosition.z - 1.1 * this.getDeltaMovement().z, 1, 0.02, 0.02, 0.02, 0.0, false);
            if (!player.level().isClientSide) {
                this.playShootSound3p(player, 0, 4, 12, 24);
            }
            Level level = player.level();
            Vec3 center = new Vec3(this.getX(), this.getEyeY(), this.getZ());
            for (Entity target : level.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate(4.0), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList()) {
                if (!(target instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)target;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShakeClientMessage(6.0, 5.0, 9.0, this.getX(), this.getEyeY(), this.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.entityData.set(CANNON_RECOIL_TIME, (Object)40);
            this.entityData.set(YAW, (Object)Float.valueOf(this.getTurretYRot()));
            this.entityData.set(HEAT, (Object)((Integer)this.entityData.get(HEAT) + 7));
            this.entityData.set(FIRE_ANIM, (Object)3);
            if (hasCreativeAmmo) {
                return;
            }
            this.getItemStacks().stream().filter(stack -> stack.is((Item)ModItems.SMALL_SHELL.get())).findFirst().ifPresent(stack -> stack.shrink(1));
        } else if (this.getWeaponIndex(0) == 1) {
            if (this.cannotFireCoax) {
                return;
            }
            float x = -0.2f;
            float y = 0.3f;
            float z = 1.2f;
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            if ((Integer)this.entityData.get(AMMO) > 0 || hasCreativeAmmo) {
                ProjectileEntity projectileRight = ((ProjectileWeapon)this.getWeapon(0)).create((LivingEntity)player).setGunItemId(this.getType().getDescriptionId());
                projectileRight.bypassArmorRate(0.2f);
                projectileRight.setPos((double)worldPosition.x - 1.1 * this.getDeltaMovement().x, worldPosition.y, (double)worldPosition.z - 1.1 * this.getDeltaMovement().z);
                projectileRight.shoot(player, this.getBarrelVector((float)1.0f).x, this.getBarrelVector((float)1.0f).y + (double)0.002f, this.getBarrelVector((float)1.0f).z, 36.0f, 0.25f);
                this.level().addFreshEntity((Entity)projectileRight);
                if (!hasCreativeAmmo) {
                    ItemStack ammoBox = this.getItemStacks().stream().filter(stack -> {
                        if (stack.is((Item)ModItems.AMMO_BOX.get())) {
                            return Ammo.RIFLE.get((ItemStack)stack) > 0;
                        }
                        return false;
                    }).findFirst().orElse(ItemStack.EMPTY);
                    if (!ammoBox.isEmpty()) {
                        Ammo.RIFLE.add(ammoBox, -1);
                    } else {
                        this.getItemStacks().stream().filter(stack -> stack.is((Item)ModItems.RIFLE_AMMO.get())).findFirst().ifPresent(stack -> stack.shrink(1));
                    }
                }
            }
            this.entityData.set(COAX_HEAT, (Object)((Integer)this.entityData.get(COAX_HEAT) + 3));
            this.entityData.set(FIRE_ANIM, (Object)2);
            if (!player.level().isClientSide) {
                this.playShootSound3p(player, 0, 3, 6, 12);
            }
        } else if (this.getWeaponIndex(0) == 2 && (Integer)this.getEntityData().get(LOADED_MISSILE) > 0) {
            Matrix4f transformT = this.getBarrelTransform(1.0f);
            Vector4f worldPosition = this.transformPosition(transformT, 0.0f, 1.0f, 0.0f);
            WgMissileEntity wgMissileEntity = ((WgMissileWeapon)this.getWeapon(0)).create((LivingEntity)player);
            wgMissileEntity.setPos(worldPosition.x, worldPosition.y, worldPosition.z);
            wgMissileEntity.shoot(this.getBarrelVector((float)1.0f).x, this.getBarrelVector((float)1.0f).y, this.getBarrelVector((float)1.0f).z, 2.0f, 0.0f);
            player.level().addFreshEntity((Entity)wgMissileEntity);
            if (!player.level().isClientSide) {
                this.playShootSound3p(player, 0, 6, 0, 0);
            }
            this.entityData.set(LOADED_MISSILE, (Object)((Integer)this.getEntityData().get(LOADED_MISSILE) - 1));
            this.reloadCoolDown = 160;
        }
    }

    @Override
    public void travel() {
        Entity passenger0 = this.getFirstPassenger();
        if (this.getEnergy() <= 0) {
            return;
        }
        if (passenger0 == null) {
            this.leftInputDown = false;
            this.rightInputDown = false;
            this.forwardInputDown = false;
            this.backInputDown = false;
            this.entityData.set(POWER, (Object)Float.valueOf(0.0f));
        }
        if (this.forwardInputDown) {
            this.entityData.set(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.entityData.get(POWER)).floatValue() + (((Float)this.entityData.get(POWER)).floatValue() < 0.0f ? 0.004f : 0.0024f)), (float)0.21f)));
        }
        if (this.backInputDown) {
            this.entityData.set(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.entityData.get(POWER)).floatValue() - (((Float)this.entityData.get(POWER)).floatValue() > 0.0f ? 0.004f : 0.0024f)), (float)-0.16f)));
            if (this.rightInputDown) {
                this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() + 0.1f));
            } else if (this.leftInputDown) {
                this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() - 0.1f));
            }
        } else if (this.rightInputDown) {
            this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() - 0.1f));
        } else if (this.leftInputDown) {
            this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() + 0.1f));
        }
        if (this.forwardInputDown || this.backInputDown) {
            this.consumeEnergy((Integer)VehicleConfig.BMP_2_ENERGY_COST.get());
        }
        this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() * (this.upInputDown ? 0.5f : (this.rightInputDown || this.leftInputDown ? 0.947f : 0.96f))));
        this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() * (float)Math.max((double)((double)0.76f - (double)0.1f * this.getDeltaMovement().horizontalDistance()), (double)0.3)));
        double s0 = this.getDeltaMovement().dot(this.getViewVector(1.0f));
        this.setLeftWheelRot((float)((double)this.getLeftWheelRot() - 1.25 * s0 + (double)Mth.clamp((float)(0.75f * ((Float)this.entityData.get(DELTA_ROT)).floatValue()), (float)-5.0f, (float)5.0f)));
        this.setRightWheelRot((float)((double)this.getRightWheelRot() - 1.25 * s0 - (double)Mth.clamp((float)(0.75f * ((Float)this.entityData.get(DELTA_ROT)).floatValue()), (float)-5.0f, (float)5.0f)));
        this.setLeftTrack((float)((double)this.getLeftTrack() - 5.969026041820607 * s0 + Mth.clamp((double)(1.2566370801612687 * (double)((Float)this.entityData.get(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        this.setRightTrack((float)((double)this.getRightTrack() - 5.969026041820607 * s0 - Mth.clamp((double)(1.2566370801612687 * (double)((Float)this.entityData.get(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        this.setYRot((float)((double)this.getYRot() - (this.isInWater() && !this.onGround() ? 2.5 : 6.0) * (double)((Float)this.entityData.get(DELTA_ROT)).floatValue()));
        if (this.isInWater() || this.onGround()) {
            float power = ((Float)this.entityData.get(POWER)).floatValue() * Mth.clamp((float)(1.0f + (float)(s0 > 0.0 ? 1 : -1) * this.getXRot() / 35.0f), (float)0.0f, (float)2.0f);
            this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).scale((double)((!this.isInWater() && !this.onGround() ? 0.13f : (this.isInWater() && !this.onGround() ? 2.0f : 2.4f)) * power))));
        }
    }

    @Override
    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.BMP_ENGINE.get();
    }

    @Override
    public float getEngineSoundVolume() {
        return Math.max((float)Mth.abs((float)((Float)this.entityData.get(POWER)).floatValue()), (float)Mth.abs((float)(0.1f * ((Float)this.entityData.get(DELTA_ROT)).floatValue()))) * 2.5f;
    }

    public void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.hasPassenger(passenger)) {
            return;
        }
        Matrix4f transform = this.getTurretTransform(1.0f);
        Matrix4f transformV = this.getVehicleTransform(1.0f);
        int i = this.getSeatIndex(passenger);
        Vector4f worldPosition = i == 0 ? this.transformPosition(transform, 0.36f, -0.25f, 0.56f) : this.transformPosition(transformV, 0.0f, 1.0f, 0.0f);
        passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.setYBodyRot(this.getBarrelYRot(1.0f));
        }
    }

    @Override
    public int getMaxPassengers() {
        return 7;
    }

    @Override
    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getTurretTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.75f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 getNewEyePos(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.65f, 0.75f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).vectorTo(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.3625f, 0.293125f, 1.18095f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.lerp((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.lerp((float)ticks, (float)this.xRotO, (float)this.getXRot());
        float z = Mth.lerp((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.XP.rotationDegrees(x + r * xV + r2 * z));
        return transformT;
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).vectorTo(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 2.25f, -0.703125f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.YP.rotationDegrees(Mth.lerp((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    @Override
    public void destroy() {
        if (this.level() instanceof ServerLevel) {
            CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this.getAttacker(), this.getAttacker()), 80.0f, this.getX(), this.getY(), this.getZ(), 5.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
            explosion.explode();
            EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
            explosion.finalizeExplosion(false);
            ParticleTool.spawnMediumExplosionParticles(this.level(), this.position());
        }
        this.explodePassengers();
        super.destroy();
    }

    protected void clampRotation(Entity entity) {
        float a = this.getTurretYaw(1.0f);
        float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float min = -74.0f - r * this.getXRot() - r2 * this.getRoll();
        float max = 7.5f - r * this.getXRot() - r2 * this.getRoll();
        float f = Mth.wrapDegrees((float)entity.getXRot());
        float f1 = Mth.clamp((float)f, (float)min, (float)max);
        entity.xRotO += f1 - f;
        entity.setXRot(entity.getXRot() + f1 - f);
        entity.setYBodyRot(this.getBarrelYRot(1.0f));
    }

    public void onPassengerTurned(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    private PlayState firePredicate(AnimationState<Bmp2Entity> event) {
        if ((Integer)this.entityData.get(FIRE_ANIM) > 1 && this.getWeaponIndex(0) == 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.lav.fire"));
        }
        if ((Integer)this.entityData.get(FIRE_ANIM) > 0 && this.getWeaponIndex(0) == 1) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.lav.fire2"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.lav.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::firePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public int mainGunRpm(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return 250;
        }
        if (this.getWeaponIndex(0) == 1) {
            return 750;
        }
        return 250;
    }

    @Override
    public boolean canShoot(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return ((Integer)this.entityData.get(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox(player)) && !this.cannotFire;
        }
        if (this.getWeaponIndex(0) == 1) {
            return ((Integer)this.entityData.get(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox(player)) && !this.cannotFireCoax;
        }
        if (this.getWeaponIndex(0) == 2) {
            return (Integer)this.entityData.get(LOADED_MISSILE) > 0;
        }
        return false;
    }

    @Override
    public int getAmmoCount(Player player) {
        return (Integer)this.entityData.get(AMMO);
    }

    @Override
    public boolean banHand(Player player) {
        return true;
    }

    @Override
    public boolean hidePassenger(Entity entity) {
        return true;
    }

    @Override
    public int zoomFov() {
        return 3;
    }

    @Override
    public int getWeaponHeat(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return (Integer)this.entityData.get(HEAT);
        }
        if (this.getWeaponIndex(0) == 1) {
            return (Integer)this.entityData.get(COAX_HEAT);
        }
        return 0;
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/bmp2_icon.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        super.renderFirstPersonOverlay(guiGraphics, font, player, screenWidth, screenHeight, scale);
        if (this.getWeaponIndex(0) == 0) {
            double heat = 1.0f - (float)((Integer)this.getEntityData().get(HEAT)).intValue() / 100.0f;
            guiGraphics.drawString(font, (Component)Component.literal((String)(" 30MM 2A42 " + String.valueOf(InventoryTool.hasCreativeAmmoBox(player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), screenWidth / 2 - 33, screenHeight - 65, Mth.hsvToRgb((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
        } else if (this.getWeaponIndex(0) == 1) {
            double heat = 1.0f - (float)((Integer)this.getEntityData().get(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.drawString(font, (Component)Component.literal((String)(" 7.62MM \u041f\u041a\u0422 " + String.valueOf(InventoryTool.hasCreativeAmmoBox(player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), screenWidth / 2 - 33, screenHeight - 65, Mth.hsvToRgb((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
        } else {
            guiGraphics.drawString(font, (Component)Component.literal((String)("    9M113  " + String.valueOf(this.getEntityData().get(LOADED_MISSILE)) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox(player) ? "\u221e" : (Serializable)this.getEntityData().get(MISSILE_COUNT)))), screenWidth / 2 - 33, screenHeight - 65, 0x66FF00, false);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderThirdPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        if (this.getWeaponIndex(0) == 0) {
            double heat = (float)((Integer)this.getEntityData().get(HEAT)).intValue() / 100.0f;
            guiGraphics.drawString(font, (Component)Component.literal((String)("30MM 2A42 " + String.valueOf(InventoryTool.hasCreativeAmmoBox(player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), 30, -9, Mth.hsvToRgb((float)0.0f, (float)((float)heat), (float)1.0f), false);
        } else if (this.getWeaponIndex(0) == 1) {
            double heat2 = (float)((Integer)this.getEntityData().get(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.drawString(font, (Component)Component.literal((String)("7.62MM \u041f\u041a\u0422 " + String.valueOf(InventoryTool.hasCreativeAmmoBox(player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), 30, -9, Mth.hsvToRgb((float)0.0f, (float)((float)heat2), (float)1.0f), false);
        } else {
            guiGraphics.drawString(font, (Component)Component.literal((String)("9M113 " + String.valueOf(this.getEntityData().get(LOADED_MISSILE)) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox(player) ? "\u221e" : (Serializable)this.getEntityData().get(MISSILE_COUNT)))), 30, -9, -1, false);
        }
    }

    @Override
    public boolean hasTracks() {
        return true;
    }

    @Override
    public boolean hasDecoy() {
        return true;
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return zoom ? 0.22 : 0.27;
    }

    @Override
    public boolean isEnclosed(int index) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                return new Vec2((float)(-Bmp2Entity.getYRotFromVector(this.getBarrelVec(partialTicks))), (float)(-Bmp2Entity.getXRotFromVector(this.getBarrelVec(partialTicks))));
            }
            return new Vec2(Mth.lerp((float)partialTicks, (float)player.yHeadRotO, (float)player.getYHeadRot()), Mth.lerp((float)partialTicks, (float)player.xRotO, (float)player.getXRot()));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                if (zoom) {
                    return new Vec3(this.driverZoomPos((float)partialTicks).x, Mth.lerp((double)partialTicks, (double)(player.yo + (double)player.getEyeHeight()), (double)player.getEyeY()), this.driverZoomPos((float)partialTicks).z);
                }
                return new Vec3(Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()), Mth.lerp((double)partialTicks, (double)(player.yo + (double)player.getEyeHeight()), (double)player.getEyeY()), Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()));
            }
            return new Vec3(Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()) - 6.0 * player.getViewVector((float)partialTicks).x, Mth.lerp((double)partialTicks, (double)(player.yo + (double)player.getEyeHeight() + 1.0), (double)(player.getEyeY() + 1.0)) - 6.0 * player.getViewVector((float)partialTicks).y, Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()) - 6.0 * player.getViewVector((float)partialTicks).z);
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/land.png");
    }
}

