/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.C4Entity;
import com.atsuishio.superbwarfare.entity.projectile.DecoyEntity;
import com.atsuishio.superbwarfare.entity.projectile.LaserEntity;
import com.atsuishio.superbwarfare.entity.projectile.MortarShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.projectile.RgoGrenadeEntity;
import com.atsuishio.superbwarfare.entity.projectile.RpgRocketEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.Monitor;
import com.atsuishio.superbwarfare.item.common.ammo.MortarShell;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DroneEntity
extends MobileVehicleEntity
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> LINKED = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> CONTROLLER = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> KAMIKAZE_MODE = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> DELTA_X_ROT = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public boolean fire;
    public int collisionCoolDown;
    public double lastTickSpeed;
    public double lastTickVerticalSpeed;
    public ItemStack currentItem = ItemStack.EMPTY;
    public float pitch;
    public float pitchO;
    public int holdTickX;
    public int holdTickY;
    public int holdTickZ;

    public DroneEntity(EntityType<DroneEntity> type, Level world) {
        super(type, world);
    }

    public float getBodyPitch() {
        return this.pitch;
    }

    public void setBodyXRot(float rot) {
        this.pitch = rot;
    }

    public float getBodyPitch(float tickDelta) {
        return Mth.lerp((float)(0.6f * tickDelta), (float)this.pitchO, (float)this.getBodyPitch());
    }

    @Override
    public boolean sendFireStarParticleOnHurt() {
        return false;
    }

    @Override
    public boolean playHitSoundOnHurt() {
        return false;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DELTA_X_ROT, (Object)Float.valueOf(0.0f)).define(CONTROLLER, (Object)"undefined").define(LINKED, (Object)false).define(KAMIKAZE_MODE, (Object)0);
    }

    public boolean causeFallDamage(float l, float d, @NotNull DamageSource source) {
        return false;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Linked", ((Boolean)this.entityData.get(LINKED)).booleanValue());
        compound.putString("Controller", (String)this.entityData.get(CONTROLLER));
        compound.putInt("Ammo", ((Integer)this.entityData.get(AMMO)).intValue());
        compound.putInt("KamikazeMode", ((Integer)this.entityData.get(KAMIKAZE_MODE)).intValue());
        CompoundTag item = new CompoundTag();
        if (!item.isEmpty()) {
            this.currentItem.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)item);
        }
        compound.put("Item", (Tag)item);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Linked")) {
            this.entityData.set(LINKED, (Object)compound.getBoolean("Linked"));
        }
        if (compound.contains("Controller")) {
            this.entityData.set(CONTROLLER, (Object)compound.getString("Controller"));
        }
        if (compound.contains("Ammo")) {
            this.entityData.set(AMMO, (Object)compound.getInt("Ammo"));
        }
        if (compound.contains("KamikazeMode")) {
            this.entityData.set(KAMIKAZE_MODE, (Object)compound.getInt("KamikazeMode"));
        }
        if (compound.contains("Item")) {
            this.currentItem = ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)compound.getCompound("Item")).orElse(ItemStack.EMPTY);
        }
    }

    @Override
    public int maxRepairCoolDown() {
        return -1;
    }

    @Override
    public void baseTick() {
        CompoundTag tag;
        ItemStack stack;
        this.pitchO = this.getBodyPitch();
        this.setBodyXRot(this.pitch * 0.9f);
        super.baseTick();
        this.setZRot(this.getRoll() * 0.9f);
        this.lastTickSpeed = this.getDeltaMovement().length();
        this.lastTickVerticalSpeed = this.getDeltaMovement().y;
        if (this.collisionCoolDown > 0) {
            --this.collisionCoolDown;
        }
        Player controller = EntityFindUtil.findPlayer(this.level(), (String)this.entityData.get(CONTROLLER));
        if (!this.onGround() && controller != null) {
            stack = controller.getMainHandItem();
            tag = NBTTool.getTag(stack);
            if (!stack.is((Item)ModItems.MONITOR.get()) || !tag.getBoolean("Using")) {
                this.upInputDown = false;
                this.downInputDown = false;
                this.forwardInputDown = false;
                this.backInputDown = false;
                this.leftInputDown = false;
                this.rightInputDown = false;
            }
            if (this.tickCount % 5 == 0) {
                controller.getInventory().items.stream().filter(pStack -> pStack.getItem() == ModItems.MONITOR.get()).forEach(pStack -> {
                    if (tag.getString("LinkedDrone").equals(this.getStringUUID())) {
                        Monitor.getDronePos(pStack, this.position());
                    }
                });
            }
        }
        if (this.isInWater()) {
            this.hurt(new DamageSource((Holder)this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.EXPLOSION), (Entity)controller), 0.25f + (float)(2.0 * this.lastTickSpeed));
        }
        if (this.fire) {
            if ((Integer)this.entityData.get(AMMO) > 0) {
                this.entityData.set(AMMO, (Object)((Integer)this.entityData.get(AMMO) - 1));
                if (controller != null) {
                    this.droneDrop(controller);
                }
            }
            if ((Integer)this.entityData.get(KAMIKAZE_MODE) != 0 && controller != null) {
                stack = controller.getMainHandItem();
                if (stack.is((Item)ModItems.MONITOR.get())) {
                    tag = NBTTool.getTag(stack);
                    Monitor.disLink(tag, controller);
                    NBTTool.saveTag(stack, tag);
                }
                this.hurt(new DamageSource((Holder)this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.EXPLOSION), (Entity)controller), 10000.0f);
            }
            this.fire = false;
        }
        this.refreshDimensions();
    }

    private void droneDrop(@Nullable Player player) {
        if (!this.level().isClientSide()) {
            RgoGrenadeEntity rgoGrenadeEntity = new RgoGrenadeEntity((LivingEntity)player, this.level(), 160);
            rgoGrenadeEntity.setPos(this.getX(), this.getEyeY() - 0.09, this.getZ());
            rgoGrenadeEntity.droneShoot(this);
            this.level().addFreshEntity((Entity)rgoGrenadeEntity);
        }
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() == ModItems.MONITOR.get()) {
            CompoundTag tag = NBTTool.getTag(stack);
            if (!player.isCrouching()) {
                if (!((Boolean)this.entityData.get(LINKED)).booleanValue()) {
                    if (tag.getBoolean("Linked")) {
                        player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.monitor.already_linked").withStyle(ChatFormatting.RED), true);
                        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                    }
                    this.entityData.set(LINKED, (Object)true);
                    this.entityData.set(CONTROLLER, (Object)player.getStringUUID());
                    Monitor.link(tag, this.getStringUUID());
                    NBTTool.saveTag(stack, tag);
                    player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.monitor.linked").withStyle(ChatFormatting.GREEN), true);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.level().playSound(null, serverPlayer.getOnPos(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.PLAYERS, 0.5f, 1.0f);
                    }
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.drone.already_linked").withStyle(ChatFormatting.RED), true);
                }
            } else if (((Boolean)this.entityData.get(LINKED)).booleanValue()) {
                if (!tag.getBoolean("Linked")) {
                    player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.drone.already_linked").withStyle(ChatFormatting.RED), true);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                }
                this.entityData.set(CONTROLLER, (Object)"none");
                this.entityData.set(LINKED, (Object)false);
                Monitor.disLink(tag, player);
                player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.monitor.unlinked").withStyle(ChatFormatting.RED), true);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.level().playSound(null, serverPlayer.getOnPos(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
            }
        } else if (stack.is((Item)ModItems.CROWBAR.get()) && player.isCrouching()) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.DRONE.get()));
            for (int index0 = 0; index0 < (Integer)this.entityData.get(AMMO); ++index0) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.RGO_GRENADE.get()));
            }
            if ((Integer)this.entityData.get(KAMIKAZE_MODE) != 0) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.currentItem);
            }
            player.getInventory().items.stream().filter(stack_ -> stack_.getItem() == ModItems.MONITOR.get()).forEach(itemStack -> {
                CompoundTag tag = NBTTool.getTag(itemStack);
                if (tag.getString("LinkedDrone").equals(this.getStringUUID())) {
                    Monitor.disLink(tag, player);
                }
            });
            if (!this.level().isClientSide()) {
                this.discard();
            }
        } else if (stack.getItem() == ModItems.RGO_GRENADE.get() && (Integer)this.entityData.get(KAMIKAZE_MODE) == 0) {
            if ((Integer)this.entityData.get(AMMO) < 6) {
                this.entityData.set(AMMO, (Object)((Integer)this.entityData.get(AMMO) + 1));
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.BULLET_SUPPLY.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
                }
            }
        } else if (stack.getItem() instanceof MortarShell && (Integer)this.entityData.get(AMMO) == 0 && (Integer)this.entityData.get(KAMIKAZE_MODE) == 0) {
            ItemStack copy = stack.copy();
            copy.setCount(1);
            this.currentItem = copy;
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            this.entityData.set(KAMIKAZE_MODE, (Object)1);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.BULLET_SUPPLY.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        } else if (stack.getItem() == ModItems.C4_BOMB.get() && (Integer)this.entityData.get(AMMO) == 0 && (Integer)this.entityData.get(KAMIKAZE_MODE) == 0) {
            this.currentItem = new ItemStack((ItemLike)stack.getItem(), 1);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            this.entityData.set(KAMIKAZE_MODE, (Object)2);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.BULLET_SUPPLY.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        } else if (stack.getItem() == ModItems.ROCKET.get() && (Integer)this.entityData.get(AMMO) == 0 && (Integer)this.entityData.get(KAMIKAZE_MODE) == 0) {
            this.currentItem = new ItemStack((ItemLike)stack.getItem(), 1);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            this.entityData.set(KAMIKAZE_MODE, (Object)3);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.BULLET_SUPPLY.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    @Override
    public void travel() {
        if (!this.onGround()) {
            if (this.rightInputDown) {
                ++this.holdTickX;
                this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() - 0.3f * (float)Math.min((int)this.holdTickX, (int)5)));
            } else if (this.leftInputDown) {
                ++this.holdTickX;
                this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() + 0.3f * (float)Math.min((int)this.holdTickX, (int)5)));
            } else {
                this.holdTickX = 0;
            }
            if (this.forwardInputDown) {
                ++this.holdTickZ;
                this.entityData.set(DELTA_X_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_X_ROT)).floatValue() - 0.3f * (float)Math.min((int)this.holdTickZ, (int)5)));
            } else if (this.backInputDown) {
                ++this.holdTickZ;
                this.entityData.set(DELTA_X_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_X_ROT)).floatValue() + 0.3f * (float)Math.min((int)this.holdTickZ, (int)5)));
            } else {
                this.holdTickZ = 0;
            }
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.97, 0.94, 0.97));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.8, 1.0, 0.8));
            this.setZRot(this.roll * 0.7f);
            this.setXRot(this.getXRot() * 0.7f);
            this.setBodyXRot(this.getBodyPitch() * 0.7f);
        }
        if (this.isInWater() && this.tickCount % 4 == 0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 0.6, 0.6));
            this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, this.getFirstPassenger() == null ? this : this.getFirstPassenger()), 26.0f + (float)(60.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
        }
        boolean up = this.upInputDown;
        boolean down = this.downInputDown;
        if (up) {
            ++this.holdTickY;
            this.entityData.set(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.entityData.get(POWER)).floatValue() + 0.01f * (float)Math.min((int)this.holdTickY, (int)5)), (float)0.2f)));
        } else if (down) {
            ++this.holdTickY;
            this.entityData.set(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.entityData.get(POWER)).floatValue() - 0.02f * (float)Math.min((int)this.holdTickY, (int)5)), (float)(this.onGround() ? 0.0f : 0.01f))));
        } else {
            this.holdTickY = 0;
        }
        if (!up && !down) {
            if (this.getDeltaMovement().y() < 0.0) {
                this.entityData.set(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.entityData.get(POWER)).floatValue() + 0.01f), (float)0.4f)));
            } else {
                this.entityData.set(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.entityData.get(POWER)).floatValue() - 0.01f), (float)(this.onGround() ? 0.0f : 0.01f))));
            }
        }
        this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() * 0.99f));
        this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() * 0.7f));
        this.entityData.set(DELTA_X_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_X_ROT)).floatValue() * 0.7f));
        this.setZRot(Mth.clamp((float)(this.getRoll() - ((Float)this.entityData.get(DELTA_ROT)).floatValue()), (float)-30.0f, (float)30.0f));
        this.setBodyXRot(Mth.clamp((float)(this.getBodyPitch() - ((Float)this.entityData.get(DELTA_X_ROT)).floatValue()), (float)-30.0f, (float)30.0f));
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(((Float)this.entityData.get(POWER)).floatValue() * 0.6f), 0.0));
        Vector3f direction = this.getRightDirection().mul(((Float)this.entityData.get(DELTA_ROT)).floatValue());
        this.setDeltaMovement(this.getDeltaMovement().add(new Vec3((double)direction.x, (double)direction.y, (double)direction.z).scale(0.03)));
        Vector3f directionZ = this.getForwardDirection().mul(-((Float)this.entityData.get(DELTA_X_ROT)).floatValue());
        this.setDeltaMovement(this.getDeltaMovement().add(new Vec3((double)directionZ.x, (double)directionZ.y, (double)directionZ.z).scale(0.03)));
        Player controller = EntityFindUtil.findPlayer(this.level(), (String)this.entityData.get(CONTROLLER));
        if (controller != null) {
            ItemStack stack = controller.getMainHandItem();
            CompoundTag tag = NBTTool.getTag(stack);
            if (stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using")) {
                this.setYRot(this.getYRot() + 0.5f * ((Float)this.entityData.get(MOUSE_SPEED_X)).floatValue());
                this.setXRot(Mth.clamp((float)(this.getXRot() + 0.5f * ((Float)this.entityData.get(MOUSE_SPEED_Y)).floatValue()), (float)-10.0f, (float)90.0f));
            }
        }
        float f = 0.7f;
        AABB aabb = AABB.ofSize((Vec3)this.getEyePosition(), (double)f, (double)0.3, (double)f);
        Level level = this.level();
        Vec3 center = new Vec3(this.getX(), this.getY(), this.getZ());
        for (Entity target : level.getEntitiesOfClass(Entity.class, aabb, e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList()) {
            if (this == target || target == null || target instanceof ItemEntity || target instanceof Projectile || target instanceof ProjectileEntity || target instanceof LaserEntity || target instanceof DecoyEntity || target instanceof AreaEffectCloud || target instanceof C4Entity) continue;
            this.hitEntityCrash(controller, target);
        }
    }

    public void hitEntityCrash(Player player, Entity target) {
        if (this.lastTickSpeed > 0.12) {
            if ((Integer)this.entityData.get(KAMIKAZE_MODE) != 0 && 20.0 * this.lastTickSpeed > (double)this.getHealth()) {
                if ((Integer)this.entityData.get(KAMIKAZE_MODE) == 1) {
                    MortarShellEntity mortarShell = new MortarShellEntity((LivingEntity)player, this.level());
                    target.hurt(ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), (Entity)mortarShell, (Entity)player), (float)((Integer)ExplosionConfig.DRONE_KAMIKAZE_HIT_DAMAGE.get()).intValue());
                    target.invulnerableTime = 0;
                } else if ((Integer)this.entityData.get(KAMIKAZE_MODE) == 2) {
                    C4Entity c4 = new C4Entity((LivingEntity)player, this.level());
                    target.hurt(ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), c4, (Entity)player), (float)((Integer)ExplosionConfig.DRONE_KAMIKAZE_HIT_DAMAGE_C4.get()).intValue());
                    target.invulnerableTime = 0;
                } else if ((Integer)this.entityData.get(KAMIKAZE_MODE) == 3) {
                    RpgRocketEntity rpg = new RpgRocketEntity((LivingEntity)player, this.level());
                    target.hurt(ModDamageTypes.causeCannonFireDamage(this.level().registryAccess(), (Entity)rpg, (Entity)player), (float)((Integer)ExplosionConfig.DRONE_KAMIKAZE_HIT_DAMAGE_RPG.get()).intValue());
                    target.invulnerableTime = 0;
                }
                if (player != null && player.getMainHandItem().is((Item)ModItems.MONITOR.get())) {
                    ItemStack stack = player.getMainHandItem();
                    CompoundTag tag = NBTTool.getTag(stack);
                    Monitor.disLink(tag, player);
                    NBTTool.saveTag(stack, tag);
                }
            }
            target.hurt(ModDamageTypes.causeDroneHitDamage(this.level().registryAccess(), this, (Entity)player), (float)(5.0 * this.lastTickSpeed));
            this.hurt(new DamageSource((Holder)this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.EXPLOSION), (Entity)Objects.requireNonNullElse(player, this)), (float)((double)((Integer)this.entityData.get(KAMIKAZE_MODE) != 0 ? 20 : 4) * this.lastTickSpeed));
        }
    }

    @Override
    public boolean engineRunning() {
        return !this.onGround();
    }

    @Override
    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.DRONE_SOUND.get();
    }

    @Override
    public float getEngineSoundVolume() {
        return ((Float)this.entityData.get(POWER)).floatValue() * 2.0f;
    }

    @Override
    public void move(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        super.move(movementType, movement);
        Player controller = EntityFindUtil.findPlayer(this.level(), (String)this.entityData.get(CONTROLLER));
        if (this.lastTickSpeed < 0.2 || this.collisionCoolDown > 0) {
            return;
        }
        if (this.verticalCollision && Mth.abs((float)((float)this.lastTickVerticalSpeed)) > 1.0f) {
            this.hurt(ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this, controller == null ? this : controller), (float)(20.0 * ((double)(Mth.abs((float)((float)this.lastTickVerticalSpeed)) - 1.0f) * (this.lastTickSpeed - 0.2) * (this.lastTickSpeed - 0.2))));
            this.collisionCoolDown = 4;
        }
        if (this.horizontalCollision) {
            this.hurt(ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this, controller == null ? this : controller), (float)(10.0 * ((this.lastTickSpeed - 0.2) * (this.lastTickSpeed - 0.2))));
            this.collisionCoolDown = 4;
        }
    }

    @Override
    public void destroy() {
        UUID uuid;
        Player controller = EntityFindUtil.findPlayer(this.level(), (String)this.entityData.get(CONTROLLER));
        if (controller != null && controller.getMainHandItem().is((Item)ModItems.MONITOR.get())) {
            ItemStack item = controller.getMainHandItem();
            CompoundTag tag = NBTTool.getTag(item);
            Monitor.disLink(tag, controller);
            NBTTool.saveTag(item, tag);
        }
        if (this.level() instanceof ServerLevel) {
            this.level().explode(null, this.getX(), this.getY(), this.getZ(), 0.0f, Level.ExplosionInteraction.NONE);
        }
        if ((Integer)this.entityData.get(KAMIKAZE_MODE) != 0) {
            this.kamikazeExplosion((Integer)this.entityData.get(KAMIKAZE_MODE));
        }
        if (this.level() instanceof ServerLevel) {
            int count = (Integer)this.entityData.get(AMMO);
            for (int i = 0; i < count; ++i) {
                this.droneDrop(controller);
            }
        }
        String id = (String)this.entityData.get(CONTROLLER);
        try {
            uuid = UUID.fromString(id);
        }
        catch (IllegalArgumentException ignored) {
            this.discard();
            return;
        }
        Player player = this.level().getPlayerByUUID(uuid);
        if (player != null) {
            player.getInventory().items.stream().filter(stack -> stack.getItem() == ModItems.MONITOR.get()).forEach(stack -> {
                CompoundTag tag = NBTTool.getTag(stack);
                if (tag.getString("LinkedDrone").equals(this.getStringUUID())) {
                    Monitor.disLink(tag, player);
                    NBTTool.saveTag(stack, tag);
                }
            });
        }
        super.destroy();
    }

    private void kamikazeExplosion(int mode) {
        CustomExplosion explosion;
        Entity attacker = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(LAST_ATTACKER_UUID));
        Player controller = EntityFindUtil.findPlayer(this.level(), (String)this.entityData.get(CONTROLLER));
        MortarShellEntity mortarShell = new MortarShellEntity((LivingEntity)controller, this.level());
        assert (controller != null);
        C4Entity c4 = new C4Entity((LivingEntity)controller, this.level());
        RpgRocketEntity rpg = new RpgRocketEntity((LivingEntity)controller, this.level(), ((Integer)ExplosionConfig.RPG_EXPLOSION_DAMAGE.get()).intValue());
        switch (mode) {
            case 1: {
                CustomExplosion customExplosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), (Entity)mortarShell, attacker), ((Integer)ExplosionConfig.DRONE_KAMIKAZE_EXPLOSION_DAMAGE.get()).intValue(), this.getX(), this.getY(), this.getZ(), ((Integer)ExplosionConfig.DRONE_KAMIKAZE_EXPLOSION_RADIUS.get()).intValue(), (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
                break;
            }
            case 2: {
                CustomExplosion customExplosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), c4, attacker), ((Integer)ExplosionConfig.C4_EXPLOSION_DAMAGE.get()).intValue(), this.getX(), this.getY(), this.getZ(), ((Integer)ExplosionConfig.C4_EXPLOSION_RADIUS.get()).intValue(), (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
                break;
            }
            case 3: {
                CustomExplosion customExplosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), (Entity)rpg, attacker), ((Integer)ExplosionConfig.RPG_EXPLOSION_DAMAGE.get()).intValue(), this.getX(), this.getY(), this.getZ(), ((Integer)ExplosionConfig.RPG_EXPLOSION_RADIUS.get()).intValue(), (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
                break;
            }
            default: {
                CustomExplosion customExplosion = explosion = null;
            }
        }
        if (explosion == null) {
            return;
        }
        explosion.explode();
        EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
        explosion.finalizeExplosion(false);
        if (mode == 1) {
            ParticleTool.spawnMediumExplosionParticles(this.level(), this.position());
            if (this.currentItem.getItem() instanceof MortarShell) {
                this.createAreaCloud((PotionContents)this.currentItem.get(DataComponents.POTION_CONTENTS), this.level(), (Integer)ExplosionConfig.DRONE_KAMIKAZE_EXPLOSION_DAMAGE.get(), ((Integer)ExplosionConfig.DRONE_KAMIKAZE_EXPLOSION_RADIUS.get()).intValue());
            }
        }
        if (mode == 2 || mode == 3) {
            ParticleTool.spawnHugeExplosionParticles(this.level(), this.position());
        }
    }

    private void createAreaCloud(PotionContents potion, Level level, int duration, float radius) {
        if (potion == null || potion.potion().map(p -> p.value() == Potions.WATER.value()).orElse(false).booleanValue()) {
            return;
        }
        AreaEffectCloud cloud = new AreaEffectCloud(level, this.getX() + 0.75 * this.getDeltaMovement().x, this.getY() + 0.5 * (double)this.getBbHeight() + 0.75 * this.getDeltaMovement().y, this.getZ() + 0.75 * this.getDeltaMovement().z);
        for (MobEffectInstance effect : (List)potion.potion().map(p -> ((Potion)p.value()).getEffects()).orElse(new ArrayList())) {
            cloud.addEffect(effect);
        }
        cloud.setDuration(duration);
        cloud.setRadius(radius);
        Player controller = EntityFindUtil.findPlayer(this.level(), (String)this.entityData.get(CONTROLLER));
        if (controller != null) {
            cloud.setOwner((LivingEntity)controller);
        }
        level.addFreshEntity((Entity)cloud);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean canCrushEntities() {
        return false;
    }
}

