/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.entity.projectile.MortarShellEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.FiringParameters;
import com.atsuishio.superbwarfare.item.common.ammo.MortarShell;
import com.atsuishio.superbwarfare.tools.RangeTool;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MortarEntity
extends VehicleEntity
implements GeoEntity {
    public static final EntityDataAccessor<Integer> FIRE_TIME = SynchedEntityData.defineId(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> PITCH = SynchedEntityData.defineId(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> YAW = SynchedEntityData.defineId(MortarEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public MortarEntity(EntityType<MortarEntity> type, Level level) {
        super(type, level);
    }

    public MortarEntity(Level level, float yRot) {
        super((EntityType)ModEntities.MORTAR.get(), level);
        this.setYRot(yRot);
        this.entityData.set(YAW, (Object)Float.valueOf(yRot));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FIRE_TIME, (Object)0).define(PITCH, (Object)Float.valueOf(-70.0f)).define(YAW, (Object)Float.valueOf(this.getYRot()));
    }

    @Override
    public boolean canBeCollidedWith() {
        return false;
    }

    @Override
    public boolean isPickable() {
        return super.isPickable();
    }

    public double getEyeY() {
        return 0.2f;
    }

    @Override
    public boolean sendFireStarParticleOnHurt() {
        return false;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("Pitch", ((Float)this.entityData.get(PITCH)).floatValue());
        compound.putFloat("Yaw", ((Float)this.entityData.get(YAW)).floatValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Pitch")) {
            this.entityData.set(PITCH, (Object)Float.valueOf(compound.getFloat("Pitch")));
        }
        if (compound.contains("Yaw")) {
            this.entityData.set(YAW, (Object)Float.valueOf(compound.getFloat("Yaw")));
        }
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof MortarShell) {
            MortarShell shell = (MortarShell)item;
            if (!player.isShiftKeyDown() && (Integer)this.entityData.get(FIRE_TIME) == 0) {
                this.entityData.set(FIRE_TIME, (Object)25);
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                if (!this.level().isClientSide()) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSounds.MORTAR_LOAD.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSounds.MORTAR_FIRE.get(), SoundSource.PLAYERS, 8.0f, 1.0f);
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSounds.MORTAR_DISTANT.get(), SoundSource.PLAYERS, 32.0f, 1.0f);
                }
                Mod.queueServerWork(20, () -> {
                    Level level = this.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel server = (ServerLevel)level;
                        MortarShellEntity entityToSpawn = shell.createShell((LivingEntity)player, level, stack);
                        entityToSpawn.setPos(this.getX(), this.getY() + this.getEyeY(), this.getZ());
                        entityToSpawn.shoot(this.getLookAngle().x, this.getLookAngle().y, this.getLookAngle().z, 11.4f, 0.1f);
                        level.addFreshEntity((Entity)entityToSpawn);
                        server.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getX() + 3.0 * this.getLookAngle().x, this.getY() + 0.1 + 3.0 * this.getLookAngle().y, this.getZ() + 3.0 * this.getLookAngle().z, 8, 0.4, 0.4, 0.4, 0.007);
                        server.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getX(), this.getY(), this.getZ(), 50, 2.0, 0.02, 2.0, 5.0E-4);
                    }
                });
            }
        }
        if (player.getMainHandItem().getItem() == ModItems.FIRING_PARAMETERS.get()) {
            if (this.setTarget(player.getMainHandItem())) {
                player.swing(InteractionHand.MAIN_HAND);
                return InteractionResult.SUCCESS;
            }
            player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.mortar.warn").withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        if (player.getOffhandItem().getItem() == ModItems.FIRING_PARAMETERS.get()) {
            if (this.setTarget(player.getOffhandItem())) {
                player.swing(InteractionHand.OFF_HAND);
                return InteractionResult.SUCCESS;
            }
            player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.mortar.warn").withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        if (player.isShiftKeyDown()) {
            if (stack.getItem() == ModItems.CROWBAR.get()) {
                this.discard();
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.MORTAR_DEPLOYER.get()));
                return InteractionResult.SUCCESS;
            }
            this.entityData.set(YAW, (Object)Float.valueOf(player.getYRot()));
        }
        return InteractionResult.SUCCESS;
    }

    public boolean setTarget(ItemStack stack) {
        FiringParameters.Parameters parameters = (FiringParameters.Parameters)stack.get(ModDataComponents.FIRING_PARAMETERS);
        if (parameters == null) {
            return false;
        }
        BlockPos pos = parameters.pos();
        double targetX = pos.getX();
        double targetY = pos.getY();
        double targetZ = pos.getZ();
        boolean isDepressed = parameters.isDepressed();
        if (!RangeTool.canReach(11.4, 0.146, this.getEyePosition(), new Vec3(targetX, targetY, targetZ), 20.0, 89.0, isDepressed)) {
            return false;
        }
        this.look(new Vec3(targetX, targetY, targetZ));
        this.entityData.set(PITCH, (Object)Float.valueOf((float)(-RangeTool.calculateAngle(11.4, 0.146, this.getEyePosition(), new Vec3(targetX, targetY, targetZ), parameters.isDepressed()))));
        return true;
    }

    private void look(Vec3 pTarget) {
        Vec3 vec3 = EntityAnchorArgument.Anchor.EYES.apply((Entity)this);
        double d0 = (pTarget.x - vec3.x) * 0.2;
        double d2 = (pTarget.z - vec3.z) * 0.2;
        this.entityData.set(YAW, (Object)Float.valueOf(Mth.wrapDegrees((float)((float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f))));
    }

    @NotNull
    public Vec3 getDeltaMovement() {
        return new Vec3(0.0, Math.min((double)super.getDeltaMovement().y, (double)0.0), 0.0);
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if ((Integer)this.entityData.get(FIRE_TIME) > 0) {
            this.entityData.set(FIRE_TIME, (Object)((Integer)this.entityData.get(FIRE_TIME) - 1));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.onGround()) {
            this.setDeltaMovement(Vec3.ZERO);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
    }

    @Override
    public void handleClientSync() {
        if (this.isControlledByLocalInstance()) {
            this.interpolationSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedYaw = Mth.wrapDegrees((double)(this.serverYRot - (double)this.getYRot()));
        this.setYRot(this.getYRot() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.setXRot(this.getXRot() + (float)(this.serverXRot - (double)this.getXRot()) / (float)this.interpolationSteps);
        this.setRot(this.getYRot(), this.getXRot());
    }

    @Override
    public void lerpTo(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.serverYRot = yaw;
        this.serverXRot = pitch;
        this.interpolationSteps = 10;
    }

    @Override
    public void travel() {
        float diffY = Mth.wrapDegrees((float)(((Float)this.entityData.get(YAW)).floatValue() - this.getYRot()));
        float diffX = Mth.wrapDegrees((float)(((Float)this.entityData.get(PITCH)).floatValue() - this.getXRot()));
        this.setYRot(this.getYRot() + Mth.clamp((float)(0.5f * diffY), (float)-20.0f, (float)20.0f));
        this.setXRot(Mth.clamp((float)(this.getXRot() + Mth.clamp((float)(0.5f * diffX), (float)-20.0f, (float)20.0f)), (float)-89.0f, (float)-20.0f));
    }

    private PlayState movementPredicate(AnimationState<MortarEntity> event) {
        if ((Integer)this.entityData.get(FIRE_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mortar.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mortar.idle"));
    }

    @Override
    public void destroy() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            double x = this.getX();
            double y = this.getY();
            double z = this.getZ();
            level2.explode(null, x, y, z, 0.0f, Level.ExplosionInteraction.NONE);
            ItemEntity mortar = new ItemEntity((Level)level2, x, y + 1.0, z, new ItemStack((ItemLike)ModItems.MORTAR_DEPLOYER.get()));
            mortar.setPickUpDelay(10);
            level2.addFreshEntity((Entity)mortar);
        }
        super.destroy();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

