/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.projectile.AerialBombEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.LaserWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.mojang.math.Axis;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PrismTankEntity
extends ContainerMobileVehicleEntity
implements GeoEntity,
LandArmorEntity,
WeaponVehicleEntity {
    public static final EntityDataAccessor<Integer> CANNON_FIRE_TIME = SynchedEntityData.defineId(PrismTankEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> LASER_LENGTH = SynchedEntityData.defineId(PrismTankEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> LASER_SCALE = SynchedEntityData.defineId(PrismTankEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> LASER_SCALE_O = SynchedEntityData.defineId(PrismTankEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public PrismTankEntity(EntityType<PrismTankEntity> type, Level world) {
        super(type, world);
        this.noCulling = true;
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new LaserWeapon().sound((SoundEvent)ModSounds.INTO_MISSILE.get()).sound1p((SoundEvent)ModSounds.PRISM_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.PRISM_FIRE_3P.get()), new LaserWeapon().sound((SoundEvent)ModSounds.INTO_CANNON.get())}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(4.0 + ClientMouseHandler.custom3pDistanceLerp, 1.0, 1.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CANNON_FIRE_TIME, (Object)0).define(LASER_LENGTH, (Object)Float.valueOf(0.0f)).define(LASER_SCALE, (Object)Float.valueOf(0.0f)).define(LASER_SCALE_O, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.4f) * damage.floatValue())).custom((source, damage) -> {
            if (source.getDirectEntity() instanceof AerialBombEntity) {
                return Float.valueOf(2.0f * damage.floatValue());
            }
            return damage;
        });
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.playSound((SoundEvent)ModSounds.WHEEL_STEP.get(), (float)(this.getDeltaMovement().length() * 0.15), this.random.nextFloat() * 0.15f + 1.05f);
    }

    @Override
    public double getSubmergedHeight(Entity entity) {
        return super.getSubmergedHeight(entity);
    }

    @Override
    public void baseTick() {
        Level level;
        this.entityData.set(LASER_SCALE_O, (Object)((Float)this.entityData.get(LASER_SCALE)));
        super.baseTick();
        if (this.getLeftTrack() < 0.0f) {
            this.setLeftTrack(100.0f);
        }
        if (this.getLeftTrack() > 100.0f) {
            this.setLeftTrack(0.0f);
        }
        if (this.getRightTrack() < 0.0f) {
            this.setRightTrack(100.0f);
        }
        if (this.getRightTrack() > 100.0f) {
            this.setRightTrack(0.0f);
        }
        if (((Float)this.entityData.get(LASER_SCALE)).floatValue() > 0.0f) {
            this.entityData.set(LASER_SCALE, (Object)Float.valueOf(Math.max((float)(((Float)this.entityData.get(LASER_SCALE)).floatValue() - 0.1f), (float)0.0f)));
            this.entityData.set(LASER_SCALE, (Object)Float.valueOf(((Float)this.entityData.get(LASER_SCALE)).floatValue() * 0.9f));
        }
        if (((Float)this.entityData.get(LASER_SCALE)).floatValue() == 0.0f) {
            this.entityData.set(LASER_LENGTH, (Object)Float.valueOf(0.0f));
        }
        if (this.onGround()) {
            float f0 = 0.54f + 0.25f * Mth.abs((float)(90.0f - (float)PrismTankEntity.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f)))) / 90.0f;
            this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).normalize().scale(0.05 * this.getDeltaMovement().dot(this.getViewVector(1.0f)))));
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)f0, 0.99, (double)f0));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.99, 0.99, 0.99));
        }
        if (this.isInWater()) {
            float f1 = (float)((double)0.7f - (double)0.04f * Math.min((double)this.getSubmergedHeight(this), (double)this.getBbHeight()) + (double)(0.08f * Mth.abs((float)(90.0f - (float)PrismTankEntity.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f)))) / 90.0f));
            this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).normalize().scale(0.04 * this.getDeltaMovement().dot(this.getViewVector(1.0f)))));
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)f1, 0.85, (double)f1));
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isInWater() && this.getDeltaMovement().length() > 0.1) {
                ParticleTool.sendParticle(serverLevel, ParticleTypes.CLOUD, this.getX() + 0.5 * this.getDeltaMovement().x, this.getY() + this.getSubmergedHeight(this) - 0.2, this.getZ() + 0.5 * this.getDeltaMovement().z, (int)(2.0 + 4.0 * this.getDeltaMovement().length()), 0.65, 0.0, 0.65, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.BUBBLE_COLUMN_UP, this.getX() + 0.5 * this.getDeltaMovement().x, this.getY() + this.getSubmergedHeight(this) - 0.2, this.getZ() + 0.5 * this.getDeltaMovement().z, (int)(2.0 + 10.0 * this.getDeltaMovement().length()), 0.65, 0.0, 0.65, 0.0, true);
            }
        }
        this.turretAngle(15.0f, 10.0f);
        this.terrainCompact(4.6375f, 5.171875f);
        this.inertiaRotate(1.0f);
        this.releaseSmokeDecoy(this.getTurretVector(1.0f));
        level = this.getFirstPassenger();
        if (level instanceof Player) {
            Player player = (Player)level;
            if (this.fireInputDown && this.getWeaponIndex(0) == 1 && this.getEnergy() > (Integer)VehicleConfig.PRISM_TANK_SHOOT_COST_MODE_2.get() && !this.cannotFire) {
                this.vehicleShoot(player, 0);
            }
        }
        this.lowHealthWarning();
        this.refreshDimensions();
    }

    @Override
    public void terrainCompact(float w, float l) {
        if (this.onGround()) {
            float x1 = this.terrainCompactTrackValue(w, l)[0];
            float x2 = this.terrainCompactTrackValue(w, l - 1.0f)[0];
            float x3 = this.terrainCompactTrackValue(w, l - 2.0f)[0];
            float x4 = this.terrainCompactTrackValue(w, l - 3.0f)[0];
            float x5 = this.terrainCompactTrackValue(w, l - 4.0f)[0];
            float x6 = this.terrainCompactTrackValue(w, l - 5.0f)[0];
            List<Float> numbersX = Arrays.asList(Float.valueOf(x1), Float.valueOf(x2), Float.valueOf(x3), Float.valueOf(x4), Float.valueOf(x5), Float.valueOf(x6));
            float maxX = Collections.max(numbersX).floatValue();
            float minX = Collections.min(numbersX).floatValue();
            float z1 = this.terrainCompactTrackValue(w, l)[1];
            float z2 = this.terrainCompactTrackValue(w, l - 1.0f)[1];
            float z3 = this.terrainCompactTrackValue(w, l - 2.0f)[1];
            float z4 = this.terrainCompactTrackValue(w, l - 3.0f)[1];
            float z5 = this.terrainCompactTrackValue(w, l - 4.0f)[1];
            float z6 = this.terrainCompactTrackValue(w, l - 5.0f)[1];
            List<Float> numbersZ = Arrays.asList(Float.valueOf(z1), Float.valueOf(z2), Float.valueOf(z3), Float.valueOf(z4), Float.valueOf(z5), Float.valueOf(z6));
            float maxZ = Collections.max(numbersZ).floatValue();
            float minZ = Collections.min(numbersZ).floatValue();
            float diffX = Math.clamp((float)-15.0f, (float)15.0f, (float)((minX + maxX) / 2.0f));
            this.setXRot(Mth.clamp((float)(this.getXRot() + 0.15f * diffX), (float)-45.0f, (float)45.0f));
            float diffZ = Math.clamp((float)-15.0f, (float)15.0f, (float)(minZ + maxZ));
            this.setZRot(Mth.clamp((float)(this.getRoll() + 0.15f * diffZ), (float)-45.0f, (float)45.0f));
        } else if (this.isInWater()) {
            this.setXRot(this.getXRot() * 0.9f);
            this.setZRot(this.getRoll() * 0.9f);
        }
    }

    @Override
    public boolean canCollideHardBlock() {
        return this.getDeltaMovement().horizontalDistance() > 0.07 || (double)Mth.abs((float)((Float)this.entityData.get(POWER)).floatValue()) > 0.12;
    }

    @Override
    public void move(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        super.move(movementType, movement);
        if (this.isInWater() && this.horizontalCollision) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.07, 0.0));
        }
    }

    @Override
    public void vehicleShoot(Player player, int type) {
        Matrix4f transform = this.getBarrelTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.5f, 0.0f);
        Vec3 root = new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        if (this.getWeaponIndex(0) == 0) {
            float dis;
            if (this.cannotFire) {
                return;
            }
            if (!this.canConsume((Integer)VehicleConfig.PRISM_TANK_SHOOT_COST_MODE_1.get())) {
                player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.annihilator.energy_not_enough").withStyle(ChatFormatting.RED), true);
                return;
            }
            Level level = player.level();
            if (level instanceof ServerLevel) {
                if (!player.level().isClientSide) {
                    this.playShootSound3p(player, 0, 5, 5, 5);
                }
                this.entityData.set(HEAT, (Object)((Integer)this.entityData.get(HEAT) + 55));
                this.consumeEnergy((Integer)VehicleConfig.PRISM_TANK_SHOOT_COST_MODE_1.get());
                Vec3 center = new Vec3(this.getX(), this.getEyeY(), this.getZ());
                for (Entity target : level.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate(5.0), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList()) {
                    if (!(target instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)target;
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShakeClientMessage(8.0, 4.0, 7.0, this.getX(), this.getEyeY(), this.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if ((dis = this.laserLengthEntity(root)) < this.laserLength(root)) {
                this.entityData.set(LASER_LENGTH, (Object)Float.valueOf(dis));
            } else {
                this.entityData.set(LASER_LENGTH, (Object)Float.valueOf(this.laserLength(root)));
                this.hitBlock(root);
            }
            this.entityData.set(LASER_SCALE, (Object)Float.valueOf(3.0f));
        } else if (this.getWeaponIndex(0) == 1) {
            float dis;
            if (this.cannotFire) {
                return;
            }
            if (!this.canConsume((Integer)VehicleConfig.PRISM_TANK_SHOOT_COST_MODE_2.get())) {
                player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.annihilator.energy_not_enough").withStyle(ChatFormatting.RED), true);
                return;
            }
            Level level = player.level();
            float pitch = (Integer)this.entityData.get(HEAT) <= 60 ? 1.1f : (float)((double)1.1f - 0.011 * (double)Math.abs((int)(60 - (Integer)this.entityData.get(HEAT))));
            SoundTool.playLocalSound(player, (SoundEvent)ModSounds.PRISM_FIRE_1P_2.get(), 1.0f, pitch);
            if (level instanceof ServerLevel) {
                if (!player.level().isClientSide) {
                    this.playShootSound3p(player, 0, 4, 4, 4);
                }
                this.entityData.set(HEAT, (Object)((Integer)this.entityData.get(HEAT) + 2));
                this.consumeEnergy((Integer)VehicleConfig.PRISM_TANK_SHOOT_COST_MODE_2.get());
            }
            if ((dis = this.laserLengthEntity(root)) < this.laserLength(root)) {
                this.entityData.set(LASER_LENGTH, (Object)Float.valueOf(dis));
            } else {
                this.entityData.set(LASER_LENGTH, (Object)Float.valueOf(this.laserLength(root)));
                this.hitBlock(root);
            }
            this.entityData.set(LASER_SCALE, (Object)Float.valueOf(1.0f));
        }
    }

    private void hitBlock(Vec3 pos) {
        if (this.level() instanceof ServerLevel) {
            Level level;
            BlockHitResult result = this.level().clip(new ClipContext(pos, pos.add(this.getBarrelVector(1.0f).scale(512.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            Vec3 hitPos = result.getLocation();
            if (this.getFirstPassenger() != null && (level = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.getWeaponIndex(0) == 0) {
                    this.findNearEntity(hitPos);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.END_ROD, hitPos.x, hitPos.y, hitPos.z, 24, 0.0, 0.0, 0.0, 0.2, true);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.LAVA, hitPos.x, hitPos.y, hitPos.z, 8, 0.0, 0.0, 0.0, 0.4, true);
                } else {
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.END_ROD, hitPos.x, hitPos.y, hitPos.z, 4, 0.0, 0.0, 0.0, 0.05, true);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.LAVA, hitPos.x, hitPos.y, hitPos.z, 2, 0.0, 0.0, 0.0, 0.15, true);
                }
            }
        }
    }

    private float laserLength(Vec3 pos) {
        return (float)pos.distanceTo(Vec3.atLowerCornerOf((Vec3i)this.level().clip(new ClipContext(pos, pos.add(this.getBarrelVector(1.0f).scale(512.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getBlockPos()));
    }

    private float laserLengthEntity(Vec3 pos) {
        if (this.level() instanceof ServerLevel) {
            AABB aabb;
            double blockReach;
            double distance = 262144.0;
            HitResult hitResult = this.pickNew(pos, 512.0);
            if (hitResult.getType() != HitResult.Type.MISS && (distance = hitResult.getLocation().distanceToSqr(pos)) > (blockReach = 5.0) * blockReach) {
                Vec3 posB = hitResult.getLocation();
                hitResult = BlockHitResult.miss((Vec3)posB, (Direction)Direction.getNearest((double)pos.x, (double)pos.y, (double)pos.z), (BlockPos)BlockPos.containing((Position)posB));
            }
            Vec3 viewVec = this.getBarrelVector(1.0f);
            Vec3 toVec = pos.add(viewVec.x * 512.0, viewVec.y * 512.0, viewVec.z * 512.0);
            EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)this, (Vec3)pos, (Vec3)toVec, (AABB)(aabb = this.getBoundingBox().expandTowards(viewVec.scale(512.0)).inflate(1.0, 1.0, 1.0)), p -> !p.isSpectator() && p.isAlive() && SeekTool.smokeFilter(p), (double)distance);
            if (entityhitresult != null) {
                Vec3 targetPos = entityhitresult.getLocation();
                double distanceToTarget = pos.distanceToSqr(targetPos);
                if (distanceToTarget > distance || distanceToTarget > 262144.0) {
                    hitResult = BlockHitResult.miss((Vec3)targetPos, (Direction)Direction.getNearest((double)viewVec.x, (double)viewVec.y, (double)viewVec.z), (BlockPos)BlockPos.containing((Position)targetPos));
                } else if (distanceToTarget < distance) {
                    hitResult = entityhitresult;
                }
                if (hitResult.getType() == HitResult.Type.ENTITY) {
                    Level level;
                    Entity passenger = this.getFirstPassenger();
                    Entity target = ((EntityHitResult)hitResult).getEntity();
                    if (passenger != null && (level = this.level()) instanceof ServerLevel) {
                        Entity entity;
                        ServerLevel serverLevel = (ServerLevel)level;
                        target.hurt(ModDamageTypes.causeLaserDamage(this.level().registryAccess(), this, passenger), (float)(this.getWeaponIndex(0) == 0 ? (Integer)VehicleConfig.PRISM_TANK_DAMAGE_MODE_1.get() : (Integer)VehicleConfig.PRISM_TANK_DAMAGE_MODE_2.get()).intValue());
                        Vec3 vec = pos.scale(pos.distanceTo(target.position()));
                        if (this.getWeaponIndex(0) == 0) {
                            this.findNearEntity(target.getEyePosition());
                            ParticleTool.sendParticle(serverLevel, ParticleTypes.END_ROD, vec.x, vec.y, vec.z, 24, 0.0, 0.0, 0.0, 0.2, true);
                            ParticleTool.sendParticle(serverLevel, ParticleTypes.LAVA, vec.x, vec.y, vec.z, 8, 0.0, 0.0, 0.0, 0.4, true);
                        } else {
                            ParticleTool.sendParticle(serverLevel, ParticleTypes.END_ROD, vec.x, vec.y, vec.z, 4, 0.0, 0.0, 0.0, 0.05, true);
                            ParticleTool.sendParticle(serverLevel, ParticleTypes.LAVA, vec.x, vec.y, vec.z, 2, 0.0, 0.0, 0.0, 0.15, true);
                        }
                        if (this.getFirstPassenger() != null && !this.getFirstPassenger().level().isClientSide() && (entity = this.getFirstPassenger()) instanceof ServerPlayer) {
                            ServerPlayer player = (ServerPlayer)entity;
                            Holder holder = Holder.direct((Object)((SoundEvent)ModSounds.INDICATION.get()));
                            player.connection.send((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, player.level().random.nextLong()));
                            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        }
                    }
                    target.invulnerableTime = 1;
                    return (float)pos.distanceTo(target.position());
                }
            }
        }
        return 512.0f;
    }

    public void findNearEntity(Vec3 vec) {
        int aoeDamage = (Integer)VehicleConfig.PRISM_TANK_AOE_DAMAGE.get();
        int range = (Integer)VehicleConfig.PRISM_TANK_AOE_RADIUS.get();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List<Entity> entities = this.seekNearEntities(vec, this.level(), range);
            for (Entity e : entities) {
                Vec3 toVec;
                double dis = vec.distanceTo(e.getEyePosition());
                float i = 0.0f;
                while ((double)i < dis) {
                    toVec = vec.vectorTo(e.getEyePosition()).normalize();
                    Vec3 pos = vec.add(toVec.scale((double)i));
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.END_ROD, pos.x, pos.y, pos.z, 1, 0.0, 0.0, 0.0, 0.0, true);
                    i += 0.2f;
                }
                ParticleTool.sendParticle(serverLevel, ParticleTypes.LAVA, e.getX(), e.getEyeY(), e.getZ(), 4, 0.0, 0.0, 0.0, 0.15, true);
                e.hurt(ModDamageTypes.causeLaserDamage(this.level().registryAccess(), this, this.getFirstPassenger()), (float)((double)aoeDamage - Mth.clamp((double)(dis / (double)range), (double)0.0, (double)0.75) * (double)aoeDamage));
                if (this.getFirstPassenger() == null || this.getFirstPassenger().level().isClientSide() || !((toVec = this.getFirstPassenger()) instanceof ServerPlayer)) continue;
                ServerPlayer player = (ServerPlayer)toVec;
                Holder holder = Holder.direct((Object)((SoundEvent)ModSounds.INDICATION.get()));
                player.connection.send((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, player.level().random.nextLong()));
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public List<Entity> seekNearEntities(Vec3 vec3, Level level, double seekRange) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).getAll().spliterator(), false).filter(e -> e.position().distanceTo(vec3) <= seekRange && e != this && e.getVehicle() != this && SeekTool.baseFilter(e) && SeekTool.smokeFilter(e) && e.getVehicle() == null && (!e.isAlliedTo((Entity)this) || e.getTeam() == null || e.getTeam().getName().equals("TDM"))).toList();
    }

    public HitResult pickNew(Vec3 pos, double pHitDistance) {
        Vec3 vec31 = this.getBarrelVector(1.0f);
        Vec3 vec32 = pos.add(vec31.x * pHitDistance, vec31.y * pHitDistance, vec31.z * pHitDistance);
        return this.level().clip(new ClipContext(pos, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
    }

    @Override
    public void travel() {
        Entity passenger0 = this.getFirstPassenger();
        if (this.getEnergy() <= 0) {
            return;
        }
        if (passenger0 == null) {
            this.leftInputDown = false;
            this.rightInputDown = false;
            this.forwardInputDown = false;
            this.backInputDown = false;
            this.entityData.set(POWER, (Object)Float.valueOf(0.0f));
        }
        if (this.forwardInputDown) {
            this.entityData.set(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.entityData.get(POWER)).floatValue() + (((Float)this.entityData.get(POWER)).floatValue() < 0.0f ? 0.004f : 0.0024f)), (float)0.24f)));
        }
        if (this.backInputDown) {
            this.entityData.set(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.entityData.get(POWER)).floatValue() - (((Float)this.entityData.get(POWER)).floatValue() > 0.0f ? 0.004f : 0.0024f)), (float)-0.16f)));
            if (this.rightInputDown) {
                this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() + 0.1f));
            } else if (this.leftInputDown) {
                this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() - 0.1f));
            }
        } else if (this.rightInputDown) {
            this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() - 0.1f));
        } else if (this.leftInputDown) {
            this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() + 0.1f));
        }
        if (this.forwardInputDown || this.backInputDown) {
            this.consumeEnergy((Integer)VehicleConfig.PRISM_TANK_ENERGY_COST.get());
        }
        this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() * (this.upInputDown ? 0.5f : (this.rightInputDown || this.leftInputDown ? 0.947f : 0.96f))));
        this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() * (float)Math.max((double)((double)0.76f - (double)0.1f * this.getDeltaMovement().horizontalDistance()), (double)0.3)));
        double s0 = this.getDeltaMovement().dot(this.getViewVector(1.0f));
        this.setLeftWheelRot((float)((double)this.getLeftWheelRot() - 1.25 * s0 + (double)Mth.clamp((float)(0.75f * ((Float)this.entityData.get(DELTA_ROT)).floatValue()), (float)-5.0f, (float)5.0f)));
        this.setRightWheelRot((float)((double)this.getRightWheelRot() - 1.25 * s0 - (double)Mth.clamp((float)(0.75f * ((Float)this.entityData.get(DELTA_ROT)).floatValue()), (float)-5.0f, (float)5.0f)));
        this.setLeftTrack((float)((double)this.getLeftTrack() - 5.969026041820607 * s0 + Mth.clamp((double)(1.2566370801612687 * (double)((Float)this.entityData.get(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        this.setRightTrack((float)((double)this.getRightTrack() - 5.969026041820607 * s0 - Mth.clamp((double)(1.2566370801612687 * (double)((Float)this.entityData.get(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        this.setYRot((float)((double)this.getYRot() - (this.isInWater() && !this.onGround() ? 2.5 : 6.0) * (double)((Float)this.entityData.get(DELTA_ROT)).floatValue()));
        if (this.isInWater() || this.onGround()) {
            float power = ((Float)this.entityData.get(POWER)).floatValue() * Mth.clamp((float)(1.0f + (float)(s0 > 0.0 ? 1 : -1) * this.getXRot() / 35.0f), (float)0.0f, (float)2.0f);
            this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).scale((double)((!this.isInWater() && !this.onGround() ? 0.13f : (this.isInWater() && !this.onGround() ? 2.0f : 2.4f)) * power))));
        }
    }

    @Override
    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.PRISM_ENGINE.get();
    }

    @Override
    public float getEngineSoundVolume() {
        return Math.max((float)Mth.abs((float)((Float)this.entityData.get(POWER)).floatValue()), (float)Mth.abs((float)(0.1f * ((Float)this.entityData.get(DELTA_ROT)).floatValue()))) * 2.5f;
    }

    public void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.hasPassenger(passenger)) {
            return;
        }
        Matrix4f transform = this.getTurretTransform(1.0f);
        Matrix4f transformV = this.getVehicleTransform(1.0f);
        int i = this.getSeatIndex(passenger);
        Vector4f worldPosition = i == 0 ? this.transformPosition(transform, 0.0f, -0.6f, 0.0f) : this.transformPosition(transformV, -0.59375f, 1.0f, 3.0625f);
        passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.setYBodyRot(this.getBarrelYRot(1.0f));
        }
        if (entity == this.getNthEntity(1)) {
            entity.setYBodyRot(this.getYRot());
        }
    }

    @Override
    public int getMaxPassengers() {
        return 2;
    }

    public Vec3 driverPos(float ticks) {
        Matrix4f transform = this.getBarrelTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.5f, 1.2f, -0.1f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getBarrelTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.95f, 0.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).vectorTo(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.484375f, -0.2375f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.lerp((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.lerp((float)ticks, (float)this.xRotO, (float)this.getXRot());
        float z = Mth.lerp((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.XP.rotationDegrees(x + r * xV + r2 * z));
        return transformT;
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).vectorTo(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 2.14375f, 0.7375f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.YP.rotationDegrees(Mth.lerp((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    @Override
    public void destroy() {
        if (this.level() instanceof ServerLevel) {
            CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this.getAttacker(), this.getAttacker()), 80.0f, this.getX(), this.getY(), this.getZ(), 5.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
            explosion.explode();
            EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
            explosion.finalizeExplosion(false);
            ParticleTool.spawnMediumExplosionParticles(this.level(), this.position());
        }
        this.explodePassengers();
        super.destroy();
    }

    protected void clampRotation(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            float a = this.getTurretYaw(1.0f);
            float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            float min = -32.5f - r * this.getXRot() - r2 * this.getRoll();
            float max = 15.0f - r * this.getXRot() - r2 * this.getRoll();
            float f = Mth.wrapDegrees((float)entity.getXRot());
            float f1 = Mth.clamp((float)f, (float)min, (float)max);
            entity.xRotO += f1 - f;
            entity.setXRot(entity.getXRot() + f1 - f);
            entity.setYBodyRot(this.getBarrelYRot(1.0f));
        }
        if (entity == this.getNthEntity(1)) {
            float f = Mth.wrapDegrees((float)entity.getXRot());
            float f1 = Mth.clamp((float)f, (float)-80.0f, (float)10.0f);
            entity.xRotO += f1 - f;
            entity.setXRot(entity.getXRot() + f1 - f);
            float f2 = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
            float f3 = Mth.clamp((float)f2, (float)-100.0f, (float)100.0f);
            entity.yRotO += f3 - f2;
            entity.setYRot(entity.getYRot() + f3 - f2);
            entity.setYBodyRot(this.getYRot());
        }
    }

    public void onPassengerTurned(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public int mainGunRpm(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return 30;
        }
        if (this.getWeaponIndex(0) == 1) {
            return 0;
        }
        return 30;
    }

    @Override
    public boolean canShoot(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return this.getEnergy() > (Integer)VehicleConfig.PRISM_TANK_SHOOT_COST_MODE_1.get() && !this.cannotFire;
        }
        return false;
    }

    @Override
    public int getAmmoCount(Player player) {
        IEnergyStorage cap = (IEnergyStorage)this.getCapability(Capabilities.EnergyStorage.ENTITY, null);
        if (cap == null) {
            return 0;
        }
        return (int)((float)cap.getEnergyStored() * 100.0f / (float)this.getMaxEnergy());
    }

    @Override
    public boolean banHand(Player player) {
        return player == this.getFirstPassenger();
    }

    @Override
    public boolean hidePassenger(Entity entity) {
        return entity == this.getFirstPassenger();
    }

    @Override
    public int zoomFov() {
        return 3;
    }

    @Override
    public int getWeaponHeat(Player player) {
        return (Integer)this.entityData.get(HEAT);
    }

    @Override
    public boolean hasTracks() {
        return true;
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/prism_tank_icon.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        float minWH = Math.min((int)screenWidth, (int)screenHeight);
        float scaledMinWH = Mth.floor((float)(minWH * scale));
        float centerW = ((float)screenWidth - scaledMinWH) / 2.0f;
        float centerH = ((float)screenHeight - scaledMinWH) / 2.0f;
        RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/land/lav_missile_cross.png"), centerW, centerH, 0.0f, 0.0f, scaledMinWH, scaledMinWH, scaledMinWH, scaledMinWH);
        double heat = 1.0f - (float)((Integer)this.getEntityData().get(HEAT)).intValue() / 100.0f;
        guiGraphics.drawString(font, (Component)Component.literal((String)("LASER   " + ((Integer)this.getEntityData().get(HEAT) + 25) + " \u2103")), screenWidth / 2 - 33, screenHeight - 65, Mth.hsvToRgb((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderThirdPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        super.renderThirdPersonOverlay(guiGraphics, font, player, screenWidth, screenHeight, scale);
        double heat = (float)((Integer)this.getEntityData().get(HEAT)).intValue() / 100.0f;
        guiGraphics.drawString(font, (Component)Component.literal((String)("LASER " + ((Integer)this.getEntityData().get(HEAT) + 25) + " \u2103")), 30, -9, Mth.hsvToRgb((float)0.0f, (float)((float)heat), (float)1.0f), false);
    }

    @Override
    public boolean hasDecoy() {
        return true;
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return zoom ? 0.26 : 0.33;
    }

    @Override
    public boolean isEnclosed(int index) {
        return index == 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if ((zoom || isFirstPerson) && this.getSeatIndex((Entity)player) == 0) {
            return new Vec2((float)(-PrismTankEntity.getYRotFromVector(this.getBarrelVec(partialTicks))), (float)(-PrismTankEntity.getXRotFromVector(this.getBarrelVec(partialTicks))));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if ((zoom || isFirstPerson) && this.getSeatIndex((Entity)player) == 0) {
            if (zoom) {
                return new Vec3(this.driverZoomPos((float)partialTicks).x, this.driverZoomPos((float)partialTicks).y, this.driverZoomPos((float)partialTicks).z);
            }
            return new Vec3(this.driverPos((float)partialTicks).x, this.driverPos((float)partialTicks).y, this.driverPos((float)partialTicks).z);
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useFixedCameraPos(Entity entity) {
        return this.getSeatIndex(entity) == 0;
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/land.png");
    }
}

