/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.projectile.MelonBombEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.CameraTool;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.Pair;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Tom6Entity
extends MobileVehicleEntity
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> MELON = SynchedEntityData.defineId(Tom6Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float yRotSync;
    public float delta_xo;
    public float delta_yo;
    public float delta_x;
    public float delta_y;

    public Tom6Entity(EntityType<Tom6Entity> type, Level world) {
        super(type, world);
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(4.0, 1.0, 0.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MELON, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Melon", ((Boolean)this.entityData.get(MELON)).booleanValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(MELON, (Object)compound.getBoolean("Melon"));
    }

    @ParametersAreNonnullByDefault
    protected void playStepSound(BlockPos pPos, BlockState pState) {
        this.playSound((SoundEvent)ModSounds.WHEEL_STEP.get(), (float)(this.getDeltaMovement().length() * 0.3), this.random.nextFloat() * 0.1f + 1.0f);
    }

    @Override
    public boolean sendFireStarParticleOnHurt() {
        return false;
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        if (player.getMainHandItem().is(Items.MELON) && !((Boolean)this.entityData.get(MELON)).booleanValue()) {
            this.entityData.set(MELON, (Object)true);
            player.getMainHandItem().shrink(1);
            player.level().playSound(player, this.getOnPos(), SoundEvents.WOOD_PLACE, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    @Override
    public void baseTick() {
        this.delta_xo = this.delta_x;
        this.delta_yo = this.delta_y;
        super.baseTick();
        this.delta_x = ((Float)this.entityData.get(MOUSE_SPEED_Y)).floatValue();
        this.delta_y = ((Float)this.entityData.get(MOUSE_SPEED_X)).floatValue();
        float f = (float)Mth.clamp((double)(0.69f + 0.101f * Mth.abs((float)(90.0f - (float)Tom6Entity.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f)))) / 90.0f), (double)0.01, (double)0.99);
        boolean forward = Mth.abs((float)((float)Tom6Entity.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f)))) < 90.0f;
        this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).scale((forward ? 0.24 : -0.24) * this.getDeltaMovement().length())));
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, (double)f, (double)f));
        if (this.isInWater() && this.tickCount % 4 == 0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 0.6, 0.6));
            if (this.lastTickSpeed > 0.4) {
                this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, this.getFirstPassenger() == null ? this : this.getFirstPassenger()), (float)(20.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
            }
        }
        this.terrainCompact(1.0f, 1.2f);
        this.refreshDimensions();
    }

    @Override
    public void travel() {
        Entity passenger = this.getFirstPassenger();
        if (passenger == null || this.isInWater()) {
            this.leftInputDown = false;
            this.rightInputDown = false;
            this.forwardInputDown = false;
            this.backInputDown = false;
            this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() * 0.95f));
            if (this.onGround()) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.96, 1.0, 0.96));
            } else {
                this.setXRot(Mth.clamp((float)(this.getXRot() + 0.1f), (float)-89.0f, (float)89.0f));
            }
        } else if (passenger instanceof Player) {
            Player player = (Player)passenger;
            if (this.forwardInputDown && this.getEnergy() > 0) {
                this.consumeEnergy((Integer)VehicleConfig.TOM_6_ENERGY_COST.get());
                this.entityData.set(POWER, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.entityData.get(POWER)).floatValue() + 0.1f), (float)1.0f)));
            }
            if (this.backInputDown || this.downInputDown) {
                this.entityData.set(POWER, (Object)Float.valueOf(org.joml.Math.max((float)(((Float)this.entityData.get(POWER)).floatValue() - (((Float)this.entityData.get(POWER)).floatValue() > 0.0f ? 0.1f : 0.01f)), (float)(this.onGround() ? -0.2f : 0.2f))));
            }
            if (!this.onGround()) {
                if (this.rightInputDown) {
                    this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() - 0.4f));
                } else if (this.leftInputDown) {
                    this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() + 0.4f));
                }
            }
            float diffY = org.joml.Math.clamp((float)-90.0f, (float)90.0f, (float)Mth.wrapDegrees((float)(passenger.getYHeadRot() - this.getYRot())));
            float diffX = org.joml.Math.clamp((float)-60.0f, (float)60.0f, (float)Mth.wrapDegrees((float)(passenger.getXRot() - this.getXRot())));
            float roll = Mth.abs((float)Mth.clamp((float)(this.getRoll() / 60.0f), (float)-1.5f, (float)1.5f));
            float addY = Mth.clamp((float)(org.joml.Math.min((float)((this.onGround() ? 1.5f : 0.9f) * (float)org.joml.Math.max((double)(this.getDeltaMovement().length() - 0.06), (double)0.1)), (float)0.9f) * diffY - 0.5f * ((Float)this.entityData.get(DELTA_ROT)).floatValue()), (float)(-3.0f * (roll + 1.0f)), (float)(3.0f * (roll + 1.0f)));
            float addX = Mth.clamp((float)(org.joml.Math.min((float)((float)org.joml.Math.max((double)(this.getDeltaMovement().length() - 0.1), (double)0.01)), (float)0.9f) * diffX), (float)-4.0f, (float)4.0f);
            float addZ = ((Float)this.entityData.get(DELTA_ROT)).floatValue() - (this.onGround() ? 0.0f : 0.01f) * diffY * (float)this.getDeltaMovement().length();
            float i = this.getXRot() / 90.0f;
            this.yRotSync = addY * (1.0f - Mth.abs((float)i)) + addZ * i;
            this.setYRot(this.getYRot() + this.yRotSync);
            this.setXRot(Mth.clamp((float)(this.getXRot() + addX), (float)(this.onGround() ? -12.0f : -120.0f), (float)(this.onGround() ? 3.0f : 120.0f)));
            this.setZRot(this.getRoll() - addZ * (1.0f - Mth.abs((float)i)));
            if (this.upInputDown && !this.onGround() && ((Boolean)this.entityData.get(MELON)).booleanValue()) {
                this.entityData.set(MELON, (Object)false);
                Matrix4f transform = this.getVehicleTransform(1.0f);
                Vector4f worldPosition = this.transformPosition(transform, 0.0f, -0.2f, 0.0f);
                MelonBombEntity melonBomb = new MelonBombEntity((LivingEntity)player, player.level());
                melonBomb.setExplosionDamage(((Integer)VehicleConfig.TOM_6_BOMB_EXPLOSION_DAMAGE.get()).intValue());
                melonBomb.setExplosionRadius(((Double)VehicleConfig.TOM_6_BOMB_EXPLOSION_RADIUS.get()).floatValue());
                melonBomb.setPos(worldPosition.x, worldPosition.y, worldPosition.z);
                melonBomb.shoot(this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z, (float)this.getDeltaMovement().length(), 0.0f);
                passenger.level().addFreshEntity((Entity)melonBomb);
                this.level().playSound(null, this.getOnPos(), SoundEvents.IRON_DOOR_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.upInputDown = false;
            }
        }
        this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() * 0.995f));
        this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() * 0.95f));
        this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).scale(0.04 * (double)((Float)this.entityData.get(POWER)).floatValue())));
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, Mth.clamp((double)((double)(org.joml.Math.sin((float)((this.onGround() ? 45.0f : -(this.getXRot() - 20.0f)) * ((float)Math.PI / 180))) * org.joml.Math.sin((float)((90.0f - this.getXRot()) * ((float)Math.PI / 180)))) * this.getDeltaMovement().dot(this.getViewVector(1.0f)) * 0.04), (double)-0.04, (double)0.09), 0.0));
    }

    @Override
    public boolean engineRunning() {
        return this.getFirstPassenger() != null && org.joml.Math.abs((double)this.getDeltaMovement().length()) > 0.0;
    }

    @Override
    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.FLY_LOOP.get();
    }

    @Override
    public float getEngineSoundVolume() {
        return (float)this.getDeltaMovement().length();
    }

    protected void clampRotation(Entity entity) {
        float f = Mth.wrapDegrees((float)(entity.getXRot() - this.getXRot()));
        float f1 = Mth.clamp((float)f, (float)-85.0f, (float)60.0f);
        entity.xRotO += f1 - f;
        entity.setXRot(entity.getXRot() + f1 - f);
        entity.setYBodyRot(this.getYRot());
        float f2 = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
        float f3 = Mth.clamp((float)f2, (float)-45.0f, (float)45.0f);
        entity.yRotO += f3 - f2;
        entity.setYRot(entity.getYRot() + f3 - f2);
        entity.setYBodyRot(this.getYRot());
    }

    public void onPassengerTurned(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    public void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.hasPassenger(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        float x = 0.0f;
        float y = 0.05f;
        float z = -0.4f;
        int i = this.getSeatIndex(passenger);
        if (i == 0) {
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        }
        if (passenger != this.getFirstPassenger()) {
            passenger.setXRot(passenger.getXRot() + (this.getXRot() - this.xRotO));
        }
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        float i = this.getXRot() / 90.0f;
        float f = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
        float g = Mth.clamp((float)f, (float)-105.0f, (float)105.0f);
        entity.yRotO += g - f;
        entity.setYRot(entity.getYRot() + g - f + this.yRotSync * Mth.abs((float)i));
        entity.setYHeadRot(entity.getYRot());
        entity.setYBodyRot(this.getYRot());
    }

    @Override
    public Matrix4f getVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.lerp((double)ticks, (double)this.xo, (double)this.getX()), (float)Mth.lerp((double)ticks, (double)(this.yo + 0.5), (double)(this.getY() + 0.5)), (float)Mth.lerp((double)ticks, (double)this.zo, (double)this.getZ()));
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees(-Mth.lerp((float)ticks, (float)this.yRotO, (float)this.getYRot())));
        transform.rotate((Quaternionfc)Axis.XP.rotationDegrees(Mth.lerp((float)ticks, (float)this.xRotO, (float)this.getXRot())));
        transform.rotate((Quaternionfc)Axis.ZP.rotationDegrees(Mth.lerp((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    @Override
    public void destroy() {
        if (this.crash) {
            this.crashPassengers();
        } else {
            this.explodePassengers();
        }
        if (this.level() instanceof ServerLevel) {
            if (((Boolean)this.entityData.get(MELON)).booleanValue()) {
                CustomExplosion explosion = new CustomExplosion(this.level(), this, ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this, this.getAttacker()), ((Integer)VehicleConfig.TOM_6_BOMB_EXPLOSION_DAMAGE.get()).intValue(), this.getX(), this.getY(), this.getZ(), ((Double)VehicleConfig.TOM_6_BOMB_EXPLOSION_RADIUS.get()).floatValue(), (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP).setDamageMultiplier(1.0f);
                explosion.explode();
                EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
                explosion.finalizeExplosion(false);
                ParticleTool.spawnHugeExplosionParticles(this.level(), this.position());
            } else {
                CustomExplosion explosion = new CustomExplosion(this.level(), this, ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this, this.getAttacker()), 15.0f, this.getX(), this.getY(), this.getZ(), 2.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP).setDamageMultiplier(1.0f);
                explosion.explode();
                EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
                explosion.finalizeExplosion(false);
                ParticleTool.spawnMediumExplosionParticles(this.level(), this.position());
            }
        }
        super.destroy();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/tom_6_icon.png");
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return 0.3;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Pair<Quaternionf, Quaternionf> getPassengerRotation(Entity entity, float tickDelta) {
        return Pair.of((Object)Axis.XP.rotationDegrees(-this.getViewXRot(tickDelta)), (Object)Axis.ZP.rotationDegrees(-this.getRoll(tickDelta)));
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/aircraft.png");
    }

    public Matrix4f getClientVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.lerp((double)ticks, (double)this.xo, (double)this.getX()), (float)Mth.lerp((double)ticks, (double)(this.yo + 0.5), (double)(this.getY() + 0.5)), (float)Mth.lerp((double)ticks, (double)this.zo, (double)this.getZ()));
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees((float)((double)(-Mth.lerp((float)ticks, (float)this.yRotO, (float)this.getYRot())) + ClientMouseHandler.freeCameraYaw)));
        transform.rotate((Quaternionfc)Axis.XP.rotationDegrees((float)((double)Mth.lerp((float)ticks, (float)this.xRotO, (float)this.getXRot()) + ClientMouseHandler.freeCameraPitch)));
        transform.rotate((Quaternionfc)Axis.ZP.rotationDegrees(Mth.lerp((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (this.getSeatIndex((Entity)player) == 0 && (double)Mth.abs((float)((float)(ClientMouseHandler.freeCameraYaw * ClientMouseHandler.freeCameraPitch))) > 0.01) {
            return new Vec2((float)((double)(this.getYaw(partialTicks) - 0.5f * Mth.lerp((float)partialTicks, (float)this.delta_yo, (float)this.delta_y)) - ClientMouseHandler.freeCameraYaw), (float)((double)(this.getPitch(partialTicks) - 0.5f * Mth.lerp((float)partialTicks, (float)this.delta_xo, (float)this.delta_x)) + ClientMouseHandler.freeCameraPitch));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (this.getSeatIndex((Entity)player) == 0 && (double)Mth.abs((float)((float)(ClientMouseHandler.freeCameraYaw * ClientMouseHandler.freeCameraPitch))) > 0.01) {
            Matrix4f transform = this.getClientVehicleTransform(partialTicks);
            Vector4f maxCameraPosition = this.transformPosition(transform, 0.0f, 2.5f, -6.0f - (float)ClientMouseHandler.custom3pDistanceLerp);
            Vec3 finalPos = CameraTool.getMaxZoom(transform, maxCameraPosition);
            if (isFirstPerson) {
                return new Vec3(Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()), Mth.lerp((double)partialTicks, (double)(player.yo + (double)player.getEyeHeight()), (double)player.getEyeY()), Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()));
            }
            return finalPos;
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }
}

