/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.base;

import com.atsuishio.superbwarfare.capability.energy.SyncedEntityEnergyStorage;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.energy.IEnergyStorage;

public abstract class EnergyVehicleEntity
extends VehicleEntity {
    public static final EntityDataAccessor<Integer> ENERGY = SynchedEntityData.defineId(EnergyVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected final IEnergyStorage energyStorage;

    public EnergyVehicleEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.energyStorage = new SyncedEntityEnergyStorage(this.getMaxEnergy(), this.entityData, ENERGY);
        this.setEnergy(0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ENERGY, (Object)0);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        Tag tag = compound.get("Energy");
        if (tag instanceof IntTag) {
            IntTag energyNBT = (IntTag)tag;
            ((SyncedEntityEnergyStorage)this.energyStorage).deserializeNBT((HolderLookup.Provider)this.level().registryAccess(), (Tag)energyNBT);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("Energy", ((SyncedEntityEnergyStorage)this.energyStorage).serializeNBT((HolderLookup.Provider)this.level().registryAccess()));
    }

    public void consumeEnergy(int amount) {
        this.energyStorage.extractEnergy(amount, false);
    }

    public boolean canConsume(int amount) {
        return this.getEnergy() >= amount;
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void setEnergy(int pEnergy) {
        int targetEnergy = Mth.clamp((int)pEnergy, (int)0, (int)this.getMaxEnergy());
        if (targetEnergy > this.energyStorage.getEnergyStored()) {
            this.energyStorage.receiveEnergy(targetEnergy - this.energyStorage.getEnergyStored(), false);
        } else {
            this.energyStorage.extractEnergy(this.energyStorage.getEnergyStored() - targetEnergy, false);
        }
    }

    public int getMaxEnergy() {
        return this.data().maxEnergy();
    }
}

