/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.damage;

import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModify;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;

public class DamageModifier {
    private final List<DamageModify> immuneList = new ArrayList<DamageModify>();
    private final List<DamageModify> reduceList = new ArrayList<DamageModify>();
    private final List<DamageModify> multiplyList = new ArrayList<DamageModify>();
    private final List<BiFunction<DamageSource, Float, Float>> customList = new ArrayList<BiFunction<DamageSource, Float, Float>>();

    public DamageModifier immuneTo() {
        this.immuneList.add(new DamageModify(DamageModify.ModifyType.IMMUNITY, 0.0f));
        return this;
    }

    public DamageModifier immuneTo(TagKey<DamageType> sourceTagKey) {
        this.immuneList.add(new DamageModify(DamageModify.ModifyType.IMMUNITY, 0.0f, sourceTagKey));
        return this;
    }

    public DamageModifier immuneTo(ResourceKey<DamageType> sourceKey) {
        this.immuneList.add(new DamageModify(DamageModify.ModifyType.IMMUNITY, 0.0f, sourceKey));
        return this;
    }

    public DamageModifier immuneTo(Function<DamageSource, Boolean> condition) {
        this.immuneList.add(new DamageModify(DamageModify.ModifyType.IMMUNITY, 0.0f, condition));
        return this;
    }

    public DamageModifier immuneTo(String entityId) {
        this.immuneList.add(new DamageModify(DamageModify.ModifyType.IMMUNITY, 0.0f, entityId));
        return this;
    }

    public DamageModifier immuneTo(EntityType<?> type) {
        return this.immuneTo(EntityType.getKey(type).toString());
    }

    public DamageModifier reduce(float value) {
        this.reduceList.add(new DamageModify(DamageModify.ModifyType.REDUCE, value));
        return this;
    }

    public DamageModifier reduce(float value, TagKey<DamageType> sourceTagKey) {
        this.reduceList.add(new DamageModify(DamageModify.ModifyType.REDUCE, value, sourceTagKey));
        return this;
    }

    public DamageModifier reduce(float value, ResourceKey<DamageType> sourceKey) {
        this.reduceList.add(new DamageModify(DamageModify.ModifyType.REDUCE, value, sourceKey));
        return this;
    }

    public DamageModifier reduce(float value, Function<DamageSource, Boolean> condition) {
        this.reduceList.add(new DamageModify(DamageModify.ModifyType.REDUCE, value, condition));
        return this;
    }

    public DamageModifier reduce(float value, String entityId) {
        this.reduceList.add(new DamageModify(DamageModify.ModifyType.REDUCE, value, entityId));
        return this;
    }

    public DamageModifier reduce(float value, EntityType<?> type) {
        return this.reduce(value, EntityType.getKey(type).toString());
    }

    public DamageModifier multiply(float value) {
        this.multiplyList.add(new DamageModify(DamageModify.ModifyType.MULTIPLY, value));
        return this;
    }

    public DamageModifier multiply(float value, TagKey<DamageType> sourceTagKey) {
        this.multiplyList.add(new DamageModify(DamageModify.ModifyType.MULTIPLY, value, sourceTagKey));
        return this;
    }

    public DamageModifier multiply(float value, ResourceKey<DamageType> sourceKey) {
        this.multiplyList.add(new DamageModify(DamageModify.ModifyType.MULTIPLY, value, sourceKey));
        return this;
    }

    public DamageModifier multiply(float value, Function<DamageSource, Boolean> condition) {
        this.multiplyList.add(new DamageModify(DamageModify.ModifyType.MULTIPLY, value, condition));
        return this;
    }

    public DamageModifier multiply(float value, String entityId) {
        this.multiplyList.add(new DamageModify(DamageModify.ModifyType.MULTIPLY, value, entityId));
        return this;
    }

    public DamageModifier multiply(float value, EntityType<?> type) {
        return this.multiply(value, EntityType.getKey(type).toString());
    }

    public DamageModifier custom(BiFunction<DamageSource, Float, Float> damageModifyFunction) {
        this.customList.add(damageModifyFunction);
        return this;
    }

    public DamageModifier addAll(List<DamageModify> list) {
        for (DamageModify damageModify : list) {
            switch (damageModify.getType()) {
                case IMMUNITY: {
                    this.immuneList.add(damageModify);
                    break;
                }
                case REDUCE: {
                    this.reduceList.add(damageModify);
                    break;
                }
                case MULTIPLY: {
                    this.multiplyList.add(damageModify);
                }
            }
        }
        return this;
    }

    public float compute(DamageSource source, float damage) {
        ArrayList<DamageModify> list = new ArrayList<DamageModify>();
        list.addAll(this.immuneList);
        list.addAll(this.reduceList);
        list.addAll(this.multiplyList);
        for (DamageModify damageModify : list) {
            if (!damageModify.match(source) || !((damage = damageModify.compute(damage)) <= 0.0f)) continue;
            return 0.0f;
        }
        for (BiFunction biFunction : this.customList) {
            damage = ((Float)biFunction.apply(source, Float.valueOf(damage))).floatValue();
        }
        return damage;
    }
}

