/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.damage;

import com.google.gson.annotations.SerializedName;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class DamageModify {
    @SerializedName(value="Value")
    private float value = 0.0f;
    @SerializedName(value="Type")
    private ModifyType type = ModifyType.IMMUNITY;
    @SerializedName(value="Source")
    private String source = "All";
    private transient String entityId = "";
    private transient SourceType sourceType = null;
    private transient TagKey<DamageType> sourceTagKey = null;
    private transient ResourceKey<DamageType> sourceKey = null;
    private transient Function<DamageSource, Boolean> condition = null;

    public ModifyType getType() {
        return this.type;
    }

    public DamageModify() {
    }

    public DamageModify(ModifyType type, float value) {
        this.type = type;
        this.value = value;
        this.sourceType = SourceType.ALL;
    }

    public DamageModify(ModifyType type, float value, TagKey<DamageType> sourceTagKey) {
        this.type = type;
        this.value = value;
        this.sourceTagKey = sourceTagKey;
        this.sourceType = SourceType.TAG_KEY;
    }

    public DamageModify(ModifyType type, float value, ResourceKey<DamageType> sourceKey) {
        this.type = type;
        this.value = value;
        this.sourceKey = sourceKey;
        this.sourceType = SourceType.RESOURCE_KEY;
    }

    public DamageModify(ModifyType type, float value, Function<DamageSource, Boolean> condition) {
        this.type = type;
        this.value = value;
        this.condition = condition;
        this.sourceType = SourceType.FUNCTION;
    }

    public DamageModify(ModifyType type, float value, String entityId) {
        this.type = type;
        this.value = value;
        this.entityId = entityId;
        this.sourceType = SourceType.ENTITY_ID;
    }

    private void generateSourceType() {
        if (this.source.startsWith("#")) {
            this.sourceType = SourceType.TAG_KEY;
            this.sourceTagKey = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)this.source.substring(1)));
        } else if (this.source.startsWith("@")) {
            this.sourceType = SourceType.ENTITY_ID;
            this.entityId = this.source.substring(1);
        } else if (!this.source.equals("All")) {
            this.sourceType = SourceType.RESOURCE_KEY;
            this.sourceKey = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)this.source));
        } else {
            this.sourceType = SourceType.ALL;
        }
    }

    public boolean match(DamageSource source) {
        if (source == null) {
            return false;
        }
        if (this.sourceType == null) {
            this.generateSourceType();
        }
        return switch (this.sourceType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> source.is(this.sourceTagKey);
            case 1 -> source.is(this.sourceKey);
            case 2 -> this.condition.apply(source);
            case 3 -> {
                Entity directEntity = source.getDirectEntity();
                Entity entity = source.getEntity();
                if (directEntity != null) {
                    yield EntityType.getKey((EntityType)directEntity.getType()).toString().equals(this.entityId);
                }
                if (entity != null) {
                    yield EntityType.getKey((EntityType)entity.getType()).toString().equals(this.entityId);
                }
                yield false;
            }
            case 4 -> true;
        };
    }

    public float compute(float damage) {
        if (this.type == null) {
            return 0.0f;
        }
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0.0f;
            case 1 -> Math.max(damage - this.value, 0.0f);
            case 2 -> damage * this.value;
        };
    }

    public static enum ModifyType {
        IMMUNITY,
        REDUCE,
        MULTIPLY;

    }

    private static enum SourceType {
        TAG_KEY,
        RESOURCE_KEY,
        FUNCTION,
        ENTITY_ID,
        ALL;

    }
}

