/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.event;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.api.event.ReloadEvent;
import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.subdata.Reload;
import com.atsuishio.superbwarfare.data.gun.value.ReloadState;
import com.atsuishio.superbwarfare.init.ModAttachments;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.function.Consumer;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="superbwarfare")
public class GunEventHandler {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() instanceof GunItem) {
            GunData data = GunData.from(stack);
            GunEventHandler.handleGunBolt(data);
            GunEventHandler.handleGunReload(player, data);
            GunEventHandler.handleGunSingleReload(player, data);
            GunEventHandler.handleSentinelCharge(player, data);
            data.save();
        }
    }

    private static void handleGunBolt(GunData data) {
        ItemStack stack = data.stack();
        if (stack.is(ModTags.Items.NORMAL_GUN)) {
            data.bolt.actionTimer.reduce();
            if (stack.getItem() == ModItems.MARLIN.get() && data.bolt.actionTimer.get() == 9) {
                data.isEmpty.set(false);
            }
            if (data.bolt.actionTimer.get() == 1) {
                data.bolt.needed.set(false);
            }
        }
    }

    public static void playGunBoltSounds(Player player) {
        String origin;
        String name;
        SoundEvent sound1p;
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        if (!player.level().isClientSide && (sound1p = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(Mod.loc((name = (origin = stack.getItem().getDescriptionId()).substring(origin.lastIndexOf(".") + 1)) + "_bolt"))) != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundTool.playLocalSound(serverPlayer, sound1p, 2.0f, 1.0f);
            double shooterHeight = player.getEyePosition().distanceTo(Vec3.atLowerCornerOf((Vec3i)player.level().clip(new ClipContext(player.getEyePosition(), player.getEyePosition().add(new Vec3(0.0, -1.0, 0.0).scale(10.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).getBlockPos()));
            Mod.queueServerWork((int)((double)(data.bolt.actionTimer.get() / 2) + 1.5 * shooterHeight), () -> {
                Ammo ammoType = data.ammoTypeInfo().playerAmmoType();
                if (ammoType != null) {
                    switch (ammoType) {
                        case SHOTGUN: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_SHOTGUN.get(), (float)Math.max(0.75 - 0.12 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                        case SNIPER: 
                        case HEAVY: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_50CAL.get(), (float)Math.max(1.0 - 0.15 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                        default: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_NORMAL.get(), (float)Math.max(1.5 - 0.2 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                    }
                } else {
                    SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_NORMAL.get(), (float)Math.max(1.5 - 0.2 * shooterHeight, 0.0), 1.0f);
                }
            });
        }
    }

    private static void handleGunReload(Player player, GunData data) {
        ItemStack stack = data.stack();
        GunItem gunItem = data.item();
        Reload reload = data.reload;
        if (reload.reloadStarter.start()) {
            NeoForge.EVENT_BUS.post((Event)new ReloadEvent.Pre(player, data));
            if (gunItem.isOpenBolt(stack)) {
                if (data.ammo.get() == 0) {
                    reload.setTime(data.defaultEmptyReloadTime() + 1);
                    reload.setState(ReloadState.EMPTY_RELOADING);
                    GunEventHandler.playGunEmptyReloadSounds(player);
                } else {
                    reload.setTime(data.defaultNormalReloadTime() + 1);
                    reload.setState(ReloadState.NORMAL_RELOADING);
                    GunEventHandler.playGunNormalReloadSounds(player);
                }
            } else {
                reload.setTime(data.defaultEmptyReloadTime() + 2);
                reload.setState(ReloadState.EMPTY_RELOADING);
                GunEventHandler.playGunEmptyReloadSounds(player);
            }
        }
        reload.reduce();
        Consumer<GunData> behavior = gunItem.reloadTimeBehaviors.get(reload.time());
        if (behavior != null) {
            behavior.accept(data);
        }
        if (reload.time() == 1) {
            if (gunItem.isOpenBolt(stack)) {
                if (data.ammo.get() == 0) {
                    GunEventHandler.playGunEmptyReload(player, data);
                } else {
                    GunEventHandler.playGunNormalReload(player, data);
                }
            } else {
                GunEventHandler.playGunEmptyReload(player, data);
            }
            reload.setTime(0);
            reload.setState(ReloadState.NOT_RELOADING);
            reload.reloadStarter.finish();
        }
    }

    public static void playGunNormalReload(Player player, GunData data) {
        ItemStack stack = data.stack();
        GunItem gunItem = data.item();
        if (player.getInventory().hasAnyMatching(item -> item.is((Item)ModItems.CREATIVE_AMMO_BOX.get()))) {
            data.ammo.set(data.magazine() + (gunItem.hasBulletInBarrel(stack) ? 1 : 0));
        } else {
            GunData.AmmoTypeInfo ammoTypeInfo = data.ammoTypeInfo();
            if (ammoTypeInfo.type() == GunData.AmmoConsumeType.PLAYER_AMMO) {
                data.reload(player, gunItem.hasBulletInBarrel(stack));
            }
        }
        data.reload.setState(ReloadState.NOT_RELOADING);
        NeoForge.EVENT_BUS.post((Event)new ReloadEvent.Post(player, data));
    }

    public static void playGunEmptyReload(Player player, GunData data) {
        if (player.getInventory().hasAnyMatching(item -> item.is((Item)ModItems.CREATIVE_AMMO_BOX.get()))) {
            data.ammo.set(data.magazine());
        } else {
            data.reload(player);
        }
        NeoForge.EVENT_BUS.post((Event)new ReloadEvent.Post(player, data));
    }

    public static void playGunEmptyReloadSounds(Player player) {
        String origin;
        String name;
        SoundEvent sound1p;
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        if (!player.level().isClientSide && (sound1p = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(Mod.loc((name = (origin = stack.getItem().getDescriptionId()).substring(origin.lastIndexOf(".") + 1)) + "_reload_empty"))) != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundTool.playLocalSound(serverPlayer, sound1p, 10.0f, 1.0f);
        }
    }

    public static void playGunNormalReloadSounds(Player player) {
        String origin;
        String name;
        SoundEvent sound1p;
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        if (!player.level().isClientSide && (sound1p = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(Mod.loc((name = (origin = stack.getItem().getDescriptionId()).substring(origin.lastIndexOf(".") + 1)) + "_reload_normal"))) != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundTool.playLocalSound(serverPlayer, sound1p, 10.0f, 1.0f);
        }
    }

    private static void handleGunSingleReload(Player player, GunData data) {
        ItemStack stack = data.stack();
        Reload reload = data.reload;
        reload.prepareTimer.reduce();
        reload.prepareLoadTimer.reduce();
        reload.iterativeLoadTimer.reduce();
        reload.finishTimer.reduce();
        if (reload.singleReloadStarter.start()) {
            NeoForge.EVENT_BUS.post((Event)new ReloadEvent.Pre(player, data));
            if (data.defaultPrepareLoadTime() != 0 && data.ammo.get() == 0) {
                GunEventHandler.playGunPrepareLoadReloadSounds(player);
                int prepareLoadTime = data.defaultPrepareLoadTime();
                reload.prepareLoadTimer.set(prepareLoadTime + 1);
                player.getCooldowns().addCooldown(stack.getItem(), prepareLoadTime);
            } else if (data.defaultPrepareEmptyTime() != 0 && data.ammo.get() == 0) {
                GunEventHandler.playGunEmptyPrepareSounds(player);
                int prepareEmptyTime = data.defaultPrepareEmptyTime();
                reload.prepareTimer.set(prepareEmptyTime + 1);
                player.getCooldowns().addCooldown(stack.getItem(), prepareEmptyTime);
            } else {
                GunEventHandler.playGunPrepareReloadSounds(player);
                int prepareTime = data.defaultPrepareTime();
                reload.prepareTimer.set(prepareTime + 1);
                player.getCooldowns().addCooldown(stack.getItem(), prepareTime);
            }
            data.forceStop.set(false);
            data.stopped.set(false);
            reload.setStage(1);
            reload.setState(ReloadState.NORMAL_RELOADING);
        }
        if (reload.prepareLoadTimer.get() == data.prepareAmmoLoadTime()) {
            GunEventHandler.iterativeLoad(player, data);
        }
        if (reload.prepareTimer.get() == 1 || reload.prepareLoadTimer.get() == 1) {
            if (!data.hasBackupAmmo(player) || data.ammo.get() >= data.magazine()) {
                reload.stage3Starter.markStart();
            } else {
                reload.setStage(2);
            }
        }
        if (data.forceStop.get() && reload.stage() == 2 && reload.iterativeLoadTimer.get() > 0) {
            data.stopped.set(true);
        }
        if (!(reload.prepareTimer.get() != 0 && reload.iterativeLoadTimer.get() != 0 || reload.stage() != 2 || reload.iterativeLoadTimer.get() != 0 || data.stopped.get() || data.ammo.get() >= data.magazine())) {
            GunEventHandler.playGunLoopReloadSounds(player);
            int iterativeTime = data.defaultIterativeTime();
            reload.iterativeLoadTimer.set(iterativeTime);
            player.getCooldowns().addCooldown(stack.getItem(), iterativeTime);
            data.loadIndex.set(data.loadIndex.get() == 1 ? 0 : 1);
        }
        if (data.iterativeAmmoLoadTime() == reload.iterativeLoadTimer.get()) {
            GunEventHandler.iterativeLoad(player, data);
        }
        if (reload.iterativeLoadTimer.get() == 1) {
            if (!data.hasBackupAmmo(player) || data.ammo.get() >= data.magazine()) {
                reload.setStage(3);
            }
            if (data.stopped.get()) {
                reload.setStage(3);
                data.stopped.set(false);
                data.forceStop.set(false);
            }
        }
        if (reload.iterativeLoadTimer.get() == 1 && reload.stage() == 3 || reload.stage3Starter.shouldStart()) {
            reload.setStage(3);
            reload.stage3Starter.finish();
            int finishTime = data.defaultFinishTime();
            reload.finishTimer.set(finishTime + 2);
            player.getCooldowns().addCooldown(stack.getItem(), finishTime + 2);
            GunEventHandler.playGunEndReloadSounds(player);
        }
        if (stack.getItem() == ModItems.MARLIN.get() && reload.finishTimer.get() == 10) {
            data.isEmpty.set(false);
        }
        if (reload.finishTimer.get() == 1) {
            reload.setStage(0);
            if (data.defaultActionTime() > 0) {
                data.bolt.needed.set(false);
            }
            reload.setState(ReloadState.NOT_RELOADING);
            reload.singleReloadStarter.finish();
            NeoForge.EVENT_BUS.post((Event)new ReloadEvent.Post(player, data));
        }
    }

    public static void iterativeLoad(Player player, GunData data) {
        int required = Math.min(data.magazine() - data.ammo.get(), data.iterativeLoadAmount());
        int available = Math.min(required, data.countBackupAmmo(player));
        data.ammo.add(available);
        if (!InventoryTool.hasCreativeAmmoBox(player)) {
            PlayerVariable cap = (PlayerVariable)player.getData(ModAttachments.PLAYER_VARIABLE);
            data.consumeBackupAmmo(player, available);
            player.setData(ModAttachments.PLAYER_VARIABLE, (Object)cap);
        }
    }

    public static void playGunPrepareReloadSounds(Player player) {
        String origin;
        String name;
        SoundEvent sound1p;
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        if (!player.level().isClientSide && (sound1p = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(Mod.loc((name = (origin = stack.getItem().getDescriptionId()).substring(origin.lastIndexOf(".") + 1)) + "_prepare"))) != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundTool.playLocalSound(serverPlayer, sound1p, 10.0f, 1.0f);
        }
    }

    public static void playGunEmptyPrepareSounds(Player player) {
        String origin;
        String name;
        SoundEvent sound1p;
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        if (!player.level().isClientSide && (sound1p = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(Mod.loc((name = (origin = stack.getItem().getDescriptionId()).substring(origin.lastIndexOf(".") + 1)) + "_prepare_empty"))) != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundTool.playLocalSound(serverPlayer, sound1p, 10.0f, 1.0f);
            double shooterHeight = player.getEyePosition().distanceTo(Vec3.atLowerCornerOf((Vec3i)player.level().clip(new ClipContext(player.getEyePosition(), player.getEyePosition().add(new Vec3(0.0, -1.0, 0.0).scale(10.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).getBlockPos()));
            Mod.queueServerWork((int)((double)(data.defaultPrepareEmptyTime() / 2 + 3) + 1.5 * shooterHeight), () -> {
                Ammo ammoType = data.ammoTypeInfo().playerAmmoType();
                if (ammoType != null) {
                    switch (ammoType) {
                        case SHOTGUN: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_SHOTGUN.get(), (float)Math.max(0.75 - 0.12 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                        case SNIPER: 
                        case HEAVY: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_50CAL.get(), (float)Math.max(1.0 - 0.15 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                        default: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_NORMAL.get(), (float)Math.max(1.5 - 0.2 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                    }
                } else {
                    SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_NORMAL.get(), (float)Math.max(1.5 - 0.2 * shooterHeight, 0.0), 1.0f);
                }
            });
        }
    }

    public static void playGunPrepareLoadReloadSounds(Player player) {
        String origin;
        String name;
        SoundEvent sound1p;
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        if (!player.level().isClientSide && (sound1p = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(Mod.loc((name = (origin = stack.getItem().getDescriptionId()).substring(origin.lastIndexOf(".") + 1)) + "_prepare_load"))) != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundTool.playLocalSound(serverPlayer, sound1p, 10.0f, 1.0f);
            double shooterHeight = player.getEyePosition().distanceTo(Vec3.atLowerCornerOf((Vec3i)player.level().clip(new ClipContext(player.getEyePosition(), player.getEyePosition().add(new Vec3(0.0, -1.0, 0.0).scale(10.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).getBlockPos()));
            Mod.queueServerWork((int)(8.0 + 1.5 * shooterHeight), () -> {
                Ammo ammoType = data.ammoTypeInfo().playerAmmoType();
                if (ammoType != null) {
                    switch (ammoType) {
                        case SHOTGUN: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_SHOTGUN.get(), (float)Math.max(0.75 - 0.12 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                        case SNIPER: 
                        case HEAVY: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_50CAL.get(), (float)Math.max(1.0 - 0.15 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                        default: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_NORMAL.get(), (float)Math.max(1.5 - 0.2 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                    }
                } else {
                    SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_NORMAL.get(), (float)Math.max(1.5 - 0.2 * shooterHeight, 0.0), 1.0f);
                }
            });
        }
    }

    public static void playGunLoopReloadSounds(Player player) {
        String origin;
        String name;
        SoundEvent sound1p;
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        if (!player.level().isClientSide && (sound1p = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(Mod.loc((name = (origin = stack.getItem().getDescriptionId()).substring(origin.lastIndexOf(".") + 1)) + "_loop"))) != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundTool.playLocalSound(serverPlayer, sound1p, 10.0f, 1.0f);
        }
    }

    public static void playGunEndReloadSounds(Player player) {
        String origin;
        String name;
        SoundEvent sound1p;
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        if (!player.level().isClientSide && (sound1p = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(Mod.loc((name = (origin = stack.getItem().getDescriptionId()).substring(origin.lastIndexOf(".") + 1)) + "_end"))) != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundTool.playLocalSound(serverPlayer, sound1p, 10.0f, 1.0f);
            double shooterHeight = player.getEyePosition().distanceTo(Vec3.atLowerCornerOf((Vec3i)player.level().clip(new ClipContext(player.getEyePosition(), player.getEyePosition().add(new Vec3(0.0, -1.0, 0.0).scale(10.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).getBlockPos()));
            if (stack.is((Item)ModItems.MARLIN.get())) {
                Mod.queueServerWork((int)(5.0 + 1.5 * shooterHeight), () -> SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_NORMAL.get(), (float)Math.max(1.5 - 0.2 * shooterHeight, 0.0), 1.0f));
            }
        }
    }

    private static void handleSentinelCharge(Player player, GunData data) {
        if (data.charge.starter.start()) {
            data.charge.timer.set(127);
            SoundEvent sound1p = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(Mod.loc("sentinel_charge"));
            if (sound1p != null && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SoundTool.playLocalSound(serverPlayer, sound1p, 2.0f, 1.0f);
            }
        }
        data.charge.timer.reduce();
        if (data.charge.timer.get() == 17) {
            for (ItemStack cell : player.getInventory().items) {
                IEnergyStorage stackStorage;
                if (!cell.is((Item)ModItems.CELL.get()) || (stackStorage = (IEnergyStorage)data.stack().getCapability(Capabilities.EnergyStorage.ITEM)) == null) continue;
                int stackMaxEnergy = stackStorage.getMaxEnergyStored();
                int stackEnergy = stackStorage.getEnergyStored();
                IEnergyStorage cellStorage = (IEnergyStorage)cell.getCapability(Capabilities.EnergyStorage.ITEM);
                if (cellStorage == null) continue;
                int cellEnergy = cellStorage.getEnergyStored();
                int stackEnergyNeed = Math.min(cellEnergy, stackMaxEnergy - stackEnergy);
                if (cellEnergy > 0) {
                    stackStorage.receiveEnergy(stackEnergyNeed, false);
                }
                cellStorage.extractEnergy(stackEnergyNeed, false);
            }
        }
    }
}

