/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.client.tooltip.component.CellImageComponent;
import com.atsuishio.superbwarfare.item.EnergyStorageItem;
import java.util.Optional;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class BatteryItem
extends Item
implements EnergyStorageItem {
    public int maxEnergy;

    public BatteryItem(int maxEnergy, Item.Properties properties) {
        super(properties.stacksTo(1));
        this.maxEnergy = maxEnergy;
    }

    public boolean isBarVisible(ItemStack pStack) {
        IEnergyStorage cap = (IEnergyStorage)pStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (cap == null) {
            return false;
        }
        return cap.getEnergyStored() != cap.getMaxEnergyStored();
    }

    public int getBarWidth(ItemStack pStack) {
        int energy = 0;
        IEnergyStorage cap = (IEnergyStorage)pStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (cap != null) {
            energy = cap.getEnergyStored();
        }
        return Math.round((float)energy * 13.0f / (float)this.maxEnergy);
    }

    public int getBarColor(@NotNull ItemStack pStack) {
        return 0xFFFF00;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        return Optional.of(new CellImageComponent(pStack));
    }

    public ItemStack makeFullEnergyStack() {
        ItemStack stack = new ItemStack((ItemLike)this);
        IEnergyStorage cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (cap == null) {
            return stack;
        }
        cap.receiveEnergy(this.maxEnergy, false);
        return stack;
    }

    @Override
    public int getMaxEnergy() {
        return this.maxEnergy;
    }
}

