/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.capability.laser.LaserCapability;
import com.atsuishio.superbwarfare.capability.laser.LaserHandler;
import com.atsuishio.superbwarfare.client.TooltipTool;
import com.atsuishio.superbwarfare.entity.projectile.LaserEntity;
import com.atsuishio.superbwarfare.init.ModCapabilities;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.network.message.send.LaserShootMessage;
import com.atsuishio.superbwarfare.tools.TraceTool;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class BeamTest
extends Item {
    public BeamTest() {
        super(new Item.Properties());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        if (player.level().isClientSide) {
            player.playSound((SoundEvent)ModSounds.CHARGE_RIFLE_FIRE_1P.get(), 1.0f, 1.0f);
        } else {
            player.playSound((SoundEvent)ModSounds.CHARGE_RIFLE_FIRE_3P.get(), 2.0f, 1.0f);
        }
        LaserCapability capability = (LaserCapability)player.getCapability(ModCapabilities.LASER_CAPABILITY);
        if (capability != null) {
            player.startUsingItem(hand);
            if (!level.isClientSide) {
                double px = player.getX();
                double py = player.getY() + (double)(player.getBbHeight() * 0.6f);
                double pz = player.getZ();
                float yHeadRotAngle = (float)Math.toRadians(player.yHeadRot + 90.0f);
                float xHeadRotAngle = (float)(-Math.toRadians(player.getXRot()));
                LaserEntity laserEntity = new LaserEntity(player.level(), (LivingEntity)player, px, py, pz, yHeadRotAngle, xHeadRotAngle, 6000);
                capability.init(new LaserHandler((LivingEntity)player, laserEntity));
                capability.start();
            }
        }
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }

    @ParametersAreNonnullByDefault
    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        Player player;
        LaserCapability cap;
        if (livingEntity instanceof Player && (cap = (LaserCapability)(player = (Player)livingEntity).getCapability(ModCapabilities.LASER_CAPABILITY)) != null) {
            cap.stop();
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            Item item = stack.getItem();
            if (item instanceof BeamTest) {
                BeamTest beamTest = (BeamTest)item;
                BeamTest.stopGunChargeSound(serverPlayer, beamTest);
            }
        }
        super.releaseUsing(stack, level, livingEntity, timeCharged);
    }

    private static void stopGunChargeSound(ServerPlayer player, BeamTest beamTest) {
        beamTest.getChargeSound().forEach(sound -> {
            ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(sound.getLocation(), SoundSource.PLAYERS);
            Vec3 center = new Vec3(player.getX(), player.getY(), player.getZ());
            for (ServerPlayer player1 : player.level().getEntitiesOfClass(ServerPlayer.class, new AABB(center, center).inflate(48.0), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList()) {
                player1.connection.send((Packet)clientboundstopsoundpacket);
            }
        });
    }

    public Set<SoundEvent> getChargeSound() {
        return Set.of((SoundEvent)ModSounds.CHARGE_RIFLE_FIRE_1P.get(), (SoundEvent)ModSounds.CHARGE_RIFLE_FIRE_3P.get());
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            LaserCapability cap = (LaserCapability)player.getCapability(ModCapabilities.LASER_CAPABILITY);
            if (cap != null) {
                cap.stop();
            }
            player.getCooldowns().addCooldown(pStack.getItem(), 20);
            if (player.level().isClientSide()) {
                BeamTest.beamShoot(player);
                player.playSound((SoundEvent)ModSounds.CHARGE_RIFLE_FIRE_BOOM_1P.get(), 1.0f, 1.0f);
            }
            if (!player.level().isClientSide) {
                player.playSound((SoundEvent)ModSounds.CHARGE_RIFLE_FIRE_BOOM_3P.get(), 4.0f, 1.0f);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShakeClientMessage(10.0, 10.0, 30.0, serverPlayer.getX(), serverPlayer.getEyeY(), serverPlayer.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return super.finishUsingItem(pStack, pLevel, pLivingEntity);
    }

    public static void beamShoot(Player player) {
        Player player_;
        boolean canAttack;
        Entity lookingEntity = TraceTool.laserfindLookingEntity((Entity)player, 512.0);
        if (lookingEntity == null) {
            return;
        }
        boolean bl = canAttack = lookingEntity != player && (!(lookingEntity instanceof Player) || !(player_ = (Player)lookingEntity).isCreative() && !player_.isSpectator()) && (!player.isAlliedTo(lookingEntity) || lookingEntity.getTeam() == null || lookingEntity.getTeam().getName().equals("TDM"));
        if (canAttack) {
            PacketDistributor.sendToServer((CustomPacketPayload)new LaserShootMessage(45.0, lookingEntity.getUUID(), TraceTool.laserHeadshot), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @ParametersAreNonnullByDefault
    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 11;
    }

    @ParametersAreNonnullByDefault
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        TooltipTool.addDevelopingText(tooltipComponents);
    }
}

