/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.entity.projectile.C4Entity;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import java.util.List;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class Detonator
extends Item {
    public Detonator() {
        super(new Item.Properties().stacksTo(1));
    }

    public static List<Entity> getC4(Player player, Level level) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).getAll().spliterator(), false).filter(e -> {
            C4Entity c4;
            return e instanceof C4Entity && (c4 = (C4Entity)((Object)e)).getOwner() == player;
        }).toList();
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        player.getCooldowns().addCooldown(stack.getItem(), 10);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.C4_DETONATOR_CLICK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.releaseUsing(stack, player.level(), (LivingEntity)player, 1);
        List<Entity> entities = Detonator.getC4(player, player.level());
        for (Entity e : entities) {
            C4Entity c4;
            if (!(e instanceof C4Entity) || !((Boolean)(c4 = (C4Entity)e).getEntityData().get(C4Entity.IS_CONTROLLABLE)).booleanValue()) continue;
            c4.explode();
        }
        return InteractionResultHolder.consume((Object)stack);
    }
}

